/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.rag.service.RagResponse;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.tools.RagOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/embabel/agent/rag/tools/SingleShotRagServiceSearchTools;", "", "options", "Lcom/embabel/agent/rag/tools/RagOptions;", "<init>", "(Lcom/embabel/agent/rag/tools/RagOptions;)V", "getOptions", "()Lcom/embabel/agent/rag/tools/RagOptions;", "search", "", "query", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nSingleShotRagServiceSearchTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleShotRagServiceSearchTools.kt\ncom/embabel/agent/rag/tools/SingleShotRagServiceSearchTools\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,46:1\n27#2:47\n*S KotlinDebug\n*F\n+ 1 SingleShotRagServiceSearchTools.kt\ncom/embabel/agent/rag/tools/SingleShotRagServiceSearchTools\n*L\n41#1:47\n*E\n"})
public final class SingleShotRagServiceSearchTools {
    @NotNull
    private final RagOptions options;

    public SingleShotRagServiceSearchTools(@NotNull RagOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final RagOptions getOptions() {
        return this.options;
    }

    @LlmTool(description="Search for information relating to this query. Returns detailed results")
    @NotNull
    public final String search(@LlmTool.Param(description="Standalone query to search for. Include sufficient context") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        RagResponse ragResponse = this.options.getRagService().search(this.options.toRequest(query));
        String asString = this.options.getRetrievableResultsFormatter().formatResults((SimilarityResults)ragResponse);
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(SingleShotRagServiceSearchTools.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("RagResponse for query [{}]:\n{}", (Object)query, (Object)asString);
        return asString;
    }
}

