/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.api.common.ActionContext;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.api.event.AgentProcessEvent;
import com.embabel.agent.event.AgentProcessRagEvent;
import com.embabel.agent.event.RagEvent;
import com.embabel.agent.event.RagEventListener;
import com.embabel.agent.event.RagRequestReceivedEvent;
import com.embabel.agent.event.RagResponseEvent;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContentElement;
import com.embabel.agent.rag.model.NamedEntityData;
import com.embabel.agent.rag.pipeline.AdaptivePipelineRagResponseEnhancer;
import com.embabel.agent.rag.pipeline.ChunkMergingEnhancer;
import com.embabel.agent.rag.pipeline.DeduplicatingEnhancer;
import com.embabel.agent.rag.pipeline.FilterEnhancer;
import com.embabel.agent.rag.pipeline.HyDEQueryGenerator;
import com.embabel.agent.rag.pipeline.PromptedContextualCompressionEnhancer;
import com.embabel.agent.rag.pipeline.RerankingEnhancer;
import com.embabel.agent.rag.pipeline.event.InitialRequestRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.InitialResponseRagPipelineEvent;
import com.embabel.agent.rag.service.HyDE;
import com.embabel.agent.rag.service.RagRequest;
import com.embabel.agent.rag.service.RagRequestRefinement;
import com.embabel.agent.rag.service.RagResponse;
import com.embabel.agent.rag.service.RagService;
import com.embabel.agent.rag.service.RagServiceEnhancer;
import com.embabel.agent.rag.service.RagServiceEnhancerProperties;
import com.embabel.agent.rag.service.ResultCompression;
import com.embabel.common.core.types.SimilarityResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={RagServiceEnhancerProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer;", "Lcom/embabel/agent/rag/service/RagServiceEnhancer;", "ragServiceEnhancerProperties", "Lcom/embabel/agent/rag/service/RagServiceEnhancerProperties;", "hyDEQueryGenerator", "Lcom/embabel/agent/rag/pipeline/HyDEQueryGenerator;", "<init>", "(Lcom/embabel/agent/rag/service/RagServiceEnhancerProperties;Lcom/embabel/agent/rag/pipeline/HyDEQueryGenerator;)V", "getRagServiceEnhancerProperties", "()Lcom/embabel/agent/rag/service/RagServiceEnhancerProperties;", "getHyDEQueryGenerator", "()Lcom/embabel/agent/rag/pipeline/HyDEQueryGenerator;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "create", "Lcom/embabel/agent/rag/service/RagService;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "delegate", "listener", "Lcom/embabel/agent/event/RagEventListener;", "PipelinedRagService", "embabel-agent-rag-pipeline"})
public final class PipelinedRagServiceEnhancer
implements RagServiceEnhancer {
    @NotNull
    private final RagServiceEnhancerProperties ragServiceEnhancerProperties;
    @NotNull
    private final HyDEQueryGenerator hyDEQueryGenerator;
    private final Logger logger;

    public PipelinedRagServiceEnhancer(@NotNull RagServiceEnhancerProperties ragServiceEnhancerProperties, @NotNull HyDEQueryGenerator hyDEQueryGenerator) {
        Intrinsics.checkNotNullParameter((Object)ragServiceEnhancerProperties, (String)"ragServiceEnhancerProperties");
        Intrinsics.checkNotNullParameter((Object)hyDEQueryGenerator, (String)"hyDEQueryGenerator");
        this.ragServiceEnhancerProperties = ragServiceEnhancerProperties;
        this.hyDEQueryGenerator = hyDEQueryGenerator;
        this.logger = LoggerFactory.getLogger(PipelinedRagServiceEnhancer.class);
        this.logger.info("Using properties: {}", (Object)this.ragServiceEnhancerProperties);
    }

    @NotNull
    public final RagServiceEnhancerProperties getRagServiceEnhancerProperties() {
        return this.ragServiceEnhancerProperties;
    }

    @NotNull
    public final HyDEQueryGenerator getHyDEQueryGenerator() {
        return this.hyDEQueryGenerator;
    }

    @Override
    @NotNull
    public RagService create(@NotNull OperationContext operationContext, @NotNull RagService delegate, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        RagEventListener listenerToUse = listener;
        if (operationContext instanceof ActionContext) {
            listenerToUse = listenerToUse.plus(arg_0 -> PipelinedRagServiceEnhancer.create$lambda$0(operationContext, arg_0));
        }
        return new PipelinedRagService(operationContext, delegate, listenerToUse);
    }

    private static final void create$lambda$0(OperationContext $operationContext, RagEvent ragEvent) {
        Intrinsics.checkNotNullParameter((Object)ragEvent, (String)"ragEvent");
        ((ActionContext)$operationContext).getProcessContext().onProcessEvent((AgentProcessEvent)new AgentProcessRagEvent($operationContext.getAgentProcess(), ragEvent));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001f\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService;", "Lcom/embabel/agent/rag/service/RagService;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "delegate", "listener", "Lcom/embabel/agent/event/RagEventListener;", "<init>", "(Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer;Lcom/embabel/agent/api/common/OperationContext;Lcom/embabel/agent/rag/service/RagService;Lcom/embabel/agent/event/RagEventListener;)V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "search", "Lcom/embabel/agent/rag/service/RagResponse;", "ragRequest", "Lcom/embabel/agent/rag/service/RagRequest;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-rag-pipeline"})
    @SourceDebugExtension(value={"SMAP\nPipelinedRagServiceEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PipelinedRagServiceEnhancer.kt\ncom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService\n+ 2 RagRequest.kt\ncom/embabel/agent/rag/service/RagRequestKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n81#2:152\n81#2:153\n1782#3,4:154\n1782#3,4:158\n1782#3,4:162\n*S KotlinDebug\n*F\n+ 1 PipelinedRagServiceEnhancer.kt\ncom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService\n*L\n87#1:152\n113#1:153\n133#1:154,4\n134#1:158,4\n135#1:162,4\n*E\n"})
    private final class PipelinedRagService
    implements RagService {
        @NotNull
        private final OperationContext operationContext;
        @NotNull
        private final RagService delegate;
        @NotNull
        private final RagEventListener listener;

        public PipelinedRagService(@NotNull OperationContext operationContext, @NotNull RagService delegate, RagEventListener listener) {
            Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.operationContext = operationContext;
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        @NotNull
        public String getName() {
            return "pipelined(" + this.delegate.getName() + ")";
        }

        @NotNull
        public String getDescription() {
            return "Pipelined RAG service wrapping " + this.delegate.getName() + ": " + this.delegate.getDescription();
        }

        @Override
        @NotNull
        public RagResponse search(@NotNull RagRequest ragRequest) {
            int n;
            int n2;
            SimilarityResult it;
            int n3;
            Iterable $this$count$iv;
            ResultCompression resultCompression;
            Object[] objectArray;
            Object hyDE;
            Object object;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
                    this.listener.onRagEvent(new RagRequestReceivedEvent(ragRequest, null, 2, null));
                    PipelinedRagServiceEnhancer.this.logger.info("Performing initial rag search for {} using RagService {}", (Object)ragRequest, (Object)this.delegate.getName());
                    RagRequestRefinement $this$hintOfType$iv = ragRequest;
                    boolean $i$f$hintOfType = false;
                    HyDE hyDE2 = $this$hintOfType$iv.hintOfType(HyDE.class);
                    object = hyDE2;
                    if (object == null) break block13;
                    HyDE hyDE3 = object;
                    PipelinedRagServiceEnhancer pipelinedRagServiceEnhancer = PipelinedRagServiceEnhancer.this;
                    hyDE = hyDE3;
                    boolean bl = false;
                    String string = pipelinedRagServiceEnhancer.getHyDEQueryGenerator().hydeQuery(ragRequest, (HyDE)hyDE, pipelinedRagServiceEnhancer.getRagServiceEnhancerProperties().getCompressionLlm(), this.operationContext.ai());
                    object = string;
                    if (string != null) break block14;
                }
                object = ragRequest.getQuery();
            }
            Object initialQuery = object;
            int n4 = ragRequest.getTopK() * 2;
            double d = ragRequest.getSimilarityThreshold() / (double)2;
            RagRequest initialRequest = RagRequest.copy$default(ragRequest, (String)initialQuery, d, n4, null, null, null, null, 120, null);
            this.listener.onRagEvent(new InitialRequestRagPipelineEvent(initialRequest, this.delegate.getName()));
            RagResponse initialResponse = RagResponse.copy$default(this.delegate.search(initialRequest), ragRequest, null, null, null, null, null, 62, null);
            this.listener.onRagEvent(new InitialResponseRagPipelineEvent(initialResponse, this.delegate.getName()));
            hyDE = PipelinedRagServiceEnhancer.this;
            Object $this$search_u24lambda_u241 = objectArray = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$search_u24lambda_u241.add(DeduplicatingEnhancer.INSTANCE);
            $this$search_u24lambda_u241.add(ChunkMergingEnhancer.INSTANCE);
            RagRequestRefinement $this$hintOfType$iv = ragRequest;
            boolean $i$f$hintOfType = false;
            ResultCompression resultCompression2 = resultCompression = $this$hintOfType$iv.hintOfType(ResultCompression.class);
            boolean bl2 = resultCompression2 != null ? resultCompression2.getEnabled() : false;
            if (bl2) {
                $this$search_u24lambda_u241.add(new PromptedContextualCompressionEnhancer(this.operationContext, ((PipelinedRagServiceEnhancer)hyDE).getRagServiceEnhancerProperties().getCompressionLlm(), ((PipelinedRagServiceEnhancer)hyDE).getRagServiceEnhancerProperties().getMaxConcurrency(), null, 0.0, 0, false, 120, null));
            }
            $this$search_u24lambda_u241.add(new RerankingEnhancer(this.operationContext, ((PipelinedRagServiceEnhancer)hyDE).getRagServiceEnhancerProperties().getRerankingLlm(), 0, 0, 0.0, 28, null));
            $this$search_u24lambda_u241.add(FilterEnhancer.INSTANCE);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 6;
            RagEventListener ragEventListener = this.listener;
            double d2 = 0.0;
            boolean bl3 = false;
            List list = CollectionsKt.build((List)objectArray);
            AdaptivePipelineRagResponseEnhancer pipeline = new AdaptivePipelineRagResponseEnhancer(list, bl3, d2, ragEventListener, n5, defaultConstructorMarker);
            RagResponse enhancedRagResponse = pipeline.enhance(initialResponse);
            this.listener.onRagEvent(new RagResponseEvent(enhancedRagResponse, null, 2, null));
            objectArray = new Object[4];
            objectArray[0] = enhancedRagResponse.getResults().size();
            $this$search_u24lambda_u241 = enhancedRagResponse.getResults();
            int n6 = 1;
            Object[] objectArray2 = objectArray;
            String string = "Final enhanced rag response has {} results: {} chunks, {} other content elements, {} entities";
            Logger logger = PipelinedRagServiceEnhancer.this.logger;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl4 = false;
                    if (!(it.getMatch() instanceof Chunk) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            int n7 = n3;
            objectArray2[n6] = n7;
            $this$count$iv = enhancedRagResponse.getResults();
            n6 = 2;
            objectArray2 = objectArray;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl5 = false;
                    if (!(it.getMatch() instanceof ContentElement && !(it.getMatch() instanceof Chunk)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            n7 = n2;
            objectArray2[n6] = n7;
            $this$count$iv = enhancedRagResponse.getResults();
            n6 = 3;
            objectArray2 = objectArray;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl6 = false;
                    if (!(it.getMatch() instanceof NamedEntityData) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            n7 = n;
            objectArray2[n6] = n7;
            logger.info(string, objectArray);
            PipelinedRagServiceEnhancer.this.logger.info("Results: {}", (Object)CollectionsKt.joinToString$default((Iterable)enhancedRagResponse.getResults(), (CharSequence)"\n", null, null, (int)0, null, PipelinedRagService::search$lambda$5, (int)30, null));
            return enhancedRagResponse;
        }

        @NotNull
        public String infoString(@Nullable Boolean verbose, int indent) {
            return "PipelinedRagService wrapping " + this.delegate.infoString(verbose, indent + 2);
        }

        private static final CharSequence search$lambda$5(SimilarityResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "- " + it.getMatch();
        }
    }
}

