/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.Datum;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.EnhancementEstimate;
import com.embabel.agent.rag.service.EnhancementRecommendation;
import com.embabel.agent.rag.service.EnhancementType;
import com.embabel.agent.rag.service.RagResponse;
import com.embabel.agent.rag.service.RagResponseEnhancer;
import com.embabel.common.core.types.SimilarityResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J(\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002J&\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0014\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00180\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/embabel/agent/rag/pipeline/ChunkMergingEnhancer;", "Lcom/embabel/agent/rag/service/RagResponseEnhancer;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "name", "", "getName", "()Ljava/lang/String;", "enhancementType", "Lcom/embabel/agent/rag/service/EnhancementType;", "getEnhancementType", "()Lcom/embabel/agent/rag/service/EnhancementType;", "enhance", "Lcom/embabel/agent/rag/service/RagResponse;", "response", "canMerge", "", "first", "Lcom/embabel/common/core/types/SimilarityResult;", "Lcom/embabel/agent/rag/model/Retrievable;", "second", "mergeChunks", "chunks", "", "estimateImpact", "Lcom/embabel/agent/rag/service/EnhancementEstimate;", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nChunkMergingEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkMergingEnhancer.kt\ncom/embabel/agent/rag/pipeline/ChunkMergingEnhancer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class ChunkMergingEnhancer
implements RagResponseEnhancer {
    @NotNull
    public static final ChunkMergingEnhancer INSTANCE = new ChunkMergingEnhancer();
    @NotNull
    private static Logger logger;
    @NotNull
    private static final String name;

    private ChunkMergingEnhancer() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        ChunkMergingEnhancer.logger = logger;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public EnhancementType getEnhancementType() {
        return EnhancementType.CONTENT_SYNTHESIS;
    }

    @Override
    @NotNull
    public RagResponse enhance(@NotNull RagResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List mergedResults = new ArrayList();
        List chunksToMerge = new ArrayList();
        for (SimilarityResult<? extends Retrievable> result : response.getResults()) {
            boolean bl;
            if (chunksToMerge.isEmpty()) {
                bl = chunksToMerge.add(result);
                continue;
            }
            SimilarityResult lastResult = (SimilarityResult)CollectionsKt.last((List)chunksToMerge);
            if (this.canMerge((SimilarityResult<? extends Retrievable>)lastResult, result)) {
                bl = chunksToMerge.add(result);
                continue;
            }
            mergedResults.add(this.mergeChunks(chunksToMerge));
            chunksToMerge.clear();
            bl = chunksToMerge.add(result);
        }
        if (!((Collection)chunksToMerge).isEmpty()) {
            mergedResults.add(this.mergeChunks(chunksToMerge));
        }
        return mergedResults.size() == response.getResults().size() ? response : RagResponse.copy$default(response, null, null, mergedResults, null, null, null, 59, null);
    }

    private final boolean canMerge(SimilarityResult<? extends Retrievable> first, SimilarityResult<? extends Retrievable> second) {
        Object v = ((Datum)first.getMatch()).getMetadata().get("root_document_id");
        String string = v instanceof String ? (String)v : null;
        if (string == null) {
            return false;
        }
        String firstRootId = string;
        Object v2 = ((Datum)second.getMatch()).getMetadata().get("root_document_id");
        String string2 = v2 instanceof String ? (String)v2 : null;
        if (string2 == null) {
            return false;
        }
        String secondRootId = string2;
        Object v3 = ((Datum)first.getMatch()).getMetadata().get("sequence_number");
        Integer n = v3 instanceof Integer ? (Integer)v3 : null;
        if (n == null) {
            return false;
        }
        int firstSeq = n;
        Object v4 = ((Datum)second.getMatch()).getMetadata().get("sequence_number");
        Integer n2 = v4 instanceof Integer ? (Integer)v4 : null;
        if (n2 == null) {
            return false;
        }
        int secondSeq = n2;
        return Intrinsics.areEqual((Object)firstRootId, (Object)secondRootId) && secondSeq == firstSeq + 1;
    }

    private final SimilarityResult<? extends Retrievable> mergeChunks(List<? extends SimilarityResult<? extends Retrievable>> chunks) {
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        logger.info("Merging {} chunks from document {}", (Object)chunks.size(), ((Datum)chunks.get(0).getMatch()).getMetadata().get("root_document_id"));
        Object object = chunks.get(0).getMatch();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.embabel.agent.rag.model.Chunk");
        Chunk firstChunk = (Chunk)object;
        String mergedText = CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)" ", null, null, (int)0, null, ChunkMergingEnhancer::mergeChunks$lambda$0, (int)30, null);
        Iterator iterator = ((Iterable)chunks).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        SimilarityResult it = (SimilarityResult)iterator.next();
        boolean bl = false;
        double d = it.getScore();
        while (iterator.hasNext()) {
            SimilarityResult it2 = (SimilarityResult)iterator.next();
            $i$a$-maxOf-ChunkMergingEnhancer$mergeChunks$highestScore$1 = false;
            double d2 = it2.getScore();
            d = Math.max(d, d2);
        }
        double highestScore = d;
        Chunk mergedChunk = Chunk.Companion.invoke(firstChunk.getId() + "-merged", mergedText, firstChunk.getMetadata(), firstChunk.getParentId());
        return (SimilarityResult)new SimilarityResult<Chunk>(mergedChunk, highestScore){
            private final Chunk match;
            private final double score;
            {
                this.match = $mergedChunk;
                this.score = $highestScore;
            }

            public Chunk getMatch() {
                return this.match;
            }

            public double getScore() {
                return this.score;
            }
        };
    }

    @Override
    @NotNull
    public EnhancementEstimate estimateImpact(@NotNull RagResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return new EnhancementEstimate(1.0, 0L, 0, EnhancementRecommendation.APPLY);
    }

    private static final CharSequence mergeChunks$lambda$0(SimilarityResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getMatch();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.embabel.agent.rag.model.Chunk");
        return ((Chunk)object).getText();
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ChunkMergingEnhancer.logger = logger;
        name = "chunk-merge";
    }
}

