/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.rag.service.RagResponse;
import com.embabel.agent.rag.service.RagResponseSummarizer;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.tools.RagOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0007J\u0012\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/rag/tools/DualShotRagServiceSearchTools;", "", "options", "Lcom/embabel/agent/rag/tools/RagOptions;", "summarizer", "Lcom/embabel/agent/rag/service/RagResponseSummarizer;", "<init>", "(Lcom/embabel/agent/rag/tools/RagOptions;Lcom/embabel/agent/rag/service/RagResponseSummarizer;)V", "getOptions", "()Lcom/embabel/agent/rag/tools/RagOptions;", "getSummarizer", "()Lcom/embabel/agent/rag/service/RagResponseSummarizer;", "search", "", "query", "searchDetails", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nDualShotRagServiceSearchTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DualShotRagServiceSearchTools.kt\ncom/embabel/agent/rag/tools/DualShotRagServiceSearchTools\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,68:1\n27#2:69\n*S KotlinDebug\n*F\n+ 1 DualShotRagServiceSearchTools.kt\ncom/embabel/agent/rag/tools/DualShotRagServiceSearchTools\n*L\n50#1:69\n*E\n"})
public final class DualShotRagServiceSearchTools {
    @NotNull
    private final RagOptions options;
    @NotNull
    private final RagResponseSummarizer summarizer;

    public DualShotRagServiceSearchTools(@NotNull RagOptions options, @NotNull RagResponseSummarizer summarizer) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)summarizer, (String)"summarizer");
        this.options = options;
        this.summarizer = summarizer;
    }

    @NotNull
    public final RagOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final RagResponseSummarizer getSummarizer() {
        return this.summarizer;
    }

    @LlmTool(description="Search for information relating to this query. Returns summary results")
    @NotNull
    public final String search(@LlmTool.Param(description="Standalone query to search for. Include sufficient context") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        RagResponse ragResponse = this.options.getRagService().search(this.options.toRequest(query));
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            return "RagResponse for query [" + query + "]:\n" + this.options.getRetrievableResultsFormatter().formatResults((SimilarityResults)ragResponse);
        }
        agentProcess.addObject((Object)ragResponse.withoutHistory());
        String summary = this.summarizer.summarize(ragResponse);
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(DualShotRagServiceSearchTools.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("Summary of RAG response: {}", (Object)summary);
        return summary;
    }

    @LlmTool(description="Drill deep into the details of the last search result")
    @NotNull
    public final String searchDetails(@LlmTool.Param(description="Standalone query to search for. Include sufficient context") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        AgentProcess agentProcess = AgentProcess.Companion.get();
        Object object = agentProcess != null ? agentProcess.lastResult() : null;
        RagResponse ragResponse = object instanceof RagResponse ? (RagResponse)object : null;
        if (ragResponse == null) {
            return "No RagResponse available, call search tool before";
        }
        RagResponse ragResponse2 = ragResponse;
        String asString = this.options.getRetrievableResultsFormatter().formatResults((SimilarityResults)ragResponse2);
        return asString;
    }
}

