/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline.support;

import com.embabel.agent.api.common.Ai;
import com.embabel.agent.rag.pipeline.HyDEQueryGenerator;
import com.embabel.agent.rag.service.HyDE;
import com.embabel.agent.rag.service.RagRequest;
import com.embabel.common.ai.model.LlmOptions;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/rag/pipeline/support/LlmHyDEQueryGenerator;", "Lcom/embabel/agent/rag/pipeline/HyDEQueryGenerator;", "promptPath", "", "<init>", "(Ljava/lang/String;)V", "getPromptPath", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "hydeQuery", "ragRequest", "Lcom/embabel/agent/rag/service/RagRequest;", "hyDE", "Lcom/embabel/agent/rag/service/HyDE;", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "ai", "Lcom/embabel/agent/api/common/Ai;", "embabel-agent-rag-pipeline"})
public final class LlmHyDEQueryGenerator
implements HyDEQueryGenerator {
    @NotNull
    private final String promptPath;
    private final Logger logger;

    public LlmHyDEQueryGenerator(@NotNull String promptPath) {
        Intrinsics.checkNotNullParameter((Object)promptPath, (String)"promptPath");
        this.promptPath = promptPath;
        this.logger = LoggerFactory.getLogger(HyDEQueryGenerator.class);
    }

    @NotNull
    public final String getPromptPath() {
        return this.promptPath;
    }

    @Override
    @NotNull
    public String hydeQuery(@NotNull RagRequest ragRequest, @NotNull HyDE hyDE, @NotNull LlmOptions llm, @NotNull Ai ai) {
        Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
        Intrinsics.checkNotNullParameter((Object)hyDE, (String)"hyDE");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter((Object)ai, (String)"ai");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ragRequest", (Object)ragRequest), TuplesKt.to((Object)"hyDE", (Object)hyDE)};
        String hydeQuery = ai.withLlm(llm).withTemplate(this.promptPath).generateText(MapsKt.mapOf((Pair[])pairArray));
        this.logger.info("Initial query '{}' -> Generated HyDE query '{}'", (Object)ragRequest.getQuery(), (Object)hydeQuery);
        return hydeQuery;
    }
}

