/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.rag.Embeddable;
import com.embabel.agent.rag.EnhancementEstimate;
import com.embabel.agent.rag.EnhancementRecommendation;
import com.embabel.agent.rag.EnhancementType;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseEnhancer;
import com.embabel.agent.rag.Retrievable;
import com.embabel.agent.rag.pipeline.RerankingResponse;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.SimpleSimilaritySearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\f\b\u0002\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J4\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u001e2\u0006\u0010!\u001a\u00020\u00132\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u001eH\u0002J&\u0010#\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f0\u001eH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/embabel/agent/rag/pipeline/RerankingEnhancer;", "Lcom/embabel/agent/rag/RagResponseEnhancer;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "maxResults", "", "rerankingThreshold", "rerankingWeight", "", "Lcom/embabel/common/core/types/ZeroToOne;", "<init>", "(Lcom/embabel/agent/api/common/OperationContext;Lcom/embabel/common/ai/model/LlmOptions;IID)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "enhancementType", "Lcom/embabel/agent/rag/EnhancementType;", "getEnhancementType", "()Lcom/embabel/agent/rag/EnhancementType;", "enhance", "Lcom/embabel/agent/rag/RagResponse;", "response", "performLlmReranking", "", "Lcom/embabel/common/core/types/SimilarityResult;", "Lcom/embabel/agent/rag/Retrievable;", "query", "results", "buildRerankingChoicesText", "estimateImpact", "Lcom/embabel/agent/rag/EnhancementEstimate;", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nRerankingEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RerankingEnhancer.kt\ncom/embabel/agent/rag/pipeline/RerankingEnhancer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1567#2:159\n1598#2,3:160\n1601#2:164\n1062#2:165\n1567#2:166\n1598#2,4:167\n1#3:163\n*S KotlinDebug\n*F\n+ 1 RerankingEnhancer.kt\ncom/embabel/agent/rag/pipeline/RerankingEnhancer\n*L\n104#1:159\n104#1:160,3\n104#1:164\n109#1:165\n118#1:166\n118#1:167,4\n*E\n"})
public final class RerankingEnhancer
implements RagResponseEnhancer {
    @NotNull
    private final OperationContext operationContext;
    @NotNull
    private final LlmOptions llm;
    private final int maxResults;
    private final int rerankingThreshold;
    private final double rerankingWeight;
    private final Logger logger;
    @NotNull
    private final String name;
    @NotNull
    private final EnhancementType enhancementType;

    public RerankingEnhancer(@NotNull OperationContext operationContext, @NotNull LlmOptions llm, int maxResults, int rerankingThreshold, double rerankingWeight) {
        Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        this.operationContext = operationContext;
        this.llm = llm;
        this.maxResults = maxResults;
        this.rerankingThreshold = rerankingThreshold;
        this.rerankingWeight = rerankingWeight;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.name = "rerank";
        this.enhancementType = EnhancementType.RERANKING;
    }

    public /* synthetic */ RerankingEnhancer(OperationContext operationContext, LlmOptions llmOptions, int n, int n2, double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 20;
        }
        if ((n3 & 8) != 0) {
            n2 = 3;
        }
        if ((n3 & 0x10) != 0) {
            d = 0.5;
        }
        this(operationContext, llmOptions, n, n2, d);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public EnhancementType getEnhancementType() {
        return this.enhancementType;
    }

    @NotNull
    public RagResponse enhance(@NotNull RagResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getResults().size() <= this.rerankingThreshold) {
            this.logger.debug("Skipping reranking for {} results (threshold: {})", (Object)response.getResults().size(), (Object)this.rerankingThreshold);
            return response;
        }
        String query = response.getRequest().getQuery();
        List resultsToRerank = CollectionsKt.take((Iterable)response.getResults(), (int)this.maxResults);
        this.logger.debug("Reranking {} results for query: {}", (Object)resultsToRerank.size(), (Object)query);
        try {
            List<SimilarityResult<? extends Retrievable>> rerankedResults = this.performLlmReranking(query, resultsToRerank);
            Object[] objectArray = new Object[]{resultsToRerank.size(), rerankedResults.size(), query};
            this.logger.info("Reranking {} results to {} for query: {}", objectArray);
            return RagResponse.copy$default((RagResponse)response, null, null, rerankedResults, null, null, null, (int)59, null);
        }
        catch (Exception e) {
            this.logger.warn("Failed to rerank results, returning original response", (Throwable)e);
            return response;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimilarityResult<? extends Retrievable>> performLlmReranking(String query, List<? extends SimilarityResult<? extends Retrievable>> results) {
        void $this$sortedByDescending$iv;
        void $this$mapIndexedTo$iv$iv;
        String prompt = this.buildRerankingChoicesText(query, results);
        RerankingResponse rerankingResponse = (RerankingResponse)this.operationContext.ai().withLlm(this.llm).withId("reranking").createObject(StringsKt.trimIndent((String)("\n                You are a relevance scoring expert. You evaluate how well search results match a query.\n\n                " + prompt + "\n\n                Return a JSON object with a \"scores\" array containing relevance scores from 0.0 to 1.0 for each result in order.\n                ")), RerankingResponse.class);
        List<Double> relevanceScores = rerankingResponse.getScores();
        Iterable $this$mapIndexed$iv = results;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void result;
            Double d;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SimilarityResult similarityResult = (SimilarityResult)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Double> list = relevanceScores;
            boolean bl2 = false <= index ? index < list.size() : false;
            if (bl2) {
                d = list.get((int)index);
            } else {
                void it = index;
                boolean bl3 = false;
                d = 0.5;
            }
            double llmScore = ((Number)d).doubleValue();
            double combinedScore = RangesKt.coerceIn((double)(result.getScore() * (1.0 - this.rerankingWeight) + llmScore * this.rerankingWeight), (double)0.0, (double)1.0);
            collection.add(new SimpleSimilaritySearchResult(result.getMatch(), combinedScore));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List rerankedResults = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimpleSimilaritySearchResult it = (SimpleSimilaritySearchResult)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (SimpleSimilaritySearchResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        });
        this.logger.debug("Reranked {} results with LLM relevance scoring", (Object)rerankedResults.size());
        return rerankedResults;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildRerankingChoicesText(String query, List<? extends SimilarityResult<? extends Retrievable>> results) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = results;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void result;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SimilarityResult similarityResult = (SimilarityResult)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("<index>" + (int)index + "</index>\n<result>" + ((Embeddable)result.getMatch()).embeddableValue() + "</result>");
        }
        String resultsText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)("\n" + StringsKt.repeat((CharSequence)"", (int)10) + "\n"), null, null, (int)0, null, null, (int)62, null);
        return StringsKt.trimIndent((String)("\n            Query: \"" + query + "\"\n\n            Search Results:\n            " + resultsText + "\n\n            Score each result from 0.0 to 1.0 based on how relevant it is to the query.\n            Consider semantic meaning, context, and how well each result would help answer the query.\n        "));
    }

    @Nullable
    public EnhancementEstimate estimateImpact(@NotNull RagResponse response) {
        EnhancementEstimate enhancementEstimate;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int resultCount = response.getResults().size();
        if (resultCount <= this.rerankingThreshold) {
            enhancementEstimate = new EnhancementEstimate(0.0, 0L, 0, EnhancementRecommendation.SKIP);
        } else {
            long estimatedLatency = Math.min(2000L + (long)resultCount * 100L, 5000L);
            int estimatedTokens = 50 + resultCount * 30;
            enhancementEstimate = new EnhancementEstimate(0.15, estimatedLatency, estimatedTokens, resultCount >= 5 ? EnhancementRecommendation.APPLY : EnhancementRecommendation.CONDITIONAL);
        }
        return enhancementEstimate;
    }
}

