/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.rag.Chunk;
import com.embabel.agent.rag.EnhancementEstimate;
import com.embabel.agent.rag.EnhancementRecommendation;
import com.embabel.agent.rag.EnhancementType;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseEnhancer;
import com.embabel.agent.rag.Retrievable;
import com.embabel.agent.rag.pipeline.CompressionResult;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.SimpleSimilaritySearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\"H\u0016J6\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010*\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lcom/embabel/agent/rag/pipeline/PromptedContextualCompressionEnhancer;", "Lcom/embabel/agent/rag/RagResponseEnhancer;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "maxConcurrency", "", "name", "", "targetRatio", "", "minLengthToCompress", "preserveEntities", "", "<init>", "(Lcom/embabel/agent/api/common/OperationContext;Lcom/embabel/common/ai/model/LlmOptions;ILjava/lang/String;DIZ)V", "getOperationContext", "()Lcom/embabel/agent/api/common/OperationContext;", "getLlm", "()Lcom/embabel/common/ai/model/LlmOptions;", "getMaxConcurrency", "()I", "getName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "enhancementType", "Lcom/embabel/agent/rag/EnhancementType;", "getEnhancementType", "()Lcom/embabel/agent/rag/EnhancementType;", "enhance", "Lcom/embabel/agent/rag/RagResponse;", "response", "estimateImpact", "Lcom/embabel/agent/rag/EnhancementEstimate;", "compressWithQuestionAwareness", "Lcom/embabel/agent/rag/pipeline/CompressionResult;", "content", "query", "dynamicRatio", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nPromptedContextualCompressionEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptedContextualCompressionEnhancer.kt\ncom/embabel/agent/rag/pipeline/PromptedContextualCompressionEnhancer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1557#2:163\n1628#2,3:164\n808#2,11:167\n1782#2,4:179\n1#3:178\n*S KotlinDebug\n*F\n+ 1 PromptedContextualCompressionEnhancer.kt\ncom/embabel/agent/rag/pipeline/PromptedContextualCompressionEnhancer\n*L\n91#1:163\n91#1:164,3\n91#1:167,11\n94#1:179,4\n*E\n"})
public final class PromptedContextualCompressionEnhancer
implements RagResponseEnhancer {
    @NotNull
    private final OperationContext operationContext;
    @NotNull
    private final LlmOptions llm;
    private final int maxConcurrency;
    @NotNull
    private final String name;
    private final double targetRatio;
    private final int minLengthToCompress;
    private final boolean preserveEntities;
    private final Logger logger;
    @NotNull
    private final EnhancementType enhancementType;

    public PromptedContextualCompressionEnhancer(@NotNull OperationContext operationContext, @NotNull LlmOptions llm, int maxConcurrency, @NotNull String name, double targetRatio, int minLengthToCompress, boolean preserveEntities) {
        Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.operationContext = operationContext;
        this.llm = llm;
        this.maxConcurrency = maxConcurrency;
        this.name = name;
        this.targetRatio = targetRatio;
        this.minLengthToCompress = minLengthToCompress;
        this.preserveEntities = preserveEntities;
        this.logger = LoggerFactory.getLogger(PromptedContextualCompressionEnhancer.class);
        this.enhancementType = EnhancementType.COMPRESSION;
    }

    public /* synthetic */ PromptedContextualCompressionEnhancer(OperationContext operationContext, LlmOptions llmOptions, int n, String string, double d, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 15;
        }
        if ((n3 & 8) != 0) {
            string = "contextual_compression";
        }
        if ((n3 & 0x10) != 0) {
            d = 0.3;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 1500;
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        this(operationContext, llmOptions, n, string, d, n2, bl);
    }

    @NotNull
    public final OperationContext getOperationContext() {
        return this.operationContext;
    }

    @NotNull
    public final LlmOptions getLlm() {
        return this.llm;
    }

    public final int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public EnhancementType getEnhancementType() {
        return this.enhancementType;
    }

    @NotNull
    public RagResponse enhance(@NotNull RagResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String query = response.getRequest().getQuery();
        List compressedResults = CollectionsKt.filterNotNull((Iterable)this.operationContext.parallelMap((Collection)response.getResults(), this.maxConcurrency, arg_0 -> PromptedContextualCompressionEnhancer.enhance$lambda$0(this, query, arg_0)));
        this.logger.info("Eliminated {} irrelevant results from {}", (Object)(response.getResults().size() - compressedResults.size()), (Object)response.getResults().size());
        return RagResponse.copy$default((RagResponse)response, null, null, (List)compressedResults, null, null, null, (int)59, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EnhancementEstimate estimateImpact(@NotNull RagResponse response) {
        int n;
        void $this$filterIsInstanceTo$iv$iv2;
        Chunk it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Iterable $this$map$iv = response.getResults();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SimilarityResult similarityResult = (SimilarityResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Retrievable)it.getMatch());
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance22 = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof Chunk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List chunks = (List)destination$iv$iv;
        Iterable $i$f$filterIsInstance22 = chunks;
        int $this$filterIsInstanceTo$iv$iv2 = 0;
        for (Object $i$f$filterIsInstanceTo2 : $i$f$filterIsInstance22) {
            void it2;
            Chunk chunk = (Chunk)$i$f$filterIsInstanceTo2;
            int n2 = $this$filterIsInstanceTo$iv$iv2;
            boolean bl = false;
            int n3 = it2.getText().length() / 4;
            $this$filterIsInstanceTo$iv$iv2 = n2 + n3;
        }
        int totalTokens = $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$count$iv = chunks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Chunk)element$iv;
                boolean bl = false;
                if (!(it.getText().length() > 1500) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int compressionCandidates = n;
        return new EnhancementEstimate(totalTokens > 8000 ? 0.15 : 0.05, (long)compressionCandidates * 200L, compressionCandidates * 50, totalTokens > 4000 ? EnhancementRecommendation.APPLY : EnhancementRecommendation.CONDITIONAL);
    }

    private final CompressionResult compressWithQuestionAwareness(String content, String query, double targetRatio, boolean preserveEntities, boolean dynamicRatio) {
        String prompt = StringsKt.trimIndent((String)("\n                Given the query, compress the content to include only what\n                is relevant. If you cannot compress, set 'irrelevant' to true.\n\n                <query>\n                " + query + "\n                </query>\n\n                <content>\n                " + content + "\n                </content>\n            "));
        Object object = this.operationContext.ai().withLlm(this.llm).withId(this.getName()).creating(CompressionResult.class).withExample("relevant content", (Object)new CompressionResult(false, "This is the compressed content that is relevant.", 1, null)).withExample("irrelevant content", (Object)new CompressionResult(true, null, 2, null)).fromPrompt(prompt);
        CompressionResult it = (CompressionResult)object;
        boolean bl = false;
        if (it.getIrrelevant()) {
            Object[] objectArray = new Object[]{StringsKt.repeat((CharSequence)"*", (int)140), query, content, prompt, StringsKt.repeat((CharSequence)"*", (int)140)};
            this.logger.debug("{}\nContent deemed irrelevant: Query=[{}], Content:\n{}\nPrompt was\n{}\n{}", objectArray);
        }
        return (CompressionResult)object;
    }

    static /* synthetic */ CompressionResult compressWithQuestionAwareness$default(PromptedContextualCompressionEnhancer promptedContextualCompressionEnhancer, String string, String string2, double d, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            d = 0.3;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return promptedContextualCompressionEnhancer.compressWithQuestionAwareness(string, string2, d, bl, bl2);
    }

    private static final SimilarityResult enhance$lambda$0(PromptedContextualCompressionEnhancer this$0, String $query, SimilarityResult result) {
        SimilarityResult similarityResult;
        Chunk chunk;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = result.getMatch();
        Chunk chunk2 = chunk = object instanceof Chunk ? (Chunk)object : null;
        if (chunk != null && chunk.getText().length() > this$0.minLengthToCompress) {
            SimpleSimilaritySearchResult simpleSimilaritySearchResult;
            CharSequence charSequence;
            CompressionResult compressionResult = PromptedContextualCompressionEnhancer.compressWithQuestionAwareness$default(this$0, chunk.getText(), $query, this$0.targetRatio, this$0.preserveEntities, false, 16, null);
            if (compressionResult.getIrrelevant() || (charSequence = (CharSequence)compressionResult.getCompressed()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this$0.logger.debug("Discarding irrelevant content");
                simpleSimilaritySearchResult = null;
            } else {
                Chunk compressedChunk = chunk.transform(compressionResult.getCompressed());
                this$0.logger.debug("Compressed chunk:\n{}\n----->\n{}", (Object)chunk.getText(), (Object)compressedChunk.getText());
                simpleSimilaritySearchResult = new SimpleSimilaritySearchResult((Object)compressedChunk, result.getScore());
            }
            similarityResult = (SimilarityResult)simpleSimilaritySearchResult;
        } else {
            similarityResult = result;
        }
        return similarityResult;
    }
}

