/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.api.common.ActionContext;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.event.AgentProcessEvent;
import com.embabel.agent.event.AgentProcessRagEvent;
import com.embabel.agent.event.RagEvent;
import com.embabel.agent.event.RagEventListener;
import com.embabel.agent.event.RagRequestReceivedEvent;
import com.embabel.agent.event.RagResponseEvent;
import com.embabel.agent.rag.Chunk;
import com.embabel.agent.rag.ContentElement;
import com.embabel.agent.rag.HyDE;
import com.embabel.agent.rag.RagRequest;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagService;
import com.embabel.agent.rag.RagServiceEnhancer;
import com.embabel.agent.rag.RagServiceEnhancerProperties;
import com.embabel.agent.rag.RetrievableEntity;
import com.embabel.agent.rag.pipeline.AdaptivePipelineRagResponseEnhancer;
import com.embabel.agent.rag.pipeline.DeduplicatingEnhancer;
import com.embabel.agent.rag.pipeline.FilterEnhancer;
import com.embabel.agent.rag.pipeline.PromptedContextualCompressionEnhancer;
import com.embabel.agent.rag.pipeline.RerankingEnhancer;
import com.embabel.agent.rag.pipeline.event.InitialRequestRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.InitialResponseRagPipelineEvent;
import com.embabel.common.core.types.SimilarityResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer;", "Lcom/embabel/agent/rag/RagServiceEnhancer;", "ragServiceEnhancerProperties", "Lcom/embabel/agent/rag/RagServiceEnhancerProperties;", "<init>", "(Lcom/embabel/agent/rag/RagServiceEnhancerProperties;)V", "getRagServiceEnhancerProperties", "()Lcom/embabel/agent/rag/RagServiceEnhancerProperties;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "create", "Lcom/embabel/agent/rag/RagService;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "delegate", "listener", "Lcom/embabel/agent/event/RagEventListener;", "PipelinedRagService", "embabel-agent-rag-pipeline"})
public final class PipelinedRagServiceEnhancer
implements RagServiceEnhancer {
    @NotNull
    private final RagServiceEnhancerProperties ragServiceEnhancerProperties;
    private final Logger logger;

    public PipelinedRagServiceEnhancer(@NotNull RagServiceEnhancerProperties ragServiceEnhancerProperties) {
        Intrinsics.checkNotNullParameter((Object)ragServiceEnhancerProperties, (String)"ragServiceEnhancerProperties");
        this.ragServiceEnhancerProperties = ragServiceEnhancerProperties;
        this.logger = LoggerFactory.getLogger(PipelinedRagServiceEnhancer.class);
    }

    public /* synthetic */ PipelinedRagServiceEnhancer(RagServiceEnhancerProperties ragServiceEnhancerProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ragServiceEnhancerProperties = new RagServiceEnhancerProperties();
        }
        this(ragServiceEnhancerProperties);
    }

    @NotNull
    public final RagServiceEnhancerProperties getRagServiceEnhancerProperties() {
        return this.ragServiceEnhancerProperties;
    }

    @NotNull
    public RagService create(@NotNull OperationContext operationContext, @NotNull RagService delegate, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        RagEventListener listenerToUse = listener;
        if (operationContext instanceof ActionContext) {
            listenerToUse = listenerToUse.plus(arg_0 -> PipelinedRagServiceEnhancer.create$lambda$0(operationContext, arg_0));
        }
        return new PipelinedRagService(operationContext, delegate, listenerToUse);
    }

    private static final void create$lambda$0(OperationContext $operationContext, RagEvent ragEvent) {
        Intrinsics.checkNotNullParameter((Object)ragEvent, (String)"ragEvent");
        ((ActionContext)$operationContext).getProcessContext().onProcessEvent((AgentProcessEvent)new AgentProcessRagEvent($operationContext.getAgentProcess(), ragEvent));
    }

    public PipelinedRagServiceEnhancer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService;", "Lcom/embabel/agent/rag/RagService;", "operationContext", "Lcom/embabel/agent/api/common/OperationContext;", "delegate", "listener", "Lcom/embabel/agent/event/RagEventListener;", "<init>", "(Lcom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer;Lcom/embabel/agent/api/common/OperationContext;Lcom/embabel/agent/rag/RagService;Lcom/embabel/agent/event/RagEventListener;)V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "hydeQuery", "ragRequest", "Lcom/embabel/agent/rag/RagRequest;", "hyDE", "Lcom/embabel/agent/rag/HyDE;", "search", "Lcom/embabel/agent/rag/RagResponse;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-rag-pipeline"})
    @SourceDebugExtension(value={"SMAP\nPipelinedRagServiceEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PipelinedRagServiceEnhancer.kt\ncom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n1782#3,4:151\n1782#3,4:155\n1782#3,4:159\n*S KotlinDebug\n*F\n+ 1 PipelinedRagServiceEnhancer.kt\ncom/embabel/agent/rag/pipeline/PipelinedRagServiceEnhancer$PipelinedRagService\n*L\n134#1:151,4\n135#1:155,4\n136#1:159,4\n*E\n"})
    private final class PipelinedRagService
    implements RagService {
        @NotNull
        private final OperationContext operationContext;
        @NotNull
        private final RagService delegate;
        @NotNull
        private final RagEventListener listener;

        public PipelinedRagService(@NotNull OperationContext operationContext, @NotNull RagService delegate, RagEventListener listener) {
            Intrinsics.checkNotNullParameter((Object)operationContext, (String)"operationContext");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.operationContext = operationContext;
            this.delegate = delegate;
            this.listener = listener;
        }

        @NotNull
        public String getName() {
            return "pipelined(" + this.delegate.getName() + ")";
        }

        @NotNull
        public String getDescription() {
            return "Pipelined RAG service wrapping " + this.delegate.getName() + ": " + this.delegate.getDescription();
        }

        private final String hydeQuery(RagRequest ragRequest, HyDE hyDE) {
            HyDE hyDE2 = ragRequest.getHyDE();
            String hydeQuery = this.operationContext.ai().withLlm(PipelinedRagServiceEnhancer.this.getRagServiceEnhancerProperties().getCompressionLlm()).generateText(StringsKt.trimIndent((String)("\n                    Given the following request, generate a plausible hypothetical\n                    answer.\n                    Don't worry if the answer isn't accurate; just make it a reasonable\n                    example of an answer to the query.\n                    The answer should be at most " + (hyDE2 != null ? hyDE2.getWordCount() : 50) + " words.\n\n                    REQUEST:\n                    " + ragRequest.getQuery() + "\n\n                    CONTEXT FOR THE ANSWER:\n                    " + hyDE.getContext() + "\n                ")));
            PipelinedRagServiceEnhancer.this.logger.info("{} -> Generated HyDE query: {}", (Object)ragRequest.getQuery(), (Object)hydeQuery);
            return hydeQuery;
        }

        @NotNull
        public RagResponse search(@NotNull RagRequest ragRequest) {
            int n;
            int n2;
            SimilarityResult it;
            int count$iv;
            int n3;
            Iterable $this$count$iv;
            Object[] objectArray;
            Object object;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
                    this.listener.onRagEvent((RagEvent)new RagRequestReceivedEvent(ragRequest, null, 2, null));
                    PipelinedRagServiceEnhancer.this.logger.info("Performing initial rag search for {} using RagService {}", (Object)ragRequest, (Object)this.delegate.getName());
                    object = ragRequest.getHyDE();
                    if (object == null) break block13;
                    HyDE it2 = object;
                    boolean bl = false;
                    String string = this.hydeQuery(ragRequest, it2);
                    object = string;
                    if (string != null) break block14;
                }
                object = ragRequest.getQuery();
            }
            Object object2 = object;
            int n4 = ragRequest.getTopK() * 2;
            double d = ragRequest.getSimilarityThreshold() / (double)2;
            RagRequest initialRequest = RagRequest.copy$default((RagRequest)ragRequest, (String)object2, (double)d, (int)n4, null, null, null, null, null, null, (int)504, null);
            this.listener.onRagEvent((RagEvent)new InitialRequestRagPipelineEvent(initialRequest, this.delegate.getName()));
            RagResponse initialResponse = RagResponse.copy$default((RagResponse)this.delegate.search(initialRequest), (RagRequest)ragRequest, null, null, null, null, null, (int)62, null);
            this.listener.onRagEvent((RagEvent)new InitialResponseRagPipelineEvent(initialResponse, this.delegate.getName()));
            PipelinedRagServiceEnhancer pipelinedRagServiceEnhancer = PipelinedRagServiceEnhancer.this;
            Object $this$search_u24lambda_u241 = objectArray = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$search_u24lambda_u241.add(DeduplicatingEnhancer.INSTANCE);
            if (ragRequest.getCompressionConfig().getEnabled()) {
                $this$search_u24lambda_u241.add(new PromptedContextualCompressionEnhancer(this.operationContext, pipelinedRagServiceEnhancer.getRagServiceEnhancerProperties().getCompressionLlm(), pipelinedRagServiceEnhancer.getRagServiceEnhancerProperties().getMaxConcurrency(), null, 0.0, 0, false, 120, null));
            }
            $this$search_u24lambda_u241.add(new RerankingEnhancer(this.operationContext, pipelinedRagServiceEnhancer.getRagServiceEnhancerProperties().getRerankingLlm(), 0, 0, 0.0, 28, null));
            $this$search_u24lambda_u241.add(FilterEnhancer.INSTANCE);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n5 = 6;
            RagEventListener ragEventListener = this.listener;
            double d2 = 0.0;
            boolean bl2 = false;
            List list = CollectionsKt.build((List)objectArray);
            AdaptivePipelineRagResponseEnhancer pipeline = new AdaptivePipelineRagResponseEnhancer(list, bl2, d2, ragEventListener, n5, defaultConstructorMarker);
            RagResponse enhancedRagResponse = pipeline.enhance(initialResponse);
            this.listener.onRagEvent((RagEvent)new RagResponseEvent(enhancedRagResponse, null, 2, null));
            objectArray = new Object[4];
            objectArray[0] = enhancedRagResponse.getResults().size();
            $this$search_u24lambda_u241 = enhancedRagResponse.getResults();
            int n6 = 1;
            Object[] objectArray2 = objectArray;
            String string = "Final enhanced rag response has {} results: {} chunks, {} other content elements, {} entities";
            Logger logger = PipelinedRagServiceEnhancer.this.logger;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n3 = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl3 = false;
                    if (!(it.getMatch() instanceof Chunk) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            int n7 = n3;
            objectArray2[n6] = n7;
            $this$count$iv = enhancedRagResponse.getResults();
            n6 = 2;
            objectArray2 = objectArray;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl4 = false;
                    if (!(it.getMatch() instanceof ContentElement && !(it.getMatch() instanceof Chunk)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            n7 = n2;
            objectArray2[n6] = n7;
            $this$count$iv = enhancedRagResponse.getResults();
            n6 = 3;
            objectArray2 = objectArray;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (SimilarityResult)element$iv;
                    boolean bl5 = false;
                    if (!(it.getMatch() instanceof RetrievableEntity) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            n7 = n;
            objectArray2[n6] = n7;
            logger.info(string, objectArray);
            return enhancedRagResponse;
        }

        @NotNull
        public String infoString(@Nullable Boolean verbose, int indent) {
            return "PipelinedRagService wrapping " + this.delegate.infoString(verbose, indent + 2);
        }
    }
}

