/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.pipeline;

import com.embabel.agent.event.RagEvent;
import com.embabel.agent.event.RagEventListener;
import com.embabel.agent.rag.EnhancementRecommendation;
import com.embabel.agent.rag.EnhancementType;
import com.embabel.agent.rag.QualityMetrics;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseEnhancement;
import com.embabel.agent.rag.RagResponseEnhancer;
import com.embabel.agent.rag.pipeline.event.EnhancementCompletedRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.EnhancementStartingRagPipelineEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J7\u0010'\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lcom/embabel/agent/rag/pipeline/AdaptivePipelineRagResponseEnhancer;", "Lcom/embabel/agent/rag/RagResponseEnhancer;", "enhancers", "", "adaptiveExecution", "", "qualityThreshold", "", "listener", "Lcom/embabel/agent/event/RagEventListener;", "<init>", "(Ljava/util/List;ZDLcom/embabel/agent/event/RagEventListener;)V", "getEnhancers", "()Ljava/util/List;", "getAdaptiveExecution", "()Z", "getQualityThreshold", "()D", "getListener", "()Lcom/embabel/agent/event/RagEventListener;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "enhancementType", "Lcom/embabel/agent/rag/EnhancementType;", "getEnhancementType", "()Lcom/embabel/agent/rag/EnhancementType;", "enhance", "Lcom/embabel/agent/rag/RagResponse;", "response", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "embabel-agent-rag-pipeline"})
@SourceDebugExtension(value={"SMAP\nAdaptivePipelineRagResponseEnhancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptivePipelineRagResponseEnhancer.kt\ncom/embabel/agent/rag/pipeline/AdaptivePipelineRagResponseEnhancer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class AdaptivePipelineRagResponseEnhancer
implements RagResponseEnhancer {
    @NotNull
    private final List<RagResponseEnhancer> enhancers;
    private final boolean adaptiveExecution;
    private final double qualityThreshold;
    @NotNull
    private final RagEventListener listener;
    private final Logger logger;
    @NotNull
    private final EnhancementType enhancementType;

    @JvmOverloads
    public AdaptivePipelineRagResponseEnhancer(@NotNull List<? extends RagResponseEnhancer> enhancers, boolean adaptiveExecution, double qualityThreshold, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.enhancers = enhancers;
        this.adaptiveExecution = adaptiveExecution;
        this.qualityThreshold = qualityThreshold;
        this.listener = listener;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.enhancementType = EnhancementType.CUSTOM;
    }

    public /* synthetic */ AdaptivePipelineRagResponseEnhancer(List list, boolean bl, double d, RagEventListener ragEventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            d = 0.7;
        }
        this(list, bl, d, ragEventListener);
    }

    @NotNull
    public final List<RagResponseEnhancer> getEnhancers() {
        return this.enhancers;
    }

    public final boolean getAdaptiveExecution() {
        return this.adaptiveExecution;
    }

    public final double getQualityThreshold() {
        return this.qualityThreshold;
    }

    @NotNull
    public final RagEventListener getListener() {
        return this.listener;
    }

    @NotNull
    public String getName() {
        return CollectionsKt.joinToString$default((Iterable)this.enhancers, (CharSequence)"->", null, null, (int)0, null, AdaptivePipelineRagResponseEnhancer::_get_name_$lambda$0, (int)30, null);
    }

    @NotNull
    public EnhancementType getEnhancementType() {
        return this.enhancementType;
    }

    @NotNull
    public RagResponse enhance(@NotNull RagResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        RagResponse current = response;
        long startTime = System.currentTimeMillis();
        for (RagResponseEnhancer enhancer : this.enhancers) {
            Object[] estimate;
            if (this.adaptiveExecution) {
                boolean bl;
                estimate = enhancer.estimateImpact(current);
                long elapsedMs = System.currentTimeMillis() - startTime;
                if (current.getQualityMetrics() != null) {
                    QualityMetrics it;
                    boolean bl2 = false;
                    bl = it.getOverallScore() > this.qualityThreshold;
                } else {
                    bl = false;
                }
                if (bl && (estimate != null ? estimate.getEstimatedLatencyMs() : 0L) > 1000L) {
                    this.logger.info("Skipping expensive enhancer {} as quality is already high enough", (Object)enhancer.getName());
                    continue;
                }
                if (elapsedMs > response.getRequest().getDesiredMaxLatency().toMillis()) {
                    Object[] objectArray = new Object[]{estimate, enhancer.getName(), response.getRequest().getDesiredMaxLatency()};
                    this.logger.info("Skipping enhancer {} as elapsed time is {}ms with latency limit of {}ms", objectArray);
                    break;
                }
                if ((estimate != null ? estimate.getRecommendation() : null) == EnhancementRecommendation.SKIP) {
                    this.logger.info("Skipping enhancer {} it recommends skipping", (Object)enhancer.getName());
                    continue;
                }
            }
            estimate = new Object[]{enhancer.getName(), current.getService(), current.getResults().size()};
            this.logger.info("Applying enhancer {} on response from service {} with {} results", estimate);
            long enhancementStart = System.currentTimeMillis();
            this.listener.onRagEvent((RagEvent)new EnhancementStartingRagPipelineEvent(current, enhancer.getName()));
            RagResponse ragResponse = current;
            long l = System.currentTimeMillis() - enhancementStart;
            EnhancementType enhancementType = enhancer.getEnhancementType();
            current = RagResponse.copy$default((RagResponse)enhancer.enhance(current), null, null, null, (RagResponseEnhancement)new RagResponseEnhancement(enhancer, ragResponse, l, 0, enhancementType, null, 32, null), null, null, (int)55, null);
            this.listener.onRagEvent((RagEvent)new EnhancementCompletedRagPipelineEvent(current, enhancer.getName()));
        }
        return current;
    }

    @NotNull
    public final List<RagResponseEnhancer> component1() {
        return this.enhancers;
    }

    public final boolean component2() {
        return this.adaptiveExecution;
    }

    public final double component3() {
        return this.qualityThreshold;
    }

    @NotNull
    public final RagEventListener component4() {
        return this.listener;
    }

    @NotNull
    public final AdaptivePipelineRagResponseEnhancer copy(@NotNull List<? extends RagResponseEnhancer> enhancers, boolean adaptiveExecution, double qualityThreshold, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return new AdaptivePipelineRagResponseEnhancer(enhancers, adaptiveExecution, qualityThreshold, listener);
    }

    public static /* synthetic */ AdaptivePipelineRagResponseEnhancer copy$default(AdaptivePipelineRagResponseEnhancer adaptivePipelineRagResponseEnhancer, List list, boolean bl, double d, RagEventListener ragEventListener, int n, Object object) {
        if ((n & 1) != 0) {
            list = adaptivePipelineRagResponseEnhancer.enhancers;
        }
        if ((n & 2) != 0) {
            bl = adaptivePipelineRagResponseEnhancer.adaptiveExecution;
        }
        if ((n & 4) != 0) {
            d = adaptivePipelineRagResponseEnhancer.qualityThreshold;
        }
        if ((n & 8) != 0) {
            ragEventListener = adaptivePipelineRagResponseEnhancer.listener;
        }
        return adaptivePipelineRagResponseEnhancer.copy(list, bl, d, ragEventListener);
    }

    @NotNull
    public String toString() {
        return "AdaptivePipelineRagResponseEnhancer(enhancers=" + this.enhancers + ", adaptiveExecution=" + this.adaptiveExecution + ", qualityThreshold=" + this.qualityThreshold + ", listener=" + this.listener + ")";
    }

    public int hashCode() {
        int result = ((Object)this.enhancers).hashCode();
        result = result * 31 + Boolean.hashCode(this.adaptiveExecution);
        result = result * 31 + Double.hashCode(this.qualityThreshold);
        result = result * 31 + this.listener.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdaptivePipelineRagResponseEnhancer)) {
            return false;
        }
        AdaptivePipelineRagResponseEnhancer adaptivePipelineRagResponseEnhancer = (AdaptivePipelineRagResponseEnhancer)other;
        if (!Intrinsics.areEqual(this.enhancers, adaptivePipelineRagResponseEnhancer.enhancers)) {
            return false;
        }
        if (this.adaptiveExecution != adaptivePipelineRagResponseEnhancer.adaptiveExecution) {
            return false;
        }
        if (Double.compare(this.qualityThreshold, adaptivePipelineRagResponseEnhancer.qualityThreshold) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.listener, (Object)adaptivePipelineRagResponseEnhancer.listener);
    }

    @JvmOverloads
    public AdaptivePipelineRagResponseEnhancer(@NotNull List<? extends RagResponseEnhancer> enhancers, boolean adaptiveExecution, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this(enhancers, adaptiveExecution, 0.0, listener, 4, null);
    }

    @JvmOverloads
    public AdaptivePipelineRagResponseEnhancer(@NotNull List<? extends RagResponseEnhancer> enhancers, @NotNull RagEventListener listener) {
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this(enhancers, false, 0.0, listener, 6, null);
    }

    private static final CharSequence _get_name_$lambda$0(RagResponseEnhancer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

