/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.lucene;

import com.embabel.agent.api.common.primitive.KeywordExtractor;
import com.embabel.agent.rag.ingestion.ChunkTransformer;
import com.embabel.agent.rag.ingestion.ContentChunker;
import com.embabel.agent.rag.ingestion.RetrievableEnhancer;
import com.embabel.agent.rag.lucene.HighDimensionVectorCodec;
import com.embabel.agent.rag.lucene.LuceneDocumentMapper;
import com.embabel.agent.rag.lucene.LuceneSearchOperationsBuilder;
import com.embabel.agent.rag.lucene.LuceneStatistics;
import com.embabel.agent.rag.lucene.VectorMath;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContentElement;
import com.embabel.agent.rag.model.ContentRoot;
import com.embabel.agent.rag.model.Datum;
import com.embabel.agent.rag.model.DefaultMaterializedContainerSection;
import com.embabel.agent.rag.model.HierarchicalContentElement;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.MaterializedDocument;
import com.embabel.agent.rag.model.NavigableContainerSection;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.model.NavigableSection;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.CoreSearchOperations;
import com.embabel.agent.rag.service.FinderOperations;
import com.embabel.agent.rag.service.RagRequest;
import com.embabel.agent.rag.service.ResultExpander;
import com.embabel.agent.rag.service.support.FunctionRagFacet;
import com.embabel.agent.rag.service.support.RagFacet;
import com.embabel.agent.rag.service.support.RagFacetProvider;
import com.embabel.agent.rag.service.support.RagFacetResults;
import com.embabel.agent.rag.store.AbstractChunkingContentElementRepository;
import com.embabel.agent.rag.store.DocumentDeletionResult;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.SimpleSimilaritySearchResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import com.embabel.common.util.FormatUtilsKt;
import com.embabel.common.util.StringTrimmingUtilsKt;
import java.io.Closeable;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0091\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007:\u0002\u0091\u0001Bc\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u0000J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\tH\u0016J+\u00107\u001a\u0004\u0018\u0001H8\"\u0004\b\u0000\u001082\u0006\u00109\u001a\u00020\t2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H80;H\u0016\u00a2\u0006\u0002\u0010<J)\u00107\u001a\u0004\u0018\u0001H8\"\b\b\u0000\u00108*\u00020=2\u0006\u00109\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020=0@0\u000bH\u0016J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u000b2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020B0\u000b2\u0006\u0010E\u001a\u00020\tH\u0016J\u0012\u00107\u001a\u0004\u0018\u0001042\u0006\u00109\u001a\u00020\tH\u0016J\u0010\u0010F\u001a\u0002042\u0006\u0010G\u001a\u000204H\u0016J\u0010\u0010H\u001a\u00020.2\u0006\u0010G\u001a\u000204H\u0002J\u0010\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020KH\u0014J$\u0010L\u001a\b\u0012\u0004\u0012\u0002H80\u000b\"\b\b\u0000\u00108*\u0002042\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H80;J\f\u0010L\u001a\b\u0012\u0004\u0012\u00020B0\u000bJ \u0010M\u001a\u00020.2\u0018\u0010N\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0OJ:\u0010P\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020R0Q0\u000b2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\t0T2\b\b\u0002\u0010U\u001a\u00020R2\b\b\u0002\u0010V\u001a\u00020RJ\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020B0X2\u0006\u0010Y\u001a\u00020ZJ\u0014\u0010[\u001a\b\u0012\u0004\u0012\u00020B0X2\u0006\u0010Y\u001a\u00020ZJ4\u0010\\\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H80]0\u000b\"\b\b\u0000\u00108*\u00020=2\u0006\u0010^\u001a\u00020_2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H80;H\u0016J$\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0a0\u000b2\u0006\u0010b\u001a\u00020c2\u0006\u0010^\u001a\u00020_H\u0002J&\u0010d\u001a\b\u0012\u0004\u0012\u0002040\u000b2\u0006\u00109\u001a\u00020\t2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020RH\u0016J\u001e\u0010h\u001a\b\u0012\u0004\u0012\u00020B0\u000b2\u0006\u0010i\u001a\u00020B2\u0006\u0010j\u001a\u00020RH\u0002J4\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H80]0\u000b\"\b\b\u0000\u00108*\u00020=2\u0006\u0010^\u001a\u00020_2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H80;H\u0016J$\u0010l\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0a0\u000b2\u0006\u0010b\u001a\u00020c2\u0006\u0010Y\u001a\u00020ZH\u0002J$\u0010m\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0a0\u000b2\u0006\u0010b\u001a\u00020c2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0010\u0010n\u001a\u00020B2\u0006\u0010o\u001a\u00020pH\u0002J\b\u0010q\u001a\u00020.H\u0002J\u001c\u0010r\u001a\u0004\u0018\u0001042\u0006\u0010o\u001a\u00020p2\b\u0010s\u001a\u0004\u0018\u00010\tH\u0002J*\u0010t\u001a\u00020.2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020B0\u000b2\u0012\u0010v\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020w0OH\u0014J\u001a\u0010x\u001a\u00020p2\u0006\u0010i\u001a\u00020B2\b\u0010y\u001a\u0004\u0018\u00010wH\u0002J\b\u0010z\u001a\u00020.H\u0014J\u0018\u0010{\u001a\u00020\u00122\u0006\u0010|\u001a\u00020w2\u0006\u0010}\u001a\u00020wH\u0002J\u0011\u0010~\u001a\u00020w2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\t\u0010\u0081\u0001\u001a\u00020.H\u0002J\t\u0010\u0082\u0001\u001a\u00020.H\u0002J\t\u0010\u0083\u0001\u001a\u00020.H\u0002J#\u0010\u0084\u0001\u001a\u00020\t2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010,2\u0007\u0010\u0086\u0001\u001a\u00020RH\u0016\u00a2\u0006\u0003\u0010\u0087\u0001J\t\u0010\u0088\u0001\u001a\u00020.H\u0016J\u0015\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020\tH\u0016J\u0015\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u00012\u0007\u0010\u008b\u0001\u001a\u00020\tH\u0016J\u0007\u0010\u008e\u0001\u001a\u00020RJ\n\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001cR\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0092\u0001"}, d2={"Lcom/embabel/agent/rag/lucene/LuceneSearchOperations;", "Lcom/embabel/agent/rag/service/support/RagFacetProvider;", "Lcom/embabel/agent/rag/store/AbstractChunkingContentElementRepository;", "Lcom/embabel/common/core/types/HasInfoString;", "Ljava/io/Closeable;", "Lcom/embabel/agent/rag/service/CoreSearchOperations;", "Lcom/embabel/agent/rag/service/FinderOperations;", "Lcom/embabel/agent/rag/service/ResultExpander;", "name", "", "enhancers", "", "Lcom/embabel/agent/rag/ingestion/RetrievableEnhancer;", "embeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "keywordExtractor", "Lcom/embabel/agent/api/common/primitive/KeywordExtractor;", "vectorWeight", "", "chunkerConfig", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "chunkTransformer", "Lcom/embabel/agent/rag/ingestion/ChunkTransformer;", "indexPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/embabel/common/ai/model/EmbeddingService;Lcom/embabel/agent/api/common/primitive/KeywordExtractor;DLcom/embabel/agent/rag/ingestion/ContentChunker$Config;Lcom/embabel/agent/rag/ingestion/ChunkTransformer;Ljava/nio/file/Path;)V", "getName", "()Ljava/lang/String;", "getEnhancers", "()Ljava/util/List;", "analyzer", "Lorg/apache/lucene/analysis/standard/StandardAnalyzer;", "directory", "Lorg/apache/lucene/store/Directory;", "indexWriterConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "queryParser", "Lorg/apache/lucene/queryparser/classic/QueryParser;", "luceneSyntaxNotes", "getLuceneSyntaxNotes", "chunksLoaded", "", "ensureChunksLoaded", "", "loadExistingChunksFromDisk", "directoryReader", "Lorg/apache/lucene/index/DirectoryReader;", "contentElementStorage", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/embabel/agent/rag/model/ContentElement;", "supportsType", "type", "findById", "T", "id", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "Lcom/embabel/agent/rag/model/Retrievable;", "(Ljava/lang/String;Ljava/lang/String;)Lcom/embabel/agent/rag/model/Retrievable;", "facets", "Lcom/embabel/agent/rag/service/support/RagFacet;", "findAllChunksById", "Lcom/embabel/agent/rag/model/Chunk;", "chunkIds", "findChunksForEntity", "entityId", "save", "element", "persistStructuralElement", "createInternalRelationships", "root", "Lcom/embabel/agent/rag/model/NavigableDocument;", "findAll", "updateKeywords", "updates", "", "findChunkIdsByKeywords", "Lkotlin/Pair;", "", "keywords", "", "minIntersection", "maxResults", "keywordSearch", "Lcom/embabel/agent/rag/service/support/RagFacetResults;", "ragRequest", "Lcom/embabel/agent/rag/service/RagRequest;", "hybridSearch", "vectorSearch", "Lcom/embabel/common/core/types/SimilarityResult;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "performVectorSearch", "Lcom/embabel/common/core/types/SimpleSimilaritySearchResult;", "searcher", "Lorg/apache/lucene/search/IndexSearcher;", "expandResult", "method", "Lcom/embabel/agent/rag/service/ResultExpander$Method;", "elementsToAdd", "expandBySequence", "chunk", "chunksToAdd", "textSearch", "performTextSearch", "performHybridSearch", "createChunkFromLuceneDocument", "luceneDocument", "Lorg/apache/lucene/document/Document;", "rebuildHierarchy", "createContentElementFromLuceneDocument", "elementType", "persistChunksWithEmbeddings", "chunks", "embeddings", "", "createLuceneDocument", "embedding", "commit", "cosineSimilarity", "a", "b", "bytesToFloatArray", "bytes", "", "loadExistingChunks", "refreshReaderIfNeeded", "invalidateReader", "infoString", "verbose", "indent", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "close", "deleteRootAndDescendants", "Lcom/embabel/agent/rag/store/DocumentDeletionResult;", "uri", "findContentRootByUri", "Lcom/embabel/agent/rag/model/ContentRoot;", "clear", "info", "Lcom/embabel/agent/rag/lucene/LuceneStatistics;", "Companion", "embabel-agent-rag-lucene"})
@SourceDebugExtension(value={"SMAP\nLuceneSearchOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneSearchOperations.kt\ncom/embabel/agent/rag/lucene/LuceneSearchOperations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1046:1\n1#2:1047\n1#2:1058\n1#2:1094\n1#2:1130\n1#2:1157\n1611#3,9:1048\n1863#3:1057\n1864#3:1059\n1620#3:1060\n1053#3:1061\n1863#3,2:1063\n1863#3:1068\n1864#3:1071\n1062#3:1083\n1611#3,9:1084\n1863#3:1093\n1864#3:1095\n1620#3:1096\n774#3:1097\n865#3,2:1098\n1062#3:1100\n1557#3:1101\n1628#3,3:1102\n774#3:1105\n865#3,2:1106\n1062#3:1108\n1557#3:1109\n1628#3,3:1110\n774#3:1113\n865#3,2:1114\n1557#3:1116\n1628#3,3:1117\n808#3,11:1133\n774#3:1144\n865#3,2:1145\n1611#3,9:1147\n1863#3:1156\n1864#3:1158\n1620#3:1159\n1053#3:1160\n360#3,7:1161\n1557#3:1168\n1628#3,3:1169\n774#3:1172\n865#3,2:1173\n1557#3:1175\n1628#3,3:1176\n808#3,11:1183\n774#3:1194\n865#3,2:1195\n1863#3:1197\n1864#3:1205\n808#3,11:1206\n1863#3,2:1217\n808#3,11:1219\n774#3:1230\n865#3,2:1231\n1863#3,2:1233\n1863#3,2:1235\n1863#3,2:1237\n1755#3,3:1239\n1863#3,2:1242\n1863#3,2:1244\n1863#3,2:1246\n1863#3,2:1248\n1755#3,3:1250\n1782#3,4:1253\n808#3,11:1257\n1557#3:1268\n1628#3,3:1269\n1557#3:1272\n1628#3,3:1273\n216#4:1062\n216#4,2:1065\n217#4:1067\n126#4:1079\n153#4,3:1080\n13402#5,2:1069\n11476#5,9:1120\n13402#5:1129\n13403#5:1131\n11485#5:1132\n11158#5:1179\n11493#5,3:1180\n535#6:1072\n520#6,6:1073\n381#6,7:1198\n*S KotlinDebug\n*F\n+ 1 LuceneSearchOperations.kt\ncom/embabel/agent/rag/lucene/LuceneSearchOperations\n*L\n186#1:1058\n375#1:1094\n478#1:1130\n563#1:1157\n186#1:1048,9\n186#1:1057\n186#1:1059\n186#1:1060\n230#1:1061\n275#1:1063,2\n336#1:1068\n336#1:1071\n352#1:1083\n375#1:1084,9\n375#1:1093\n375#1:1095\n375#1:1096\n382#1:1097\n382#1:1098,2\n383#1:1100\n390#1:1101\n390#1:1102,3\n421#1:1105\n421#1:1106,2\n422#1:1108\n429#1:1109\n429#1:1110,3\n453#1:1113\n453#1:1114,2\n454#1:1116\n454#1:1117,3\n561#1:1133,11\n562#1:1144\n562#1:1145,2\n563#1:1147,9\n563#1:1156\n563#1:1158\n563#1:1159\n567#1:1160\n574#1:1161,7\n585#1:1168\n585#1:1169,3\n616#1:1172\n616#1:1173,2\n617#1:1175\n617#1:1176,3\n699#1:1183,11\n700#1:1194\n700#1:1195,2\n701#1:1197\n701#1:1205\n749#1:1206,11\n750#1:1217,2\n754#1:1219,11\n755#1:1230\n755#1:1231,2\n758#1:1233,2\n770#1:1235,2\n775#1:1237,2\n927#1:1239,3\n944#1:1242,2\n956#1:1244,2\n975#1:1246,2\n980#1:1248,2\n1001#1:1250,3\n1034#1:1253,4\n1036#1:1257,11\n1036#1:1268\n1036#1:1269,3\n714#1:1272\n714#1:1273,3\n250#1:1062\n286#1:1065,2\n250#1:1067\n348#1:1079\n348#1:1080,3\n340#1:1069,2\n478#1:1120,9\n478#1:1129\n478#1:1131\n478#1:1132\n635#1:1179\n635#1:1180,3\n347#1:1072\n347#1:1073,6\n703#1:1198,7\n*E\n"})
public final class LuceneSearchOperations
extends AbstractChunkingContentElementRepository
implements RagFacetProvider,
HasInfoString,
Closeable,
CoreSearchOperations,
FinderOperations,
ResultExpander {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<RetrievableEnhancer> enhancers;
    @Nullable
    private final KeywordExtractor keywordExtractor;
    private final double vectorWeight;
    @Nullable
    private final Path indexPath;
    @NotNull
    private final StandardAnalyzer analyzer;
    @NotNull
    private final Directory directory;
    @NotNull
    private final IndexWriterConfig indexWriterConfig;
    @NotNull
    private IndexWriter indexWriter;
    @NotNull
    private final QueryParser queryParser;
    @NotNull
    private final String luceneSyntaxNotes;
    private boolean chunksLoaded;
    @Nullable
    private volatile DirectoryReader directoryReader;
    @NotNull
    private final ConcurrentHashMap<String, ContentElement> contentElementStorage;
    @NotNull
    public static final String KEYWORDS_FIELD = "keywords";

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService, @Nullable KeywordExtractor keywordExtractor, double vectorWeight, @NotNull ContentChunker.Config chunkerConfig, @NotNull ChunkTransformer chunkTransformer, @Nullable Path indexPath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)chunkerConfig, (String)"chunkerConfig");
        Intrinsics.checkNotNullParameter((Object)chunkTransformer, (String)"chunkTransformer");
        super(chunkerConfig, chunkTransformer, embeddingService);
        this.name = name;
        this.enhancers = enhancers;
        this.keywordExtractor = keywordExtractor;
        this.vectorWeight = vectorWeight;
        this.indexPath = indexPath;
        this.analyzer = new StandardAnalyzer();
        v0 = this;
        v1 = this.indexPath;
        if (v1 == null) ** GOTO lbl-1000
        var13_9 = v1;
        var15_10 = v0;
        $i$a$-let-LuceneSearchOperations$directory$1 = false;
        v2 = FSDirectory.open((Path)it);
        v0 = var15_10;
        v1 = v2;
        if (v2 != null) {
            v3 = (Directory)v1;
        } else lbl-1000:
        // 2 sources

        {
            v3 = (Directory)new ByteBuffersDirectory();
        }
        v0.directory = v3;
        var11_13 = var10_12 = new IndexWriterConfig((Analyzer)this.analyzer);
        var15_10 = this;
        $i$a$-apply-LuceneSearchOperations$indexWriterConfig$1 = false;
        $this$indexWriterConfig_u24lambda_u241.setCodec((Codec)new HighDimensionVectorCodec(0, 1, null));
        var15_10.indexWriterConfig = var10_12;
        this.indexWriter = new IndexWriter(this.directory, this.indexWriterConfig);
        this.queryParser = new QueryParser("content", (Analyzer)this.analyzer);
        this.luceneSyntaxNotes = "Full support";
        if (this.indexPath != null) {
            this.getLogger().info("Using disk-based Lucene index at: {}", (Object)this.indexPath);
        } else {
            this.getLogger().info("Using in-memory Lucene index");
        }
        this.contentElementStorage = new ConcurrentHashMap<K, V>();
    }

    public /* synthetic */ LuceneSearchOperations(String string, List list, EmbeddingService embeddingService, KeywordExtractor keywordExtractor, double d, ContentChunker.Config config, ChunkTransformer chunkTransformer, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            embeddingService = null;
        }
        if ((n & 8) != 0) {
            keywordExtractor = null;
        }
        if ((n & 0x10) != 0) {
            d = 0.5;
        }
        if ((n & 0x20) != 0) {
            config = new ContentChunker.Config(0, 0, 0, 7, null);
        }
        if ((n & 0x40) != 0) {
            chunkTransformer = ChunkTransformer.NO_OP;
        }
        if ((n & 0x80) != 0) {
            path = null;
        }
        this(string, list, embeddingService, keywordExtractor, d, config, chunkTransformer, path);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<RetrievableEnhancer> getEnhancers() {
        return this.enhancers;
    }

    @NotNull
    public String getLuceneSyntaxNotes() {
        return this.luceneSyntaxNotes;
    }

    private final void ensureChunksLoaded() {
        if (!this.chunksLoaded && this.indexPath != null) {
            this.getLogger().info("Triggering lazy loading of existing chunks...");
            this.loadExistingChunks();
            this.chunksLoaded = true;
        }
    }

    @NotNull
    public final LuceneSearchOperations loadExistingChunksFromDisk() {
        this.getLogger().info("Manually triggering chunk loading from disk...");
        this.ensureChunksLoaded();
        return this;
    }

    public boolean supportsType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)Chunk.class.getSimpleName());
    }

    @Nullable
    public <T> T findById(@NotNull String id, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (!clazz.isAssignableFrom(Chunk.class)) {
            this.getLogger().warn("findById only supports Chunk class in LuceneSearchOperations, requested: {}", (Object)clazz.getName());
            return null;
        }
        return (T)CollectionsKt.firstOrNull((List)this.findAllChunksById(CollectionsKt.listOf((Object)id)));
    }

    @Nullable
    public <T extends Retrievable> T findById(@NotNull String id, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!Intrinsics.areEqual((Object)type, (Object)Chunk.class.getSimpleName())) {
            this.getLogger().warn("findById only supports Chunk class in LuceneSearchOperations, requested: {}", (Object)type);
            return null;
        }
        return (T)((Retrievable)CollectionsKt.firstOrNull((List)this.findAllChunksById(CollectionsKt.listOf((Object)id))));
    }

    @NotNull
    public List<RagFacet<? extends Retrievable>> facets() {
        Object[] objectArray = new FunctionRagFacet[]{new FunctionRagFacet(this.getName() + ".hybrid", (Function1)new Function1<RagRequest, RagFacetResults<Chunk>>((Object)this){

            public final RagFacetResults<Chunk> invoke(RagRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LuceneSearchOperations)this.receiver).hybridSearch(p0);
            }
        }), new FunctionRagFacet(this.getName() + ".keywords", (Function1)new Function1<RagRequest, RagFacetResults<Chunk>>((Object)this){

            public final RagFacetResults<Chunk> invoke(RagRequest p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LuceneSearchOperations)this.receiver).keywordSearch(p0);
            }
        })};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Chunk> findAllChunksById(@NotNull List<String> chunkIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(chunkIds, (String)"chunkIds");
        this.getLogger().debug("Finding chunks by IDs: {}", chunkIds);
        Iterable $this$mapNotNull$iv = chunkIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Chunk it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String chunkId = (String)element$iv$iv;
            boolean bl2 = false;
            ContentElement contentElement = this.contentElementStorage.get(chunkId);
            if ((contentElement instanceof Chunk ? (Chunk)contentElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List foundChunks = (List)destination$iv$iv;
        this.getLogger().debug("Found {}/{} chunks by id", (Object)foundChunks.size(), (Object)chunkIds.size());
        return foundChunks;
    }

    @NotNull
    public List<Chunk> findChunksForEntity(@NotNull String entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        String string = "Entities not supported in LuceneRagService";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public ContentElement findById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.contentElementStorage.get(id);
    }

    @NotNull
    public ContentElement save(@NotNull ContentElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ((Map)this.contentElementStorage).put(element.getId(), element);
        if (!(element instanceof Chunk)) {
            this.persistStructuralElement(element);
        }
        return element;
    }

    private final void persistStructuralElement(ContentElement element) {
        Document luceneDoc = LuceneDocumentMapper.INSTANCE.createStructuralElementDocument(element);
        this.indexWriter.addDocument((Iterable)luceneDoc);
        this.getLogger().debug("Persisted structural element id='{}' type='{}'", (Object)element.getId(), (Object)element.getClass().getSimpleName());
    }

    protected void createInternalRelationships(@NotNull NavigableDocument root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
    }

    @NotNull
    public final <T extends ContentElement> List<T> findAll(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.ensureChunksLoaded();
        this.getLogger().debug("Retrieving all content elements from storage");
        Collection<ContentElement> collection = this.contentElementStorage.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$sortedBy$iv = CollectionsKt.filterIsInstance((Iterable)collection, clazz);
        boolean $i$f$sortedBy = false;
        List allChunks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ContentElement it = (ContentElement)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)(((Datum)it).getMetadata().get("container_section_id") + "-" + ((Datum)it).getMetadata().get("sequence_number")));
                it = (ContentElement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)(((Datum)it).getMetadata().get("container_section_id") + "-" + ((Datum)it).getMetadata().get("sequence_number")))));
            }
        });
        this.getLogger().debug("Retrieved {} chunks from storage", (Object)allChunks.size());
        return allChunks;
    }

    @NotNull
    public final List<Chunk> findAll() {
        return this.findAll(Chunk.class);
    }

    public final void updateKeywords(@NotNull Map<String, ? extends List<String>> updates) {
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        this.getLogger().debug("Updating keywords for {} chunks", (Object)updates.size());
        int updatedCount = 0;
        Map<String, ? extends List<String>> $this$forEach$iv = updates;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Chunk chunk;
            Map.Entry<String, ? extends List<String>> element$iv2;
            Map.Entry<String, ? extends List<String>> entry = element$iv2 = iterator.next();
            boolean bl = false;
            String chunkId = entry.getKey();
            List<String> newKeywords = entry.getValue();
            ContentElement contentElement = this.contentElementStorage.get(chunkId);
            Chunk chunk2 = chunk = contentElement instanceof Chunk ? (Chunk)contentElement : null;
            if (chunk == null) {
                this.getLogger().warn("Chunk with id='{}' not found, skipping keyword update", (Object)chunkId);
                continue;
            }
            Term[] termArray = Chunk.Companion;
            String string = chunk.getId();
            String string2 = chunk.getText();
            String string3 = chunk.getParentId();
            Map map = MapsKt.plus((Map)chunk.getMetadata(), (Pair)TuplesKt.to((Object)KEYWORDS_FIELD, newKeywords));
            Chunk updatedChunk = termArray.invoke(string, string2, map, string3);
            ((Map)this.contentElementStorage).put(chunkId, updatedChunk);
            termArray = new Term[]{new Term("id", chunkId)};
            this.indexWriter.deleteDocuments(termArray);
            String $this$updateKeywords_u24lambda_u247_u24lambda_u246 = string = new Document();
            boolean bl2 = false;
            $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new StringField("id", chunk.getId(), Field.Store.YES));
            $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new TextField("content", chunk.embeddableValue(), Field.Store.YES));
            Object $this$forEach$iv2 = newKeywords;
            boolean $i$f$forEach2 = false;
            Iterator<Object> iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                String keyword = (String)element$iv;
                boolean bl3 = false;
                String string4 = keyword.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new TextField(KEYWORDS_FIELD, string4, Field.Store.YES));
            }
            if (this.getEmbeddingService() != null && chunk.getMetadata().containsKey("embedding")) {
                EmbeddingService embeddingService = this.getEmbeddingService();
                Intrinsics.checkNotNull((Object)embeddingService);
                float[] embedding = embeddingService.embed(chunk.embeddableValue());
                $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new KnnFloatVectorField("embedding", embedding, VectorSimilarityFunction.COSINE));
                $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new StoredField("embedding", VectorMath.INSTANCE.floatArrayToBytes(embedding)));
            }
            $this$forEach$iv2 = chunk.getMetadata();
            $i$f$forEach2 = false;
            iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object = element$iv = (Map.Entry)iterator2.next();
                boolean bl4 = false;
                String key = (String)object.getKey();
                Object value = object.getValue();
                if (Intrinsics.areEqual((Object)key, (Object)KEYWORDS_FIELD)) continue;
                $this$updateKeywords_u24lambda_u247_u24lambda_u246.add((IndexableField)new StringField(key, String.valueOf(value), Field.Store.YES));
            }
            String luceneDoc = string;
            this.indexWriter.addDocument((Iterable)((Object)luceneDoc));
            ++updatedCount;
            this.getLogger().debug("Updated keywords for chunk id='{}' to: {}", (Object)chunkId, newKeywords);
        }
        if (updatedCount > 0) {
            this.commit();
        }
        this.getLogger().info("Successfully updated keywords for {} chunks", (Object)updatedCount);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, Integer>> findChunkIdsByKeywords(@NotNull Set<String> keywords, int minIntersection, int maxResults) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map.Entry entry;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Intrinsics.checkNotNullParameter(keywords, (String)KEYWORDS_FIELD);
        if (keywords.isEmpty()) {
            this.getLogger().warn("No keywords provided for keyword search");
            return CollectionsKt.emptyList();
        }
        this.refreshReaderIfNeeded();
        DirectoryReader directoryReader = this.directoryReader;
        if (directoryReader == null) {
            return CollectionsKt.emptyList();
        }
        DirectoryReader reader = directoryReader;
        if (reader.maxDoc() == 0) {
            return CollectionsKt.emptyList();
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Map docMatchCounts = new LinkedHashMap();
        Object $this$forEach$iv = keywords;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String keyword = (String)element$iv;
            boolean bl = false;
            QueryParser queryParser = new QueryParser(KEYWORDS_FIELD, (Analyzer)this.analyzer);
            String string = keyword.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Query query = queryParser.parse(QueryParser.escape((String)string));
            TopDocs topDocs = searcher.search(query, reader.maxDoc());
            Intrinsics.checkNotNullExpressionValue((Object)topDocs.scoreDocs, (String)"scoreDocs");
            Object[] $this$forEach$iv2 = topDocs.scoreDocs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ScoreDoc scoreDoc = (ScoreDoc)element$iv2;
                boolean bl2 = false;
                docMatchCounts.put(scoreDoc.doc, ((Number)docMatchCounts.getOrDefault(scoreDoc.doc, 0)).intValue() + 1);
            }
        }
        $this$forEach$iv = docMatchCounts;
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            int matchCount = ((Number)entry.getValue()).intValue();
            if (!(matchCount >= minIntersection)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            int docId = ((Number)entry.getKey()).intValue();
            int matchCount = ((Number)entry.getValue()).intValue();
            Document doc = searcher.storedFields().document(docId);
            object.add(TuplesKt.to((Object)doc.get("id"), (Object)matchCount));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        }), (int)maxResults);
    }

    public static /* synthetic */ List findChunkIdsByKeywords$default(LuceneSearchOperations luceneSearchOperations, Set set, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        return luceneSearchOperations.findChunkIdsByKeywords(set, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RagFacetResults<Chunk> keywordSearch(@NotNull RagRequest ragRequest) {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object[] objectArray;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
        if (this.keywordExtractor == null || this.keywordExtractor.getKeywords().isEmpty()) {
            this.getLogger().warn("Keyword search requested but no keywords configured");
            return new RagFacetResults(this.getName(), CollectionsKt.emptyList());
        }
        this.ensureChunksLoaded();
        this.refreshReaderIfNeeded();
        Set extractedKeywords = this.keywordExtractor.extractKeywords(ragRequest.getQuery());
        List<Pair<String, Integer>> results = this.findChunkIdsByKeywords(extractedKeywords, 1, ragRequest.getTopK() * 5);
        Object[] objectArray2 = (Object[])results;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SimpleSimilaritySearchResult simpleSimilaritySearchResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            objectArray = (Object[])element$iv$iv;
            boolean bl2 = false;
            String chunkId = (String)objectArray.component1();
            int matchCount = ((Number)objectArray.component2()).intValue();
            ContentElement contentElement = this.contentElementStorage.get(chunkId);
            if ((contentElement instanceof Chunk ? (Chunk)contentElement : null) == null) {
                simpleSimilaritySearchResult = null;
            } else {
                Chunk chunk;
                chunk = chunk;
                simpleSimilaritySearchResult = new SimpleSimilaritySearchResult((Object)chunk, this.keywordExtractor.matchCountToScore(matchCount));
            }
            if (simpleSimilaritySearchResult == null) continue;
            SimpleSimilaritySearchResult it$iv$iv = simpleSimilaritySearchResult;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SimpleSimilaritySearchResult it = (SimpleSimilaritySearchResult)element$iv$iv;
            boolean bl = false;
            if (!(it.getScore() >= ragRequest.getSimilarityThreshold())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending22 = false;
        List similarityResults = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimpleSimilaritySearchResult it = (SimpleSimilaritySearchResult)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (SimpleSimilaritySearchResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)ragRequest.getTopK());
        objectArray2 = new Object[4];
        objectArray2[0] = ragRequest.getQuery();
        objectArray2[1] = extractedKeywords;
        objectArray2[2] = similarityResults.size();
        Iterable $i$f$sortedByDescending22 = similarityResults;
        int n = 3;
        Object[] objectArray3 = objectArray2;
        String string = "Keyword search for query '{}' with keywords [{}] found {} results: {}";
        Logger logger = this.getLogger();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SimpleSimilaritySearchResult bl = (SimpleSimilaritySearchResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            String string2 = ((Chunk)it.getMatch()).getId();
            String string3 = "%.2f";
            objectArray = new Object[]{it.getScore()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            collection.add((CallSite)((Object)("(" + string2 + ", score=" + string4 + ")")));
        }
        collection = (List)destination$iv$iv2;
        objectArray3[n] = collection;
        logger.info(string, objectArray2);
        return new RagFacetResults(this.getName() + ".vector", similarityResults);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RagFacetResults<Chunk> hybridSearch(@NotNull RagRequest ragRequest) {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<SimpleSimilaritySearchResult<Chunk>> list;
        Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
        this.ensureChunksLoaded();
        this.refreshReaderIfNeeded();
        DirectoryReader directoryReader = this.directoryReader;
        if (directoryReader == null) {
            return new RagFacetResults(this.getName() + ".hybrid", CollectionsKt.emptyList());
        }
        DirectoryReader reader = directoryReader;
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        if (this.getEmbeddingService() != null) {
            r = this.performHybridSearch(searcher, ragRequest);
            this.getLogger().debug("Hybrid search for query {} found\n{}", (Object)ragRequest.getQuery(), r);
            list = r;
        } else {
            r = this.performTextSearch(searcher, ragRequest);
            this.getLogger().debug("Text search for query {} found\n{}", (Object)ragRequest.getQuery(), r);
            list = r;
        }
        List<SimpleSimilaritySearchResult<Chunk>> results = list;
        Object[] objectArray = (Object[])results;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SimpleSimilaritySearchResult it = (SimpleSimilaritySearchResult)element$iv$iv;
            boolean bl = false;
            if (!(it.getScore() >= ragRequest.getSimilarityThreshold())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending22 = false;
        List similarityResults = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimpleSimilaritySearchResult it = (SimpleSimilaritySearchResult)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (SimpleSimilaritySearchResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)ragRequest.getTopK());
        objectArray = new Object[3];
        objectArray[0] = ragRequest.getQuery();
        objectArray[1] = similarityResults.size();
        Iterable $i$f$sortedByDescending22 = similarityResults;
        int n = 2;
        Object[] objectArray2 = objectArray;
        String string = "Hybrid search for query {} found {} results: {}";
        Logger logger = this.getLogger();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SimpleSimilaritySearchResult bl = (SimpleSimilaritySearchResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string2 = ((Chunk)it.getMatch()).getId();
            String string3 = "%.2f";
            Object[] objectArray3 = new Object[]{it.getScore()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            collection.add((CallSite)((Object)("(" + string2 + ", score=" + string4 + ")")));
        }
        collection = (List)destination$iv$iv2;
        objectArray2[n] = collection;
        logger.info(string, objectArray);
        return new RagFacetResults(this.getName(), similarityResults);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> vectorSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SimpleSimilaritySearchResult it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.getEmbeddingService() == null) {
            this.getLogger().warn("Vector search requested but no embedding model configured");
            return CollectionsKt.emptyList();
        }
        this.ensureChunksLoaded();
        this.refreshReaderIfNeeded();
        DirectoryReader directoryReader = this.directoryReader;
        if (directoryReader == null) {
            return CollectionsKt.emptyList();
        }
        DirectoryReader reader = directoryReader;
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Iterable iterable = this.performVectorSearch(searcher, request);
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SimpleSimilaritySearchResult)element$iv$iv;
            boolean bl = false;
            if (!clazz.isInstance(it.getMatch())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SimpleSimilaritySearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getMatch();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.embabel.agent.rag.lucene.LuceneSearchOperations.vectorSearch");
            collection.add(new SimpleSimilaritySearchResult((Object)((Retrievable)object), it.getScore()));
        }
        List results = (List)destination$iv$iv;
        this.getLogger().info("Vector search for query '{}' found {} results", (Object)request.getQuery(), (Object)results.size());
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleSimilaritySearchResult<Chunk>> performVectorSearch(IndexSearcher searcher, TextSimilaritySearchRequest request) {
        void $this$mapNotNullTo$iv$iv;
        EmbeddingService embeddingService = this.getEmbeddingService();
        Intrinsics.checkNotNull((Object)embeddingService);
        float[] queryEmbedding = embeddingService.embed(request.getQuery());
        KnnFloatVectorQuery knnQuery = new KnnFloatVectorQuery("embedding", queryEmbedding, request.getTopK());
        TopDocs topDocs = searcher.search((Query)knnQuery, request.getTopK());
        Intrinsics.checkNotNullExpressionValue((Object)topDocs, (String)"search(...)");
        TopDocs topDocs2 = topDocs;
        Intrinsics.checkNotNullExpressionValue((Object)topDocs2.scoreDocs, (String)"scoreDocs");
        Object[] $this$mapNotNull$iv = topDocs2.scoreDocs;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            SimpleSimilaritySearchResult it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            ScoreDoc scoreDoc = (ScoreDoc)element$iv$iv;
            boolean bl2 = false;
            Document doc = searcher.doc(scoreDoc.doc);
            Intrinsics.checkNotNull((Object)doc);
            Chunk chunk = this.createChunkFromLuceneDocument(doc);
            double score = scoreDoc.score;
            if ((score >= request.getSimilarityThreshold() ? new SimpleSimilaritySearchResult((Object)chunk, score) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ContentElement> expandResult(@NotNull String id, @NotNull ResultExpander.Method method, int elementsToAdd) {
        List list;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.ensureChunksLoaded();
        ContentElement contentElement = this.contentElementStorage.get(id);
        if (contentElement == null) {
            this.getLogger().warn("Chunk with id='{}' not found for expansion", (Object)id);
            return CollectionsKt.emptyList();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                if (!(contentElement instanceof Chunk)) {
                    this.getLogger().warn("Content element id='{}' is not a Chunk; cannot expand by sequence", (Object)id);
                    return CollectionsKt.emptyList();
                }
                list = this.expandBySequence((Chunk)contentElement, elementsToAdd);
                break;
            }
            case 2: {
                String parentId;
                ContentElement contentElement2 = contentElement;
                String string = contentElement2 instanceof Chunk ? ((Chunk)contentElement).getParentId() : (parentId = contentElement2 instanceof HierarchicalContentElement ? ((HierarchicalContentElement)contentElement).getParentId() : null);
                if (parentId != null) {
                    ContentElement parentElement = this.contentElementStorage.get(parentId);
                    if (parentElement != null) {
                        list = CollectionsKt.listOf((Object)parentElement);
                        break;
                    }
                    this.getLogger().warn("Parent element with id='{}' not found for zoom out expansion", (Object)parentId);
                    list = CollectionsKt.emptyList();
                    break;
                }
                this.getLogger().warn("Content element id='{}' has no parentId for zoom out expansion", (Object)id);
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> expandBySequence(Chunk chunk, int chunksToAdd) {
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int currentIndex;
        List chunksInSection;
        Chunk c;
        Integer sequenceNumber;
        block9: {
            int n;
            void $this$sortedBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Object v = chunk.getMetadata().get("container_section_id");
            String containerSectionId = v != null ? v.toString() : null;
            Object v2 = chunk.getMetadata().get("sequence_number");
            Integer n2 = v2 != null && (v2 = v2.toString()) != null ? StringsKt.toIntOrNull(v2) : (sequenceNumber = null);
            if (containerSectionId == null || sequenceNumber == null) {
                Object[] objectArray = new Object[]{chunk.getId(), containerSectionId, sequenceNumber};
                this.getLogger().warn("Chunk id='{}' missing required metadata for sequence expansion: containerSectionId={}, sequenceNumber={}", objectArray);
                return CollectionsKt.listOf((Object)chunk);
            }
            Collection<ContentElement> collection = this.contentElementStorage.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$filterIsInstance = false;
            void var8_12 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Chunk)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Chunk)element$iv$iv;
                boolean bl = false;
                Object v3 = it.getMetadata().get("container_section_id");
                if (!Intrinsics.areEqual((Object)(v3 != null ? v3.toString() : null), (Object)containerSectionId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                Pair it$iv$iv;
                Integer seqNum;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                c = (Chunk)element$iv$iv;
                boolean bl2 = false;
                Object v4 = c.getMetadata().get("sequence_number");
                Integer n3 = seqNum = v4 != null && (v4 = v4.toString()) != null ? StringsKt.toIntOrNull(v4) : null;
                if ((n3 != null ? TuplesKt.to((Object)c, (Object)n3) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            chunksInSection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            if (chunksInSection.isEmpty()) {
                return CollectionsKt.listOf((Object)chunk);
            }
            List $this$indexOfFirst$iv = chunksInSection;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Pair it2 = (Pair)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)((Chunk)it2.getFirst()).getId(), (Object)chunk.getId())) {
                    n = index$iv;
                    break block9;
                }
                ++index$iv;
            }
            n = currentIndex = -1;
        }
        if (currentIndex == -1) {
            return CollectionsKt.listOf((Object)chunk);
        }
        int startIndex = RangesKt.coerceAtLeast((int)(currentIndex - chunksToAdd), (int)0);
        int endIndex = RangesKt.coerceAtMost((int)(currentIndex + chunksToAdd), (int)(chunksInSection.size() - 1));
        Iterable $i$f$mapNotNullTo = chunksInSection.subList(startIndex, endIndex + 1);
        boolean $i$f$map = false;
        void it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            c = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Chunk)it.getFirst());
        }
        List expandedChunks = (List)destination$iv$iv;
        Object[] objectArray = new Object[]{chunk.getId(), sequenceNumber, expandedChunks.size(), (object2 = (Chunk)CollectionsKt.firstOrNull((List)expandedChunks)) != null && (object2 = object2.getMetadata()) != null ? object2.get("sequence_number") : null, (object = (Chunk)CollectionsKt.lastOrNull((List)expandedChunks)) != null && (object = object.getMetadata()) != null ? object.get("sequence_number") : null};
        this.getLogger().debug("Expanded chunk id='{}' (seq={}) to {} chunks (seq range {}-{})", objectArray);
        return expandedChunks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> textSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SimpleSimilaritySearchResult it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.ensureChunksLoaded();
        this.refreshReaderIfNeeded();
        DirectoryReader directoryReader = this.directoryReader;
        if (directoryReader == null) {
            return CollectionsKt.emptyList();
        }
        DirectoryReader reader = directoryReader;
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        RagRequest ragRequest = new RagRequest(request.getQuery(), request.getSimilarityThreshold(), request.getTopK(), null, null, null, null, 120, null);
        Iterable iterable = this.performTextSearch(searcher, ragRequest);
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SimpleSimilaritySearchResult)element$iv$iv;
            boolean bl = false;
            if (!clazz.isInstance(it.getMatch())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SimpleSimilaritySearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getMatch();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.embabel.agent.rag.lucene.LuceneSearchOperations.textSearch");
            collection.add(new SimpleSimilaritySearchResult((Object)((Retrievable)object), it.getScore()));
        }
        List results = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)request.getTopK());
        this.getLogger().info("Text search for query '{}' found {} results", (Object)request.getQuery(), (Object)results.size());
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimpleSimilaritySearchResult<Chunk>> performTextSearch(IndexSearcher searcher, RagRequest ragRequest) {
        void $this$mapTo$iv$iv;
        Query query = this.queryParser.parse(QueryParser.escape((String)ragRequest.getQuery()));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"parse(...)");
        Query query2 = query;
        TopDocs topDocs = searcher.search(query2, ragRequest.getTopK());
        Intrinsics.checkNotNullExpressionValue((Object)topDocs, (String)"search(...)");
        TopDocs topDocs2 = topDocs;
        Intrinsics.checkNotNullExpressionValue((Object)topDocs2.scoreDocs, (String)"scoreDocs");
        Object[] $this$map$iv = topDocs2.scoreDocs;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void scoreDoc;
            ScoreDoc scoreDoc2 = (ScoreDoc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Document doc = searcher.doc(scoreDoc.doc);
            Intrinsics.checkNotNull((Object)doc);
            Chunk retrievable = this.createChunkFromLuceneDocument(doc);
            collection.add(new SimpleSimilaritySearchResult((Object)retrievable, (double)scoreDoc.score));
        }
        return (List)destination$iv$iv;
    }

    private final List<SimpleSimilaritySearchResult<Chunk>> performHybridSearch(IndexSearcher searcher, RagRequest ragRequest) {
        Query query = this.queryParser.parse(QueryParser.escape((String)ragRequest.getQuery()));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"parse(...)");
        Query textQuery = query;
        TopDocs topDocs = searcher.search(textQuery, RangesKt.coerceAtLeast((int)(ragRequest.getTopK() * 2), (int)20));
        Intrinsics.checkNotNullExpressionValue((Object)topDocs, (String)"search(...)");
        TopDocs textResults = topDocs;
        EmbeddingService embeddingService = this.getEmbeddingService();
        Intrinsics.checkNotNull((Object)embeddingService);
        float[] queryEmbedding = embeddingService.embed(ragRequest.getQuery());
        List hybridResults = new ArrayList();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])textResults.scoreDocs);
        while (iterator.hasNext()) {
            double d;
            ScoreDoc scoreDoc = (ScoreDoc)iterator.next();
            Document doc = searcher.doc(scoreDoc.doc);
            Intrinsics.checkNotNull((Object)doc);
            Chunk retrievable = this.createChunkFromLuceneDocument(doc);
            double textScore = scoreDoc.score;
            double normalizedTextScore = Math.min(1.0, textScore / 10.0);
            if (doc.getBinaryValue("embedding") != null) {
                BytesRef embeddingBytes;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)embeddingBytes.bytes, (String)"bytes");
                float[] docEmbedding = this.bytesToFloatArray(embeddingBytes.bytes);
                d = this.cosineSimilarity(queryEmbedding, docEmbedding);
            } else {
                d = 0.0;
            }
            double vectorScore = d;
            double hybridScore = (1.0 - this.vectorWeight) * normalizedTextScore + this.vectorWeight * vectorScore;
            hybridResults.add(new SimpleSimilaritySearchResult((Object)retrievable, hybridScore));
        }
        return hybridResults;
    }

    private final Chunk createChunkFromLuceneDocument(Document luceneDocument) {
        return LuceneDocumentMapper.INSTANCE.createChunkFromLuceneDocument(luceneDocument);
    }

    private final void rebuildHierarchy() {
        Iterable $this$filterTo$iv$iv;
        Object element$iv$iv;
        Object $this$filterIsInstanceTo$iv$iv;
        Map childrenByParentId = new LinkedHashMap();
        Collection<ContentElement> collection = this.contentElementStorage.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof NavigableSection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            NavigableSection it = (NavigableSection)element$iv$iv;
            boolean bl = false;
            HierarchicalContentElement hierarchicalContentElement = it instanceof HierarchicalContentElement ? (HierarchicalContentElement)it : null;
            if (!((hierarchicalContentElement != null ? hierarchicalContentElement.getParentId() : null) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String parentId;
            NavigableSection section = (NavigableSection)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)section, (String)"null cannot be cast to non-null type com.embabel.agent.rag.model.HierarchicalContentElement");
            Intrinsics.checkNotNull((Object)((HierarchicalContentElement)section).getParentId());
            Map $this$getOrPut$iv = childrenByParentId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(parentId);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(parentId, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(section);
        }
        Collection<ContentElement> collection2 = this.contentElementStorage.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        $this$filterIsInstance$iv = collection2;
        $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof MaterializedDocument)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MaterializedDocument doc = (MaterializedDocument)element$iv;
            boolean bl3 = false;
            LuceneSearchOperations.rebuildHierarchy$rebuildContainer(this, childrenByParentId, doc.getId());
        }
        Collection<ContentElement> collection3 = this.contentElementStorage.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"<get-values>(...)");
        $this$filterIsInstance$iv = collection3;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl3 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            element$iv$iv = bl3.next();
            if (!(element$iv$iv instanceof DefaultMaterializedContainerSection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        bl3 = $this$filterTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            element$iv$iv = bl3.next();
            DefaultMaterializedContainerSection section = (DefaultMaterializedContainerSection)element$iv$iv;
            boolean bl4 = false;
            if (!(section.getParentId() == null || !(((Map)this.contentElementStorage).get(section.getParentId()) instanceof NavigableContainerSection))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DefaultMaterializedContainerSection section = (DefaultMaterializedContainerSection)element$iv;
            boolean bl5 = false;
            LuceneSearchOperations.rebuildHierarchy$rebuildContainer(this, childrenByParentId, section.getId());
        }
        this.getLogger().debug("Rebuilt hierarchy for {} containers", (Object)childrenByParentId.size());
    }

    private final ContentElement createContentElementFromLuceneDocument(Document luceneDocument, String elementType) {
        return LuceneDocumentMapper.INSTANCE.createContentElementFromLuceneDocument(luceneDocument, elementType);
    }

    protected void persistChunksWithEmbeddings(@NotNull List<? extends Chunk> chunks, @NotNull Map<String, float[]> embeddings) {
        Chunk chunk;
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        Iterable $this$forEach$iv = chunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            chunk = (Chunk)element$iv;
            boolean bl = false;
            ((Map)this.contentElementStorage).put(chunk.getId(), chunk);
        }
        $this$forEach$iv = chunks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            chunk = (Chunk)element$iv;
            boolean bl = false;
            Document luceneDoc = this.createLuceneDocument(chunk, embeddings.get(chunk.getId()));
            this.indexWriter.addDocument((Iterable)luceneDoc);
        }
        this.getLogger().info("Indexed {} chunks", (Object)chunks.size());
    }

    private final Document createLuceneDocument(Chunk chunk, float[] embedding) {
        return LuceneDocumentMapper.INSTANCE.createLuceneDocument(chunk, embedding);
    }

    protected void commit() {
        this.indexWriter.flush();
        this.indexWriter.commit();
        this.invalidateReader();
    }

    private final double cosineSimilarity(float[] a, float[] b) {
        return VectorMath.INSTANCE.cosineSimilarity(a, b);
    }

    private final float[] bytesToFloatArray(byte[] bytes) {
        return VectorMath.INSTANCE.bytesToFloatArray(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadExistingChunks() {
        this.getLogger().info("Starting to load existing chunks from disk index...");
        try {
            Path path = this.indexPath;
            Intrinsics.checkNotNull((Object)path);
            try (FSDirectory readDirectory = FSDirectory.open((Path)path);){
                this.getLogger().info("Opening DirectoryReader to read from disk");
                DirectoryReader reader = DirectoryReader.open((Directory)((Directory)readDirectory));
                this.getLogger().info("Successfully opened reader. Index has {} documents (maxDoc: {})", (Object)reader.numDocs(), (Object)reader.maxDoc());
                Bits liveDocs = MultiBits.getLiveDocs((IndexReader)((IndexReader)reader));
                int n = reader.maxDoc();
                for (int i = 0; i < n; ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) {
                        this.getLogger().debug("Skipping deleted document at position {}", (Object)i);
                        continue;
                    }
                    try {
                        Document doc = reader.storedFields().document(i);
                        String elementType = doc.get("_element_type");
                        String id = doc.get("id");
                        Logger logger = this.getLogger();
                        Object[] objectArray = new Object[4];
                        objectArray[0] = i;
                        objectArray[1] = id;
                        objectArray[2] = elementType;
                        String string = doc.get("content");
                        if (string == null) {
                            string = "";
                        }
                        objectArray[3] = StringTrimmingUtilsKt.trim$default((String)string, (int)25, (int)4, null, (int)8, null);
                        logger.debug("Loading document {}: id={}, type={}, content preview={}", objectArray);
                        Intrinsics.checkNotNull((Object)doc);
                        ContentElement element = this.createContentElementFromLuceneDocument(doc, elementType);
                        if (element == null) continue;
                        ((Map)this.contentElementStorage).put(element.getId(), element);
                        Logger logger2 = this.getLogger();
                        String string2 = elementType;
                        if (string2 == null) {
                            string2 = "Chunk";
                        }
                        logger2.debug("\u2705 Loaded {} with id={}", (Object)string2, (Object)element.getId());
                        continue;
                    }
                    catch (Exception e) {
                        Object[] objectArray = new Object[]{i, e.getMessage(), e};
                        this.getLogger().error("\u274c Failed to load document {}: {}", objectArray);
                    }
                }
                reader.close();
                this.rebuildHierarchy();
                this.getLogger().info("\u2705 Loaded {} existing elements from disk index {}", (Object)this.contentElementStorage.size(), (Object)this.indexPath);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error loading existing chunks from disk index: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshReaderIfNeeded() {
        LuceneSearchOperations luceneSearchOperations = this;
        synchronized (luceneSearchOperations) {
            boolean bl = false;
            try {
                DirectoryReader directoryReader = this.directoryReader;
                if (directoryReader != null) {
                    directoryReader.close();
                }
                this.directoryReader = DirectoryReader.open((Directory)this.directory);
            }
            catch (Exception exception) {
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invalidateReader() {
        LuceneSearchOperations luceneSearchOperations = this;
        synchronized (luceneSearchOperations) {
            boolean bl = false;
            DirectoryReader directoryReader = this.directoryReader;
            if (directoryReader != null) {
                directoryReader.close();
            }
            this.directoryReader = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        String string;
        block5: {
            String basicInfo;
            block2: {
                Object object;
                String vectorWeightInfo;
                String embeddingInfo;
                block4: {
                    block3: {
                        LuceneStatistics stats = this.info();
                        String storageType = this.indexPath != null ? "disk" : "memory";
                        basicInfo = "LuceneRagService: " + this.getName() + " (" + stats.getDocumentCount() + " documents, " + stats.getChunkCount() + " chunks, " + storageType + ")";
                        if (!Intrinsics.areEqual((Object)verbose, (Object)true)) break block2;
                        embeddingInfo = stats.getHasEmbeddings() ? "with embeddings" : "text-only";
                        vectorWeightInfo = stats.getHasEmbeddings() ? ", vector weight: " + stats.getVectorWeight() : "";
                        object = stats.getIndexPath();
                        if (object == null) break block3;
                        String it = object;
                        boolean bl = false;
                        String string2 = ", path: " + it;
                        object = string2;
                        if (string2 != null) break block4;
                    }
                    object = "";
                }
                String pathInfo = object;
                string = FormatUtilsKt.indent$default((String)(basicInfo + " (" + embeddingInfo + vectorWeightInfo + pathInfo + ")"), (int)indent, null, (int)2, null);
                break block5;
            }
            string = FormatUtilsKt.indent$default((String)basicInfo, (int)indent, null, (int)2, null);
        }
        return string;
    }

    @Override
    public void close() {
        try {
            this.commit();
        }
        catch (Exception e) {
            this.getLogger().warn("Error committing changes during close: {}", (Object)e.getMessage());
        }
        DirectoryReader directoryReader = this.directoryReader;
        if (directoryReader != null) {
            directoryReader.close();
        }
        this.indexWriter.close();
        this.directory.close();
        this.analyzer.close();
        this.contentElementStorage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public DocumentDeletionResult deleteRootAndDescendants(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.getLogger().info("Deleting document with URI: {}", (Object)uri);
        LuceneSearchOperations luceneSearchOperations = this;
        synchronized (luceneSearchOperations) {
            Object v2;
            Term[] termArray;
            block13: {
                Object t;
                boolean bl;
                boolean bl2 = false;
                Collection<ContentElement> collection = this.contentElementStorage.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable iterable = collection;
                Iterator iterator = iterable.iterator();
                do {
                    block16: {
                        boolean bl3;
                        block14: {
                            block18: {
                                block15: {
                                    Iterable $this$any$iv;
                                    block17: {
                                        if (!iterator.hasNext()) break block15;
                                        t = iterator.next();
                                        ContentElement it = (ContentElement)t;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it.getUri(), (Object)uri)) break block16;
                                        $this$any$iv = it.labels();
                                        boolean $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block17;
                                        bl3 = false;
                                        break block14;
                                    }
                                    termArray = $this$any$iv.iterator();
                                    break block18;
                                }
                                v2 = null;
                                break block13;
                            }
                            while (termArray.hasNext()) {
                                Object element$iv = termArray.next();
                                String label = (String)element$iv;
                                boolean bl5 = false;
                                if (!(StringsKt.contains$default((CharSequence)label, (CharSequence)"Document", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)label, (CharSequence)"ContentRoot", (boolean)false, (int)2, null))) continue;
                                bl3 = true;
                                break block14;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                v2 = t;
            }
            ContentElement root = v2;
            if (root == null) {
                this.getLogger().warn("No document found with URI: {}", (Object)uri);
                return null;
            }
            this.getLogger().debug("Found root document with id: {}", (Object)root.getId());
            Set toDelete = new LinkedHashSet();
            toDelete.add(root.getId());
            Collection<ContentElement> collection = this.contentElementStorage.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ContentElement element = (ContentElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)element.getUri(), (Object)uri)) continue;
                toDelete.add(element.getId());
            }
            Set parentsToCheck = CollectionsKt.toMutableSet((Iterable)toDelete);
            block5: while (true) {
                if (!(!((Collection)parentsToCheck).isEmpty())) {
                    String id;
                    this.getLogger().info("Found {} elements to delete for URI: {}", (Object)toDelete.size(), (Object)uri);
                    Iterable $this$forEach$iv2 = toDelete;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        id = (String)element$iv;
                        boolean bl = false;
                        termArray = new Term[]{new Term("id", id)};
                        this.indexWriter.deleteDocuments(termArray);
                    }
                    $this$forEach$iv2 = toDelete;
                    $i$f$forEach2 = false;
                    Iterator iterator = $this$forEach$iv2.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.commit();
                            DocumentDeletionResult result = new DocumentDeletionResult(uri, toDelete.size());
                            this.getLogger().info("Deleted {} elements for document with URI: {}", (Object)toDelete.size(), (Object)uri);
                            return result;
                        }
                        Object element$iv = iterator.next();
                        id = (String)element$iv;
                        boolean bl = false;
                        this.contentElementStorage.remove(id);
                    }
                }
                Set currentParents = CollectionsKt.toSet((Iterable)parentsToCheck);
                parentsToCheck.clear();
                Collection<ContentElement> collection2 = this.contentElementStorage.values();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                Iterable $this$forEach$iv3 = collection2;
                boolean $i$f$forEach3 = false;
                Iterator element = $this$forEach$iv3.iterator();
                while (true) {
                    if (!element.hasNext()) continue block5;
                    Object element$iv = element.next();
                    ContentElement element2 = (ContentElement)element$iv;
                    boolean bl = false;
                    ContentElement contentElement = element2;
                    String parentId = contentElement instanceof Chunk ? ((Chunk)element2).getParentId() : (contentElement instanceof LeafSection ? ((LeafSection)element2).getParentId() : (contentElement instanceof NavigableContainerSection ? ((NavigableContainerSection)element2).getParentId() : null));
                    if (parentId == null || !currentParents.contains(parentId) || toDelete.contains(element2.getId())) continue;
                    toDelete.add(element2.getId());
                    parentsToCheck.add(element2.getId());
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ContentRoot findContentRootByUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.getLogger().debug("Finding root document with URI: {}", (Object)uri);
        LuceneSearchOperations luceneSearchOperations = this;
        synchronized (luceneSearchOperations) {
            Object v2;
            block5: {
                Object t;
                boolean bl;
                boolean bl2 = false;
                Collection<ContentElement> collection = this.contentElementStorage.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable iterable = collection;
                Iterator iterator = iterable.iterator();
                do {
                    block8: {
                        boolean bl3;
                        block6: {
                            Iterator iterator2;
                            block10: {
                                block7: {
                                    Iterable $this$any$iv;
                                    block9: {
                                        if (!iterator.hasNext()) break block7;
                                        t = iterator.next();
                                        ContentElement it = (ContentElement)t;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it.getUri(), (Object)uri)) break block8;
                                        $this$any$iv = it.labels();
                                        boolean $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block9;
                                        bl3 = false;
                                        break block6;
                                    }
                                    iterator2 = $this$any$iv.iterator();
                                    break block10;
                                }
                                v2 = null;
                                break block5;
                            }
                            while (iterator2.hasNext()) {
                                Object element$iv = iterator2.next();
                                String label = (String)element$iv;
                                boolean bl5 = false;
                                if (!(StringsKt.contains$default((CharSequence)label, (CharSequence)"Document", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)label, (CharSequence)"ContentRoot", (boolean)false, (int)2, null))) continue;
                                bl3 = true;
                                break block6;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                v2 = t;
            }
            Object var15_16 = v2;
            if (!(var15_16 instanceof ContentRoot)) return null;
            ContentRoot contentRoot = var15_16;
            return contentRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int clear() {
        int count = this.contentElementStorage.size();
        this.getLogger().info("Clearing all indexed content from Lucene RAG service");
        LuceneSearchOperations luceneSearchOperations = this;
        synchronized (luceneSearchOperations) {
            boolean bl = false;
            this.contentElementStorage.clear();
            this.indexWriter.deleteAll();
            this.indexWriter.commit();
            this.invalidateReader();
            Unit unit = Unit.INSTANCE;
        }
        this.getLogger().info("Cleared {} chunks from Lucene RAG service", (Object)count);
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LuceneStatistics info() {
        double d;
        int n;
        int n2 = this.findAll(Chunk.class).size();
        int n3 = this.contentElementStorage.size();
        Collection<ContentElement> collection = this.contentElementStorage.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ContentElement it = (ContentElement)element$iv;
                boolean bl = false;
                if (!(it instanceof NavigableDocument) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = n = count$iv;
        }
        if (!((Map)this.contentElementStorage).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object element$iv;
            Collection<ContentElement> collection2 = this.contentElementStorage.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable $this$filterIsInstance$iv = collection2;
            boolean $i$f$filterIsInstance = false;
            element$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Chunk)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Chunk chunk = (Chunk)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getText().length());
            }
            d = CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv));
        } else {
            d = 0.0;
        }
        double d2 = d;
        boolean bl = this.getEmbeddingService() != null;
        double d3 = this.vectorWeight;
        boolean bl2 = this.indexPath != null;
        Path path = this.indexPath;
        String string = path != null ? ((Object)path).toString() : null;
        return new LuceneStatistics(n2, n, n3, d2, bl, d3, bl2, string);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService, @Nullable KeywordExtractor keywordExtractor, double vectorWeight, @NotNull ContentChunker.Config chunkerConfig, @NotNull ChunkTransformer chunkTransformer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)chunkerConfig, (String)"chunkerConfig");
        Intrinsics.checkNotNullParameter((Object)chunkTransformer, (String)"chunkTransformer");
        this(name, enhancers, embeddingService, keywordExtractor, vectorWeight, chunkerConfig, chunkTransformer, null, 128, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService, @Nullable KeywordExtractor keywordExtractor, double vectorWeight, @NotNull ContentChunker.Config chunkerConfig) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        Intrinsics.checkNotNullParameter((Object)chunkerConfig, (String)"chunkerConfig");
        this(name, enhancers, embeddingService, keywordExtractor, vectorWeight, chunkerConfig, null, null, 192, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService, @Nullable KeywordExtractor keywordExtractor, double vectorWeight) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        this(name, enhancers, embeddingService, keywordExtractor, vectorWeight, null, null, null, 224, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService, @Nullable KeywordExtractor keywordExtractor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        this(name, enhancers, embeddingService, keywordExtractor, 0.0, null, null, null, 240, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers, @Nullable EmbeddingService embeddingService) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        this(name, enhancers, embeddingService, null, 0.0, null, null, null, 248, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name, @NotNull List<? extends RetrievableEnhancer> enhancers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enhancers, (String)"enhancers");
        this(name, enhancers, null, null, 0.0, null, null, null, 252, null);
    }

    @JvmOverloads
    public LuceneSearchOperations(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, null, null, null, 0.0, null, null, null, 254, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final ContentElement rebuildHierarchy$rebuildContainer(LuceneSearchOperations this$0, Map<String, List<NavigableSection>> childrenByParentId, String id) {
        ContentElement contentElement;
        void $this$mapTo$iv$iv;
        ContentElement contentElement2 = this$0.contentElementStorage.get(id);
        if (contentElement2 == null) {
            return null;
        }
        ContentElement element = contentElement2;
        List list = childrenByParentId.get(id);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List directChildren = list;
        Iterable $this$map$iv = directChildren;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            NavigableSection navigableSection;
            void child;
            NavigableSection navigableSection2 = (NavigableSection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (child instanceof DefaultMaterializedContainerSection) {
                ContentElement rebuilt = LuceneSearchOperations.rebuildHierarchy$rebuildContainer(this$0, childrenByParentId, ((DefaultMaterializedContainerSection)child).getId());
                navigableSection = rebuilt instanceof NavigableSection ? (NavigableSection)rebuilt : null;
                if (navigableSection == null) {
                    navigableSection = child;
                }
            } else {
                navigableSection = child;
            }
            collection.add(navigableSection);
        }
        List rebuiltChildren = (List)destination$iv$iv;
        ContentElement contentElement3 = element;
        if (contentElement3 instanceof DefaultMaterializedContainerSection) {
            DefaultMaterializedContainerSection defaultMaterializedContainerSection;
            if (!((Collection)rebuiltChildren).isEmpty()) {
                DefaultMaterializedContainerSection defaultMaterializedContainerSection2;
                it = defaultMaterializedContainerSection2 = DefaultMaterializedContainerSection.copy$default((DefaultMaterializedContainerSection)((DefaultMaterializedContainerSection)element), null, null, null, (List)rebuiltChildren, null, null, (int)55, null);
                boolean bl = false;
                ((Map)this$0.contentElementStorage).put(id, it);
                defaultMaterializedContainerSection = defaultMaterializedContainerSection2;
            } else {
                defaultMaterializedContainerSection = (DefaultMaterializedContainerSection)element;
            }
            contentElement = (ContentElement)defaultMaterializedContainerSection;
        } else if (contentElement3 instanceof MaterializedDocument) {
            MaterializedDocument materializedDocument;
            if (!((Collection)rebuiltChildren).isEmpty()) {
                MaterializedDocument materializedDocument2 = MaterializedDocument.copy$default((MaterializedDocument)((MaterializedDocument)element), null, null, null, null, (List)rebuiltChildren, null, (int)47, null);
                it = materializedDocument2;
                boolean bl = false;
                ((Map)this$0.contentElementStorage).put(id, it);
                materializedDocument = materializedDocument2;
            } else {
                materializedDocument = (MaterializedDocument)element;
            }
            contentElement = (ContentElement)materializedDocument;
        } else {
            contentElement = element;
        }
        return contentElement;
    }

    @JvmStatic
    @NotNull
    public static final LuceneSearchOperationsBuilder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final LuceneSearchOperationsBuilder withName(@NotNull String name) {
        return Companion.withName(name);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/rag/lucene/LuceneSearchOperations$Companion;", "", "<init>", "()V", "KEYWORDS_FIELD", "", "builder", "Lcom/embabel/agent/rag/lucene/LuceneSearchOperationsBuilder;", "withName", "name", "embabel-agent-rag-lucene"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LuceneSearchOperationsBuilder builder() {
            return new LuceneSearchOperationsBuilder(null, null, null, null, null, 31, null);
        }

        @JvmStatic
        @NotNull
        public final LuceneSearchOperationsBuilder withName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LuceneSearchOperationsBuilder(null, null, null, null, null, 31, null).withName(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResultExpander.Method.values().length];
            try {
                nArray[ResultExpander.Method.SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResultExpander.Method.ZOOM_OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

