/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.lucene;

import com.embabel.agent.rag.lucene.LuceneFields;
import com.embabel.agent.rag.lucene.VectorMath;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContainerSection;
import com.embabel.agent.rag.model.ContentElement;
import com.embabel.agent.rag.model.ContentRoot;
import com.embabel.agent.rag.model.DefaultMaterializedContainerSection;
import com.embabel.agent.rag.model.HierarchicalContentElement;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.MaterializedDocument;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.model.Section;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/rag/lucene/LuceneDocumentMapper;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "createChunkFromLuceneDocument", "Lcom/embabel/agent/rag/model/Chunk;", "luceneDocument", "Lorg/apache/lucene/document/Document;", "createLuceneDocument", "chunk", "embedding", "", "createContentElementFromLuceneDocument", "Lcom/embabel/agent/rag/model/ContentElement;", "elementType", "", "createStructuralElementDocument", "element", "embabel-agent-rag-lucene"})
@SourceDebugExtension(value={"SMAP\nLuceneDocumentMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneDocumentMapper.kt\ncom/embabel/agent/rag/lucene/LuceneDocumentMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,190:1\n774#2:191\n865#2,2:192\n1187#2,2:194\n1261#2,4:196\n808#2,11:200\n1863#2,2:211\n774#2:215\n865#2,2:216\n1187#2,2:218\n1261#2,4:220\n216#3,2:213\n216#3,2:225\n1#4:224\n27#5:227\n*S KotlinDebug\n*F\n+ 1 LuceneDocumentMapper.kt\ncom/embabel/agent/rag/lucene/LuceneDocumentMapper\n*L\n37#1:191\n37#1:192,2\n45#1:194,2\n45#1:196,4\n65#1:200,11\n74#1:211,2\n101#1:215\n101#1:216,2\n102#1:218,2\n102#1:220,4\n83#1:213,2\n182#1:225,2\n28#1:227\n*E\n"})
public final class LuceneDocumentMapper {
    @NotNull
    public static final LuceneDocumentMapper INSTANCE = new LuceneDocumentMapper();
    @NotNull
    private static final Logger logger;

    private LuceneDocumentMapper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Chunk createChunkFromLuceneDocument(@NotNull Document luceneDocument) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        String[] stringArray;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)luceneDocument, (String)"luceneDocument");
        Object object = luceneDocument.getValues("keywords");
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object keywords = object;
        List list = luceneDocument.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexableField field = (IndexableField)element$iv$iv;
            boolean bl = false;
            stringArray = new String[]{"id", "content", "embedding", "keywords"};
            boolean bl2 = !SetsKt.setOf((Object[])stringArray).contains(field.name());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            IndexableField field = (IndexableField)element$iv$iv;
            boolean bl = false;
            stringArray = TuplesKt.to((Object)field.name(), (Object)field.stringValue());
            map.put(stringArray.getFirst(), stringArray.getSecond());
        }
        Map metadata = MapsKt.toMutableMap((Map)destination$iv$iv2);
        if (!((Collection)keywords).isEmpty()) {
            metadata.put("keywords", (Object)keywords);
        }
        iterable = Chunk.Companion;
        String string = luceneDocument.get("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String string2 = string;
        String string3 = luceneDocument.get("content");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
        String string4 = string3;
        String string5 = luceneDocument.get("id");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"get(...)");
        String string6 = string5;
        return iterable.invoke(string2, string4, metadata, string6);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Document createLuceneDocument(@NotNull Chunk chunk, @Nullable float[] embedding) {
        Object element$iv;
        Document document;
        List list;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Object keywordsMeta = chunk.getMetadata().get("keywords");
        if (keywordsMeta instanceof Collection) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)keywordsMeta;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = keywordsMeta instanceof String ? CollectionsKt.listOf(keywordsMeta) : CollectionsKt.emptyList();
        }
        List keywords = list;
        Document $this$createLuceneDocument_u24lambda_u244 = document = new Document();
        boolean bl = false;
        $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new StringField("id", chunk.getId(), Field.Store.YES));
        $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new TextField("content", chunk.embeddableValue(), Field.Store.YES));
        Object $this$forEach$iv = keywords;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            String keyword = (String)element$iv;
            boolean bl2 = false;
            String string = keyword.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new TextField("keywords", string, Field.Store.YES));
        }
        if (embedding != null) {
            $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new KnnFloatVectorField("embedding", embedding, VectorSimilarityFunction.COSINE));
            $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new StoredField("embedding", VectorMath.INSTANCE.floatArrayToBytes(embedding)));
        }
        $this$forEach$iv = chunk.getMetadata();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl3 = false;
            String key = (String)object.getKey();
            Object value = object.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)"keywords")) continue;
            $this$createLuceneDocument_u24lambda_u244.add((IndexableField)new StringField(key, String.valueOf(value), Field.Store.YES));
        }
        return document;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final ContentElement createContentElementFromLuceneDocument(@NotNull Document luceneDocument, @Nullable String elementType) {
        Intrinsics.checkNotNullParameter((Object)luceneDocument, (String)"luceneDocument");
        v0 = luceneDocument.get("id");
        if (v0 == null) {
            return null;
        }
        id = v0;
        v1 = luceneDocument.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getFields(...)");
        var5_4 = v1;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            field = (IndexableField)element$iv$iv;
            $i$a$-filter-LuceneDocumentMapper$createContentElementFromLuceneDocument$metadata$1 = false;
            if (!(LuceneFields.INSTANCE.getRESERVED_FIELDS().contains(field.name()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateTo = false;
        for (E element$iv$iv : $this$associateTo$iv$iv) {
            var13_19 = destination$iv$iv;
            field = (IndexableField)element$iv$iv;
            $i$a$-associate-LuceneDocumentMapper$createContentElementFromLuceneDocument$metadata$2 = false;
            var14_20 = TuplesKt.to((Object)field.name(), (Object)field.stringValue());
            var13_19.put(var14_20.getFirst(), var14_20.getSecond());
        }
        metadata = destination$iv$iv;
        var5_4 = elementType;
        if (var5_4 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_4.hashCode()) {
            case -1382732988: {
                if (var5_4.equals("ContainerSection")) {
                    tmp = 1;
                }
                break;
            }
            case -13846137: {
                if (var5_4.equals("LeafSection")) {
                    tmp = 2;
                }
                break;
            }
            case 926364987: {
                if (var5_4.equals("Document")) {
                    tmp = 3;
                }
                break;
            }
            case 65090125: {
                if (var5_4.equals("Chunk")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                v2 = id;
                v3 = luceneDocument.get("uri");
                if (v3 == null) {
                    v3 = "";
                }
                if ((v4 = luceneDocument.get("title")) == null) {
                    v4 = "";
                }
                if ((v5 = luceneDocument.get("ingestionTimestamp")) == null) ** GOTO lbl85
                $i$f$associateTo = v5;
                var18_23 = v4;
                var17_24 = v3;
                var16_25 = v2;
                $i$a$-let-LuceneDocumentMapper$createContentElementFromLuceneDocument$1 = false;
                var19_26 = Instant.parse((CharSequence)it);
                v2 = var16_25;
                v3 = var17_24;
                v4 = var18_23;
                v6 = var19_26;
                v5 = v6;
                if (v6 != null) ** GOTO lbl86
lbl85:
                // 2 sources

                v5 = Instant.now();
lbl86:
                // 2 sources

                var6_6 = v5;
                Intrinsics.checkNotNull((Object)var6_6);
                var20_27 = metadata;
                var21_28 = CollectionsKt.emptyList();
                var22_29 = var6_6;
                var23_30 = v4;
                var24_31 = v3;
                var25_32 = v2;
                v7 = (ContentElement)new MaterializedDocument(var25_32, var24_31, var23_30, (Instant)var22_29, var21_28, var20_27);
                break;
            }
            case 2: {
                v8 = luceneDocument.get("title");
                if (v8 == null) {
                    v8 = "";
                }
                if ((v9 = luceneDocument.get("text")) == null) {
                    v9 = "";
                }
                v7 = (ContentElement)new LeafSection(id, null, v8, v9, luceneDocument.get("parentId"), metadata, 2, null);
                break;
            }
            case 1: {
                v10 = luceneDocument.get("title");
                if (v10 == null) {
                    v10 = "";
                }
                v7 = (ContentElement)new DefaultMaterializedContainerSection(id, null, v10, CollectionsKt.emptyList(), luceneDocument.get("parentId"), metadata, 2, null);
                break;
            }
            case 4: lbl-1000:
            // 2 sources

            {
                v7 = (ContentElement)this.createChunkFromLuceneDocument(luceneDocument);
                break;
            }
            default: {
                LuceneDocumentMapper.logger.warn("Unknown element type '{}' for id='{}', treating as Chunk", (Object)elementType, (Object)id);
                v7 = (ContentElement)this.createChunkFromLuceneDocument(luceneDocument);
            }
        }
        return v7;
    }

    @NotNull
    public final Document createStructuralElementDocument(@NotNull ContentElement element) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Document $this$createStructuralElementDocument_u24lambda_u2410 = document = new Document();
        boolean bl = false;
        $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StringField("id", element.getId(), Field.Store.YES));
        ContentElement contentElement = element;
        String elementType = contentElement instanceof NavigableDocument ? "Document" : (contentElement instanceof LeafSection ? "LeafSection" : (contentElement instanceof ContainerSection ? "ContainerSection" : element.getClass().getSimpleName()));
        $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StringField("_element_type", elementType, Field.Store.YES));
        if (element instanceof HierarchicalContentElement) {
            String string = ((HierarchicalContentElement)element).getParentId();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("parentId", it));
            }
        }
        if ((contentElement = element) instanceof Section) {
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("title", ((Section)element).getTitle()));
        } else if (contentElement instanceof ContentRoot) {
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("title", ((ContentRoot)element).getTitle()));
        }
        if (element instanceof ContentRoot) {
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("uri", ((ContentRoot)element).getUri()));
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("ingestionTimestamp", ((ContentRoot)element).getIngestionTimestamp().toString()));
        }
        if (element instanceof LeafSection) {
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StoredField("text", ((LeafSection)element).getText()));
        }
        Map $this$forEach$iv = element.getMetadata();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            $this$createStructuralElementDocument_u24lambda_u2410.add((IndexableField)new StringField(key, value.toString(), Field.Store.YES));
        }
        return document;
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(LuceneDocumentMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LuceneDocumentMapper.logger = logger;
    }
}

