/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.filter.PropertyFilter;
import com.embabel.agent.rag.filter.EntityFilter;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.FilteringVectorSearch;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.service.SimpleRetrievableResultsFormatter;
import com.embabel.agent.rag.service.VectorSearch;
import com.embabel.agent.rag.tools.CoreSearchToolsKt;
import com.embabel.agent.rag.tools.PostFilteringSearch;
import com.embabel.agent.rag.tools.ResultsEvent;
import com.embabel.agent.rag.tools.ResultsListener;
import com.embabel.agent.rag.tools.SearchTools;
import com.embabel.agent.rag.tools.TopKInflationStrategy;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import com.embabel.common.util.TimeKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BM\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\b\u0001\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0007J\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J4\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001a0\u0005\"\b\b\u0000\u0010\u001e*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/embabel/agent/rag/tools/VectorSearchTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "vectorSearch", "Lcom/embabel/agent/rag/service/VectorSearch;", "searchFor", "", "Ljava/lang/Class;", "Lcom/embabel/agent/rag/model/Retrievable;", "metadataFilter", "Lcom/embabel/agent/filter/PropertyFilter;", "entityFilter", "Lcom/embabel/agent/rag/filter/EntityFilter;", "resultsListener", "Lcom/embabel/agent/rag/tools/ResultsListener;", "<init>", "(Lcom/embabel/agent/rag/service/VectorSearch;Ljava/util/List;Lcom/embabel/agent/filter/PropertyFilter;Lcom/embabel/agent/rag/filter/EntityFilter;Lcom/embabel/agent/rag/tools/ResultsListener;)V", "logger", "Lorg/slf4j/Logger;", "", "query", "topK", "", "threshold", "", "Lcom/embabel/common/core/types/ZeroToOne;", "searchForAllTypes", "Lcom/embabel/common/core/types/SimilarityResult;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "searchWithFilter", "T", "clazz", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nCoreSearchTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreSearchTools.kt\ncom/embabel/agent/rag/tools/VectorSearchTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1557#2:320\n1628#2,3:321\n1368#2:324\n1454#2,5:325\n*S KotlinDebug\n*F\n+ 1 CoreSearchTools.kt\ncom/embabel/agent/rag/tools/VectorSearchTools\n*L\n56#1:320\n56#1:321,3\n67#1:324\n67#1:325,5\n*E\n"})
public final class VectorSearchTools
implements SearchTools {
    @NotNull
    private final VectorSearch vectorSearch;
    @NotNull
    private final List<Class<? extends Retrievable>> searchFor;
    @Nullable
    private final PropertyFilter metadataFilter;
    @Nullable
    private final EntityFilter entityFilter;
    @Nullable
    private final ResultsListener resultsListener;
    @NotNull
    private final Logger logger;

    @JvmOverloads
    public VectorSearchTools(@NotNull VectorSearch vectorSearch, @NotNull List<? extends Class<? extends Retrievable>> searchFor, @Nullable PropertyFilter metadataFilter, @Nullable EntityFilter entityFilter, @Nullable ResultsListener resultsListener) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        Intrinsics.checkNotNullParameter(searchFor, (String)"searchFor");
        this.vectorSearch = vectorSearch;
        this.searchFor = searchFor;
        this.metadataFilter = metadataFilter;
        this.entityFilter = entityFilter;
        this.resultsListener = resultsListener;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ VectorSearchTools(VectorSearch vectorSearch, List list, PropertyFilter propertyFilter, EntityFilter entityFilter, ResultsListener resultsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf(Chunk.class);
        }
        if ((n & 4) != 0) {
            propertyFilter = null;
        }
        if ((n & 8) != 0) {
            entityFilter = null;
        }
        if ((n & 0x10) != 0) {
            resultsListener = null;
        }
        this(vectorSearch, list, propertyFilter, entityFilter, resultsListener);
    }

    /*
     * WARNING - void declaration
     */
    @LlmTool(description="Perform vector search. Specify topK and similarity threshold from 0-1")
    @NotNull
    public final String vectorSearch(@NotNull String query, int topK, @LlmTool.Param(description="similarity threshold from 0-1") double threshold) {
        List results;
        block1: {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Object[] objectArray = new Object[6];
            objectArray[0] = query;
            objectArray[1] = topK;
            objectArray[2] = threshold;
            Iterable iterable = this.searchFor;
            int n = 3;
            Object[] objectArray2 = objectArray;
            String string = "Performing vector search with query='{}', topK={}, threshold={}, types={}, metadataFilter={}, entityFilter={}";
            Logger logger = this.logger;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Class clazz = (Class)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSimpleName());
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            objectArray[4] = this.metadataFilter;
            objectArray[5] = this.entityFilter;
            logger.info(string, objectArray);
            TextSimilaritySearchRequest request = TextSimilaritySearchRequest.Companion.invoke(query, threshold, topK);
            iterable = TimeKt.time(() -> VectorSearchTools.vectorSearch$lambda$1(this, request));
            results = (List)iterable.component1();
            long ms = ((Number)iterable.component2()).longValue();
            ResultsListener resultsListener = this.resultsListener;
            if (resultsListener == null) break block1;
            SearchTools searchTools = this;
            Duration duration = Duration.ofMillis(ms);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            resultsListener.onResultsEvent(new ResultsEvent(searchTools, query, results, duration, null, 16, null));
        }
        return SimpleRetrievableResultsFormatter.INSTANCE.formatResults(SimilarityResults.Companion.fromList(results));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SimilarityResult<? extends Retrievable>> searchForAllTypes(TextSimilaritySearchRequest request) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.searchFor;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Class clazz = (Class)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.searchWithFilter(request, clazz);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allResults = (List)destination$iv$iv;
        return CoreSearchToolsKt.deduplicateByIdKeepingHighestScore(allResults);
    }

    private final <T extends Retrievable> List<SimilarityResult<T>> searchWithFilter(TextSimilaritySearchRequest request, Class<T> clazz) {
        if (this.metadataFilter == null && this.entityFilter == null) {
            return this.vectorSearch.vectorSearch(request, clazz);
        }
        if (this.vectorSearch instanceof FilteringVectorSearch) {
            return ((FilteringVectorSearch)this.vectorSearch).vectorSearchWithFilter(request, clazz, this.metadataFilter, this.entityFilter);
        }
        List list = PostFilteringSearch.INSTANCE.search(request, this.metadataFilter, (PropertyFilter)this.entityFilter, TopKInflationStrategy.DEFAULT, arg_0 -> VectorSearchTools.searchWithFilter$lambda$3(this, clazz, arg_0));
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.embabel.common.core.types.SimilarityResult<T of com.embabel.agent.rag.tools.VectorSearchTools.searchWithFilter>>");
        return list;
    }

    @JvmOverloads
    public VectorSearchTools(@NotNull VectorSearch vectorSearch, @NotNull List<? extends Class<? extends Retrievable>> searchFor, @Nullable PropertyFilter metadataFilter, @Nullable EntityFilter entityFilter) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        Intrinsics.checkNotNullParameter(searchFor, (String)"searchFor");
        this(vectorSearch, searchFor, metadataFilter, entityFilter, null, 16, null);
    }

    @JvmOverloads
    public VectorSearchTools(@NotNull VectorSearch vectorSearch, @NotNull List<? extends Class<? extends Retrievable>> searchFor, @Nullable PropertyFilter metadataFilter) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        Intrinsics.checkNotNullParameter(searchFor, (String)"searchFor");
        this(vectorSearch, searchFor, metadataFilter, null, null, 24, null);
    }

    @JvmOverloads
    public VectorSearchTools(@NotNull VectorSearch vectorSearch, @NotNull List<? extends Class<? extends Retrievable>> searchFor) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        Intrinsics.checkNotNullParameter(searchFor, (String)"searchFor");
        this(vectorSearch, searchFor, null, null, null, 28, null);
    }

    @JvmOverloads
    public VectorSearchTools(@NotNull VectorSearch vectorSearch) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        this(vectorSearch, null, null, null, null, 30, null);
    }

    private static final List vectorSearch$lambda$1(VectorSearchTools this$0, TextSimilaritySearchRequest $request) {
        return this$0.searchForAllTypes($request);
    }

    private static final List searchWithFilter$lambda$3(VectorSearchTools this$0, Class $clazz, TextSimilaritySearchRequest inflatedRequest) {
        Intrinsics.checkNotNullParameter((Object)inflatedRequest, (String)"inflatedRequest");
        return this$0.vectorSearch.vectorSearch(inflatedRequest, $clazz);
    }
}

