/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.store;

import com.embabel.agent.filter.InMemoryPropertyFilter;
import com.embabel.agent.filter.PropertyFilter;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.ContentElement;
import com.embabel.agent.rag.model.Datum;
import com.embabel.agent.rag.model.HierarchicalContentElement;
import com.embabel.agent.rag.store.ContentElementRepositoryInfo;
import com.embabel.common.core.types.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH&J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0007\"\b\b\u0000\u0010\u0010*\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H&J,\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0010*\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH&J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u001a\u001a\u00020\u000bH&J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/rag/store/ContentElementRepository;", "Lcom/embabel/common/core/types/Named;", "provision", "", "info", "Lcom/embabel/agent/rag/store/ContentElementRepositoryInfo;", "findAllChunksById", "", "Lcom/embabel/agent/rag/model/Chunk;", "chunkIds", "", "", "findById", "Lcom/embabel/agent/rag/model/ContentElement;", "id", "findAll", "C", "clazz", "Ljava/lang/Class;", "count", "", "filter", "Lcom/embabel/agent/filter/PropertyFilter;", "save", "element", "findChunksForEntity", "entityId", "pathFromRoot", "Lcom/embabel/agent/rag/model/HierarchicalContentElement;", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nContentElementRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentElementRepository.kt\ncom/embabel/agent/rag/store/ContentElementRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1782#2,4:129\n*S KotlinDebug\n*F\n+ 1 ContentElementRepository.kt\ncom/embabel/agent/rag/store/ContentElementRepository\n*L\n83#1:129,4\n*E\n"})
public interface ContentElementRepository
extends Named {
    default public void provision() {
    }

    @NotNull
    public ContentElementRepositoryInfo info();

    @NotNull
    public Iterable<Chunk> findAllChunksById(@NotNull List<String> var1);

    @Nullable
    public ContentElement findById(@NotNull String var1);

    @NotNull
    public <C extends ContentElement> Iterable<C> findAll(@NotNull Class<C> var1);

    default public <C extends ContentElement> int count(@NotNull Class<C> clazz, @Nullable PropertyFilter filter) {
        int n;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable<C> $this$count$iv = this.findAll(clazz);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (C element$iv : $this$count$iv) {
                ContentElement element = (ContentElement)element$iv;
                boolean bl = false;
                if (!(filter == null || InMemoryPropertyFilter.INSTANCE.matches(filter, ((Datum)element).getMetadata())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public static /* synthetic */ int count$default(ContentElementRepository contentElementRepository, Class clazz, PropertyFilter propertyFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n & 2) != 0) {
            propertyFilter = null;
        }
        return contentElementRepository.count(clazz, propertyFilter);
    }

    @NotNull
    public ContentElement save(@NotNull ContentElement var1);

    @NotNull
    public List<Chunk> findChunksForEntity(@NotNull String var1);

    @Nullable
    default public List<String> pathFromRoot(@NotNull HierarchicalContentElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List path = new ArrayList();
        HierarchicalContentElement current = element;
        while (current != null) {
            path.add(0, current.getId());
            String parentId = current.getParentId();
            if (parentId == null) {
                return path;
            }
            ContentElement contentElement = this.findById(parentId);
            current = contentElement instanceof HierarchicalContentElement ? (HierarchicalContentElement)contentElement : null;
        }
        return null;
    }
}

