/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.support;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/embabel/agent/rag/service/support/VectorMath;", "", "<init>", "()V", "cosineSimilarity", "", "a", "", "b", "floatArrayToBytes", "", "floatArray", "bytesToFloatArray", "bytes", "embabel-agent-rag-core"})
public final class VectorMath {
    @NotNull
    public static final VectorMath INSTANCE = new VectorMath();

    private VectorMath() {
    }

    public final double cosineSimilarity(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.length != b.length) {
            return 0.0;
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            dotProduct += (double)(a[i] * b[i]);
            normA += (double)(a[i] * a[i]);
            normB += (double)(b[i] * b[i]);
        }
        return normA == 0.0 || normB == 0.0 ? 0.0 : dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }

    @NotNull
    public final byte[] floatArrayToBytes(@NotNull float[] floatArray) {
        Intrinsics.checkNotNullParameter((Object)floatArray, (String)"floatArray");
        byte[] bytes = new byte[floatArray.length * 4];
        int index = 0;
        for (float f : floatArray) {
            int bits = Float.floatToIntBits(f);
            bytes[index++] = (byte)(bits >> 24);
            bytes[index++] = (byte)(bits >> 16);
            bytes[index++] = (byte)(bits >> 8);
            bytes[index++] = (byte)bits;
        }
        return bytes;
    }

    @NotNull
    public final float[] bytesToFloatArray(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        float[] floats = new float[bytes.length / 4];
        int index = 0;
        int n = floats.length;
        for (int i = 0; i < n; ++i) {
            int bits = (bytes[index++] & 0xFF) << 24 | (bytes[index++] & 0xFF) << 16 | (bytes[index++] & 0xFF) << 8 | bytes[index++] & 0xFF;
            floats[i] = Float.intBitsToFloat(bits);
        }
        return floats;
    }
}

