/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.spring;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.util.StringTrimmingUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.ai.document.Document;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/rag/service/spring/DocumentSimilarityResult;", "Lcom/embabel/common/core/types/SimilarityResult;", "Lcom/embabel/agent/rag/model/Chunk;", "document", "Lorg/springframework/ai/document/Document;", "score", "", "Lcom/embabel/common/core/types/ZeroToOne;", "<init>", "(Lorg/springframework/ai/document/Document;D)V", "getScore", "()D", "match", "getMatch", "()Lcom/embabel/agent/rag/model/Chunk;", "toString", "", "embabel-agent-rag-core"})
public final class DocumentSimilarityResult
implements SimilarityResult<Chunk> {
    @NotNull
    private final Document document;
    private final double score;
    @NotNull
    private final Chunk match;

    public DocumentSimilarityResult(@NotNull Document document, double score) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.score = score;
        String string = this.document.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = this.document.getText();
        Intrinsics.checkNotNull((Object)string2);
        Map map = this.document.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getMetadata(...)");
        String string3 = this.document.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        this.match = Chunk.Companion.invoke(string, string2, map, string3);
    }

    public double getScore() {
        return this.score;
    }

    @NotNull
    public Chunk getMatch() {
        return this.match;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(id=" + this.document.getId() + ", score=" + this.getScore() + ", text=" + StringTrimmingUtilsKt.trim$default((String)this.document.getText(), (int)120, (int)5, null, (int)8, null) + ")";
    }
}

