/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.rag.service.FinderOperations;
import com.embabel.agent.rag.tools.SearchTools;
import com.embabel.common.core.types.HasInfoString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/embabel/agent/rag/tools/FinderTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "finderOperations", "Lcom/embabel/agent/rag/service/FinderOperations;", "<init>", "(Lcom/embabel/agent/rag/service/FinderOperations;)V", "logger", "Lorg/slf4j/Logger;", "findById", "", "id", "typeName", "embabel-agent-rag-core"})
public final class FinderTools
implements SearchTools {
    @NotNull
    private final FinderOperations finderOperations;
    @NotNull
    private final Logger logger;

    public FinderTools(@NotNull FinderOperations finderOperations) {
        Intrinsics.checkNotNullParameter((Object)finderOperations, (String)"finderOperations");
        this.finderOperations = finderOperations;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @LlmTool(description="Retrieve an item by its ID. Provide the type as a simple class name.")
    @NotNull
    public final String findById(@LlmTool.Param(description="The ID of the item to retrieve") @NotNull String id, @LlmTool.Param(description="The type name (usually simple class name) of the item") @NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.logger.info("Finding retrievable by id='{}', type='{}'", (Object)id, (Object)typeName);
        if (!this.finderOperations.supportsType(typeName)) {
            return "Type '" + typeName + "' is not supported by this store";
        }
        Object result = this.finderOperations.findById(id, typeName);
        return result != null ? "Found " + result.getClass().getSimpleName() + " with id '" + id + "': " + HasInfoString.infoString$default((HasInfoString)((HasInfoString)result), (Boolean)true, (int)0, (int)2, null) : "No item found with id '" + id + "' of type '" + typeName + "'";
    }
}

