/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.store;

import com.embabel.agent.rag.ingestion.ChunkTransformer;
import com.embabel.agent.rag.ingestion.ContentChunker;
import com.embabel.agent.rag.ingestion.InMemoryContentChunker;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.model.NavigableSection;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.store.ChunkingContentElementRepository;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.util.VisualizableTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J*\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH$J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H$J\b\u0010%\u001a\u00020\u0015H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/embabel/agent/rag/store/AbstractChunkingContentElementRepository;", "Lcom/embabel/agent/rag/store/ChunkingContentElementRepository;", "chunkerConfig", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "chunkTransformer", "Lcom/embabel/agent/rag/ingestion/ChunkTransformer;", "embeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "<init>", "(Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;Lcom/embabel/agent/rag/ingestion/ChunkTransformer;Lcom/embabel/common/ai/model/EmbeddingService;)V", "getChunkerConfig", "()Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "getChunkTransformer", "()Lcom/embabel/agent/rag/ingestion/ChunkTransformer;", "getEmbeddingService", "()Lcom/embabel/common/ai/model/EmbeddingService;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "onNewRetrievables", "", "retrievables", "", "Lcom/embabel/agent/rag/model/Retrievable;", "persistChunksWithEmbeddings", "chunks", "Lcom/embabel/agent/rag/model/Chunk;", "embeddings", "", "", "", "generateEmbeddingsInBatches", "writeAndChunkDocument", "root", "Lcom/embabel/agent/rag/model/NavigableDocument;", "createInternalRelationships", "commit", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nAbstractChunkingContentElementRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractChunkingContentElementRepository.kt\ncom/embabel/agent/rag/store/AbstractChunkingContentElementRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n808#2,11:258\n1872#2,2:269\n1557#2:271\n1628#2,3:272\n1863#2,2:275\n1874#2:277\n1557#2:278\n1628#2,3:279\n1863#2,2:282\n808#2,11:284\n1863#2,2:295\n1557#2:297\n1628#2,3:298\n*S KotlinDebug\n*F\n+ 1 AbstractChunkingContentElementRepository.kt\ncom/embabel/agent/rag/store/AbstractChunkingContentElementRepository\n*L\n86#1:258,11\n148#1:269,2\n150#1:271\n150#1:272,3\n153#1:275,2\n148#1:277\n186#1:278\n186#1:279,3\n193#1:282,2\n194#1:284,11\n195#1:295,2\n204#1:297\n204#1:298,3\n*E\n"})
public abstract class AbstractChunkingContentElementRepository
implements ChunkingContentElementRepository {
    @NotNull
    private final ContentChunker.Config chunkerConfig;
    @NotNull
    private final ChunkTransformer chunkTransformer;
    @Nullable
    private final EmbeddingService embeddingService;
    @NotNull
    private final Logger logger;

    public AbstractChunkingContentElementRepository(@NotNull ContentChunker.Config chunkerConfig, @NotNull ChunkTransformer chunkTransformer, @Nullable EmbeddingService embeddingService) {
        Intrinsics.checkNotNullParameter((Object)chunkerConfig, (String)"chunkerConfig");
        Intrinsics.checkNotNullParameter((Object)chunkTransformer, (String)"chunkTransformer");
        this.chunkerConfig = chunkerConfig;
        this.chunkTransformer = chunkTransformer;
        this.embeddingService = embeddingService;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        if (this.embeddingService == null) {
            this.logger.warn("No embedding service configured; only text search will be supported.");
        }
    }

    @NotNull
    protected final ContentChunker.Config getChunkerConfig() {
        return this.chunkerConfig;
    }

    @NotNull
    protected final ChunkTransformer getChunkTransformer() {
        return this.chunkTransformer;
    }

    @Nullable
    protected final EmbeddingService getEmbeddingService() {
        return this.embeddingService;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNewRetrievables(@NotNull List<? extends Retrievable> retrievables) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(retrievables, (String)"retrievables");
        Iterable $this$filterIsInstance$iv = retrievables;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Chunk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List chunks = (List)destination$iv$iv;
        if (chunks.isEmpty()) {
            this.logger.debug("No chunks to process in {} retrievables", (Object)retrievables.size());
            return;
        }
        Map<String, float[]> embeddings = this.generateEmbeddingsInBatches(chunks);
        this.persistChunksWithEmbeddings(chunks, embeddings);
    }

    protected abstract void persistChunksWithEmbeddings(@NotNull List<? extends Chunk> var1, @NotNull Map<String, float[]> var2);

    /*
     * WARNING - void declaration
     */
    private final Map<String, float[]> generateEmbeddingsInBatches(List<? extends Retrievable> retrievables) {
        if (this.embeddingService == null) {
            return MapsKt.emptyMap();
        }
        Map embeddings = new LinkedHashMap();
        List batches = CollectionsKt.chunked((Iterable)retrievables, (int)this.chunkerConfig.getEmbeddingBatchSize());
        int totalBatches = batches.size();
        AbstractChunkingContentElementRepository.generateEmbeddingsInBatches$logProgress(totalBatches, this, 0);
        Iterable $this$forEachIndexed$iv = batches;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void batch;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)batch;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Retrievable retrievable = (Retrievable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.embeddableValue());
                }
                List texts = (List)destination$iv$iv;
                List batchEmbeddings = this.embeddingService.embed(texts);
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((Iterable)batch), (Iterable)batchEmbeddings);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    Retrievable chunk = (Retrievable)pair.component1();
                    float[] embedding = (float[])pair.component2();
                    embeddings.put(chunk.getId(), embedding);
                }
                AbstractChunkingContentElementRepository.generateEmbeddingsInBatches$logProgress(totalBatches, this, index + 1);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{batch.size(), e.getMessage(), e};
                this.logger.warn("Failed to generate embeddings for batch of {} chunks: {}", objectArray);
            }
        }
        return embeddings;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final List<String> writeAndChunkDocument(@NotNull NavigableDocument root) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Chunk it;
        Object object;
        Object item$iv$iv;
        Iterator<NavigableSection> $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object[] objectArray = new Object[]{root.getId(), root.getUri(), root.getTitle(), this.chunkerConfig};
        this.logger.info("Writing and chunking document {} with uri {} and title '{}' using config {}", objectArray);
        InMemoryContentChunker chunker = ContentChunker.Companion.invoke(this.chunkerConfig, this.chunkTransformer);
        Iterable iterable = chunker.chunk(root);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            Chunk chunk = (Chunk)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((Chunk)this.enhance((Retrievable)it));
        }
        List chunks = (List)destination$iv$iv;
        this.logger.info("Chunked document {} into {} chunks", (Object)root.getId(), (Object)chunks.size());
        this.save(root);
        Iterable $this$forEach$iv = root.descendants();
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            NavigableSection element$iv;
            NavigableSection it2 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            this.save(it2);
        }
        $this$forEach$iv = root.descendants();
        object = this;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof Retrievable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((AbstractChunkingContentElementRepository)object).onNewRetrievables((List)destination$iv$iv);
        $this$forEach$iv = chunks;
        $i$f$forEach = false;
        for (NavigableSection element$iv : $this$forEach$iv) {
            Chunk it3 = (Chunk)((Object)element$iv);
            boolean bl2 = false;
            this.save(it3);
        }
        this.onNewRetrievables(chunks);
        this.createInternalRelationships(root);
        this.commit();
        this.logger.info("Wrote and chunked document {} with {} chunks", (Object)root.getId(), (Object)chunks.size());
        $this$map$iv = chunks;
        $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Chunk)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            object.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    protected abstract void createInternalRelationships(@NotNull NavigableDocument var1);

    protected abstract void commit();

    private static final void generateEmbeddingsInBatches$logProgress(int totalBatches, AbstractChunkingContentElementRepository this$0, int current) {
        VisualizableTask progress = VisualizableTask.Companion.invoke("Generating embeddings", current, totalBatches);
        this$0.logger.info(VisualizableTask.createProgressBar$default((VisualizableTask)progress, (int)0, (int)1, null));
    }
}

