/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion.policy;

import com.embabel.agent.rag.ingestion.ContentRefreshPolicy;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.store.ChunkingContentElementRepository;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy;", "Lcom/embabel/agent/rag/ingestion/ContentRefreshPolicy;", "shouldRefreshUri", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "shouldReread", "repository", "Lcom/embabel/agent/rag/store/ChunkingContentElementRepository;", "rootUri", "shouldRefreshDocument", "root", "Lcom/embabel/agent/rag/model/NavigableDocument;", "Companion", "embabel-agent-rag-core"})
public final class UrlSpecificContentRefreshPolicy
implements ContentRefreshPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Boolean> shouldRefreshUri;
    private final Logger logger;

    public UrlSpecificContentRefreshPolicy(@NotNull Function1<? super String, Boolean> shouldRefreshUri) {
        Intrinsics.checkNotNullParameter(shouldRefreshUri, (String)"shouldRefreshUri");
        this.shouldRefreshUri = shouldRefreshUri;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public boolean shouldReread(@NotNull ChunkingContentElementRepository repository, @NotNull String rootUri) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)rootUri, (String)"rootUri");
        boolean shouldReread = !repository.existsRootWithUri(rootUri) || (Boolean)this.shouldRefreshUri.invoke((Object)rootUri) != false;
        Object[] objectArray = new Object[]{rootUri, repository.existsRootWithUri(rootUri), this.shouldRefreshUri.invoke((Object)rootUri), shouldReread};
        this.logger.info("Checking whether to reread content at uri={} : existsInRepository={}, shouldRefreshUri={} => shouldReread={}", objectArray);
        return shouldReread;
    }

    @Override
    public boolean shouldRefreshDocument(@NotNull ChunkingContentElementRepository repository, @NotNull NavigableDocument root) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return true;
    }

    @JvmStatic
    @NotNull
    public static final UrlSpecificContentRefreshPolicy matchingPattern(@NotNull Regex pattern) {
        return Companion.matchingPattern(pattern);
    }

    @JvmStatic
    @NotNull
    public static final UrlSpecificContentRefreshPolicy containingAny(String ... substrings) {
        return Companion.containingAny(substrings);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J!\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy$Companion;", "", "<init>", "()V", "matchingPattern", "Lcom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy;", "pattern", "Lkotlin/text/Regex;", "containingAny", "substrings", "", "", "([Ljava/lang/String;)Lcom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy;", "embabel-agent-rag-core"})
    @SourceDebugExtension(value={"SMAP\nUrlSpecificContentRefreshPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlSpecificContentRefreshPolicy.kt\ncom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n12567#2,2:72\n*S KotlinDebug\n*F\n+ 1 UrlSpecificContentRefreshPolicy.kt\ncom/embabel/agent/rag/ingestion/policy/UrlSpecificContentRefreshPolicy$Companion\n*L\n68#1:72,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlSpecificContentRefreshPolicy matchingPattern(@NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new UrlSpecificContentRefreshPolicy((Function1<? super String, Boolean>)((Function1)arg_0 -> Companion.matchingPattern$lambda$0(pattern, arg_0)));
        }

        @JvmStatic
        @NotNull
        public final UrlSpecificContentRefreshPolicy containingAny(String ... substrings) {
            Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
            return new UrlSpecificContentRefreshPolicy((Function1<? super String, Boolean>)((Function1)arg_0 -> Companion.containingAny$lambda$2(substrings, arg_0)));
        }

        private static final boolean matchingPattern$lambda$0(Regex $pattern, String uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return $pattern.containsMatchIn((CharSequence)uri);
        }

        private static final boolean containingAny$lambda$2(String[] $substrings, String uri) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                String[] $this$any$iv = $substrings;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)uri, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

