/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.rag.service.TypeRetrievalOperations;
import com.embabel.agent.rag.tools.SearchTools;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/embabel/agent/rag/tools/TypeRetrievalTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "typeRetrievalOperations", "Lcom/embabel/agent/rag/service/TypeRetrievalOperations;", "<init>", "(Lcom/embabel/agent/rag/service/TypeRetrievalOperations;)V", "logger", "Lorg/slf4j/Logger;", "isTypeSupported", "", "typeName", "embabel-agent-rag-core"})
public final class TypeRetrievalTools
implements SearchTools {
    @NotNull
    private final TypeRetrievalOperations typeRetrievalOperations;
    @NotNull
    private final Logger logger;

    public TypeRetrievalTools(@NotNull TypeRetrievalOperations typeRetrievalOperations) {
        Intrinsics.checkNotNullParameter((Object)typeRetrievalOperations, (String)"typeRetrievalOperations");
        this.typeRetrievalOperations = typeRetrievalOperations;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @LlmTool(description="Check if a type is supported for retrieval. Provide the simple class name.")
    @NotNull
    public final String isTypeSupported(@LlmTool.Param(description="The type (usually simple class) name to check") @NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.logger.info("Checking if type '{}' is supported", (Object)typeName);
        return this.typeRetrievalOperations.supportsType(typeName) ? "Type '" + typeName + "' is supported" : "Type '" + typeName + "' is not supported by this store";
    }
}

