/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.support;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.RegexSearchOperations;
import com.embabel.agent.rag.service.TextSearch;
import com.embabel.agent.tools.file.FileReadTools;
import com.embabel.agent.tools.file.FileTools;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.SimpleSimilaritySearchResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00018B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J4\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001c0\u001b\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016J<\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001c0\u001b\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0013H\u0002J4\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001b2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u00101\u001a\u000202H\u0002J,\u00103\u001a\b\u0012\u0004\u0012\u00020-0\u001b2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00042\f\u00104\u001a\b\u0012\u0004\u0012\u00020'0\u001bH\u0002J4\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'060\u001b2\u0018\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'060\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Lcom/embabel/agent/rag/service/support/DirectoryTextSearch;", "Lcom/embabel/agent/rag/service/TextSearch;", "Lcom/embabel/agent/rag/service/RegexSearchOperations;", "directory", "", "config", "Lcom/embabel/agent/rag/service/support/DirectoryTextSearch$Config;", "<init>", "(Ljava/lang/String;Lcom/embabel/agent/rag/service/support/DirectoryTextSearch$Config;)V", "supportsType", "", "type", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "fileReadTools", "Lcom/embabel/agent/tools/file/FileReadTools;", "rootPath", "Ljava/nio/file/Path;", "Ljava/nio/file/Path;", "globMatcher", "Ljava/nio/file/PathMatcher;", "luceneSyntaxNotes", "getLuceneSyntaxNotes", "()Ljava/lang/String;", "textSearch", "", "Lcom/embabel/common/core/types/SimilarityResult;", "T", "Lcom/embabel/agent/rag/model/Retrievable;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "clazz", "Ljava/lang/Class;", "regexSearch", "regex", "Lkotlin/text/Regex;", "topK", "", "findMatchingFiles", "Lkotlin/sequences/Sequence;", "relativePath", "path", "extractChunksAroundMatches", "Lcom/embabel/agent/rag/model/Chunk;", "filePath", "content", "queryTerms", "score", "", "extractChunksAroundPositions", "positions", "mergeOverlappingRanges", "Lkotlin/Pair;", "ranges", "Config", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nDirectoryTextSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryTextSearch.kt\ncom/embabel/agent/rag/service/support/DirectoryTextSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,354:1\n774#2:355\n865#2,2:356\n1782#2,4:359\n1863#2,2:363\n1062#2:366\n1863#2,2:368\n1368#2:371\n1454#2,5:372\n1557#2:377\n1628#2,3:378\n1567#2:381\n1598#2,4:382\n1053#2:386\n1317#3:358\n1318#3:365\n1317#3:367\n1318#3:370\n*S KotlinDebug\n*F\n+ 1 DirectoryTextSearch.kt\ncom/embabel/agent/rag/service/support/DirectoryTextSearch\n*L\n117#1:355\n117#1:356,2\n131#1:359,4\n144#1:363,2\n153#1:366\n190#1:368,2\n258#1:371\n258#1:372,5\n304#1:377\n304#1:378,3\n314#1:381\n314#1:382,4\n335#1:386\n125#1:358\n125#1:365\n177#1:367\n177#1:370\n*E\n"})
public final class DirectoryTextSearch
implements TextSearch,
RegexSearchOperations {
    @NotNull
    private final String directory;
    @NotNull
    private final Config config;
    private final Logger logger;
    @NotNull
    private final FileReadTools fileReadTools;
    private final Path rootPath;
    @Nullable
    private final PathMatcher globMatcher;
    @NotNull
    private final String luceneSyntaxNotes;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public DirectoryTextSearch(@NotNull String directory, @NotNull Config config) {
        PathMatcher pathMatcher;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.directory = directory;
        this.config = config;
        this.logger = LoggerFactory.getLogger(DirectoryTextSearch.class);
        this.fileReadTools = FileTools.Companion.readOnly$default((FileTools.Companion)FileTools.Companion, (String)this.directory, null, (int)2, null);
        this.rootPath = Path.of(this.directory, new String[0]).toAbsolutePath().normalize();
        DirectoryTextSearch directoryTextSearch = this;
        String string = this.config.getFileGlob();
        if (string != null) {
            void it;
            String string2 = string;
            DirectoryTextSearch directoryTextSearch2 = directoryTextSearch;
            boolean bl = false;
            pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)it);
            directoryTextSearch = directoryTextSearch2;
        } else {
            pathMatcher = null;
        }
        directoryTextSearch.globMatcher = pathMatcher;
        this.luceneSyntaxNotes = "Not supported";
    }

    public /* synthetic */ DirectoryTextSearch(String string, Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            config = new Config(null, null, 0, 0, 15, null);
        }
        this(string, config);
    }

    @Override
    public boolean supportsType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)Chunk.class.getSimpleName());
    }

    @Override
    @NotNull
    public String getLuceneSyntaxNotes() {
        return this.luceneSyntaxNotes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> textSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        void $this$sortedByDescending$iv;
        List list;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (!Chunk.class.isAssignableFrom(clazz)) {
            this.logger.warn("DirectoryTextSearch only supports Chunk type, got {}", (Object)clazz.getSimpleName());
            return CollectionsKt.emptyList();
        }
        String string = request.getQuery().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String query = string;
        Object object = query;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List queryTerms = (List)destination$iv$iv;
        if (queryTerms.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List results = new ArrayList();
        Object $this$forEach$iv = this.findMatchingFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path filePath = (Path)element$iv;
            boolean bl = false;
            try {
                double score;
                int matchCount;
                int n2;
                String content;
                if (this.fileReadTools.safeReadFile(this.relativePath(filePath)) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)content.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                Iterable $this$count$iv = queryTerms;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv2 : $this$count$iv) {
                        String contentLower;
                        String term = (String)element$iv2;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)contentLower, (CharSequence)term, (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                if ((matchCount = n2) == 0 || (score = (double)matchCount / (double)queryTerms.size()) < request.getSimilarityThreshold()) continue;
                List<Chunk> chunks = this.extractChunksAroundMatches(filePath, content, queryTerms, score);
                Iterable $this$forEach$iv2 = chunks;
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    Chunk chunk = (Chunk)element$iv3;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)chunk, (String)"null cannot be cast to non-null type T of com.embabel.agent.rag.service.support.DirectoryTextSearch.textSearch");
                    results.add(new SimpleSimilaritySearchResult((Object)chunk, score));
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to read file {}: {}", (Object)filePath, (Object)e.getMessage());
            }
        }
        $this$forEach$iv = results;
        boolean $i$f$sortedByDescending = false;
        List it = list = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SimilarityResult it = (SimilarityResult)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (SimilarityResult)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)request.getTopK());
        boolean bl = false;
        Object[] objectArray = new Object[]{request.getQuery(), this.directory, it.size()};
        this.logger.info("Text search for '{}' in {} found {} results", objectArray);
        return list;
    }

    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> regexSearch(@NotNull Regex regex, int topK, @NotNull Class<T> clazz) {
        List list;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (!Chunk.class.isAssignableFrom(clazz)) {
            this.logger.warn("DirectoryTextSearch only supports Chunk type, got {}", (Object)clazz.getSimpleName());
            return CollectionsKt.emptyList();
        }
        List results = new ArrayList();
        Sequence<Path> $this$forEach$iv = this.findMatchingFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path filePath = (Path)element$iv;
            boolean bl = false;
            try {
                String content;
                List matchPositions;
                if (this.fileReadTools.safeReadFile(this.relativePath(filePath)) == null || (matchPositions = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)content, (int)0, (int)2, null), DirectoryTextSearch::regexSearch$lambda$9$lambda$7))).isEmpty()) continue;
                List<Chunk> chunks = this.extractChunksAroundPositions(filePath, content, matchPositions);
                Iterable $this$forEach$iv2 = chunks;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Chunk chunk = (Chunk)element$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)chunk, (String)"null cannot be cast to non-null type T of com.embabel.agent.rag.service.support.DirectoryTextSearch.regexSearch");
                    results.add(new SimpleSimilaritySearchResult((Object)chunk, 1.0));
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to read file {}: {}", (Object)filePath, (Object)e.getMessage());
            }
        }
        List it = list = CollectionsKt.take((Iterable)results, (int)topK);
        boolean bl = false;
        Object[] objectArray = new Object[]{regex.getPattern(), this.directory, it.size()};
        this.logger.info("Regex search for '{}' in {} found {} results", objectArray);
        return list;
    }

    private final Sequence<Path> findMatchingFiles() {
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            this.logger.warn("Directory does not exist: {}", (Object)this.directory);
            return SequencesKt.emptySequence();
        }
        Iterator iterator = Files.walk(this.rootPath, new FileVisitOption[0]).filter(arg_0 -> DirectoryTextSearch.findMatchingFiles$lambda$12(DirectoryTextSearch::findMatchingFiles$lambda$11, arg_0)).filter(arg_0 -> DirectoryTextSearch.findMatchingFiles$lambda$14(arg_0 -> DirectoryTextSearch.findMatchingFiles$lambda$13(this, arg_0), arg_0)).filter(arg_0 -> DirectoryTextSearch.findMatchingFiles$lambda$16(arg_0 -> DirectoryTextSearch.findMatchingFiles$lambda$15(this, arg_0), arg_0)).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return SequencesKt.asSequence(iterator);
    }

    private final String relativePath(Path path) {
        Path path2 = this.rootPath.relativize(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
        return PathsKt.getInvariantSeparatorsPathString((Path)path2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> extractChunksAroundMatches(Path filePath, String content, List<String> queryTerms, double score) {
        void $this$flatMapTo$iv$iv;
        String string = content.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String contentLower = string;
        Iterable $this$flatMap$iv = queryTerms;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String termLower;
            int pos;
            String term = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)term.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            int index = 0;
            List positions = new ArrayList();
            while ((pos = StringsKt.indexOf$default((CharSequence)contentLower, (String)termLower, (int)index, (boolean)false, (int)4, null)) >= 0) {
                positions.add(pos);
                index = pos + 1;
            }
            Iterable list$iv$iv = positions;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List matchPositions = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        return this.extractChunksAroundPositions(filePath, content, matchPositions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Chunk> extractChunksAroundPositions(Path filePath, String content, List<Integer> positions) {
        void $this$mapIndexedTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        String relativePath = this.relativePath(filePath);
        Object object = new Pair[]{TuplesKt.to((Object)"file_path", (Object)PathsKt.getInvariantSeparatorsPathString((Path)filePath)), TuplesKt.to((Object)"relative_path", (Object)relativePath), TuplesKt.to((Object)"file_name", (Object)PathsKt.getName((Path)filePath)), TuplesKt.to((Object)"source", (Object)("directory:" + this.directory))};
        Map baseMetadata = MapsKt.mapOf((Pair[])object);
        if (this.config.getChunkSize() <= 0 || content.length() <= this.config.getChunkSize()) {
            object = Chunk.Companion;
            String string = this.directory;
            Map map = MapsKt.plus((Map)MapsKt.plus((Map)baseMetadata, (Pair)TuplesKt.to((Object)"chunk_index", (Object)0)), (Pair)TuplesKt.to((Object)"total_chunks", (Object)1));
            return CollectionsKt.listOf((Object)((Chunk.Companion)object).invoke(relativePath, content, map, string));
        }
        int halfChunk = this.config.getChunkSize() / 2;
        Iterable $this$map$iv = positions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pos;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            int start = Math.max(0, (int)(pos - halfChunk));
            int end = Math.min(content.length(), (int)(pos + halfChunk));
            collection.add(TuplesKt.to((Object)start, (Object)end));
        }
        List ranges = (List)destination$iv$iv;
        List<Pair<Integer, Integer>> mergedRanges = this.mergeOverlappingRanges(ranges);
        Iterable $this$mapIndexed$iv = mergedRanges;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            int start = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            Chunk.Companion companion = Chunk.Companion;
            String string2 = mergedRanges.size() == 1 ? relativePath : relativePath + "#" + (int)index;
            Intrinsics.checkNotNullExpressionValue((Object)content.substring(start, end), (String)"substring(...)");
            String string3 = mergedRanges.size() == 1 ? this.directory : relativePath;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"chunk_index", (Object)((int)index)), TuplesKt.to((Object)"chunk_start", (Object)start), TuplesKt.to((Object)"chunk_end", (Object)end), TuplesKt.to((Object)"total_chunks", (Object)mergedRanges.size())};
            Map map = MapsKt.plus((Map)baseMetadata, (Map)MapsKt.mapOf((Pair[])pairArray));
            collection.add(companion.invoke(string2, string, map, string3));
        }
        return (List)destination$iv$iv2;
    }

    private final List<Pair<Integer, Integer>> mergeOverlappingRanges(List<Pair<Integer, Integer>> ranges) {
        if (ranges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        List merged = new ArrayList();
        Pair current = (Pair)CollectionsKt.first((List)sorted);
        int n = sorted.size();
        for (int i = 1; i < n; ++i) {
            Pair next = (Pair)sorted.get(i);
            if (((Number)next.getFirst()).intValue() <= ((Number)current.getSecond()).intValue() + this.config.getChunkOverlap()) {
                current = TuplesKt.to((Object)current.getFirst(), (Object)Math.max(((Number)current.getSecond()).intValue(), ((Number)next.getSecond()).intValue()));
                continue;
            }
            merged.add(current);
            current = next;
        }
        merged.add(current);
        return merged;
    }

    @JvmOverloads
    public DirectoryTextSearch(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(directory, null, 2, null);
    }

    private static final int regexSearch$lambda$9$lambda$7(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getFirst();
    }

    private static final boolean findMatchingFiles$lambda$11(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean findMatchingFiles$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findMatchingFiles$lambda$13(DirectoryTextSearch this$0, Path path) {
        for (Path current = path.getParent(); current != null && current.startsWith(this$0.rootPath); current = current.getParent()) {
            Path path2 = current.getFileName();
            if (!CollectionsKt.contains((Iterable)this$0.config.getExcludeDirectories(), (Object)(path2 != null ? ((Object)path2).toString() : null))) continue;
            return false;
        }
        return true;
    }

    private static final boolean findMatchingFiles$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findMatchingFiles$lambda$15(DirectoryTextSearch this$0, Path path) {
        boolean bl;
        if (this$0.globMatcher != null) {
            Path relativePath = this$0.rootPath.relativize(path);
            bl = this$0.globMatcher.matches(relativePath);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean findMatchingFiles$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B9\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J9\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/embabel/agent/rag/service/support/DirectoryTextSearch$Config;", "", "fileGlob", "", "excludeDirectories", "", "chunkSize", "", "chunkOverlap", "<init>", "(Ljava/lang/String;Ljava/util/Set;II)V", "getFileGlob", "()Ljava/lang/String;", "getExcludeDirectories", "()Ljava/util/Set;", "getChunkSize", "()I", "getChunkOverlap", "withFileGlob", "withExcludeDirectories", "withChunkSize", "withChunkOverlap", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "embabel-agent-rag-core"})
    public static final class Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String fileGlob;
        @NotNull
        private final Set<String> excludeDirectories;
        private final int chunkSize;
        private final int chunkOverlap;
        @JvmField
        @NotNull
        public static final Set<String> DEFAULT_EXCLUDE_DIRECTORIES;
        public static final int DEFAULT_CHUNK_SIZE = 1000;
        public static final int DEFAULT_CHUNK_OVERLAP = 200;

        @JvmOverloads
        public Config(@Nullable String fileGlob, @NotNull Set<String> excludeDirectories, int chunkSize, int chunkOverlap) {
            Intrinsics.checkNotNullParameter(excludeDirectories, (String)"excludeDirectories");
            this.fileGlob = fileGlob;
            this.excludeDirectories = excludeDirectories;
            this.chunkSize = chunkSize;
            this.chunkOverlap = chunkOverlap;
        }

        public /* synthetic */ Config(String string, Set set, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                string = null;
            }
            if ((n3 & 2) != 0) {
                set = DEFAULT_EXCLUDE_DIRECTORIES;
            }
            if ((n3 & 4) != 0) {
                n = 1000;
            }
            if ((n3 & 8) != 0) {
                n2 = 200;
            }
            this(string, set, n, n2);
        }

        @Nullable
        public final String getFileGlob() {
            return this.fileGlob;
        }

        @NotNull
        public final Set<String> getExcludeDirectories() {
            return this.excludeDirectories;
        }

        public final int getChunkSize() {
            return this.chunkSize;
        }

        public final int getChunkOverlap() {
            return this.chunkOverlap;
        }

        @NotNull
        public final Config withFileGlob(@NotNull String fileGlob) {
            Intrinsics.checkNotNullParameter((Object)fileGlob, (String)"fileGlob");
            return Config.copy$default(this, fileGlob, null, 0, 0, 14, null);
        }

        @NotNull
        public final Config withExcludeDirectories(@NotNull Set<String> excludeDirectories) {
            Intrinsics.checkNotNullParameter(excludeDirectories, (String)"excludeDirectories");
            return Config.copy$default(this, null, excludeDirectories, 0, 0, 13, null);
        }

        @NotNull
        public final Config withChunkSize(int chunkSize) {
            return Config.copy$default(this, null, null, chunkSize, 0, 11, null);
        }

        @NotNull
        public final Config withChunkOverlap(int chunkOverlap) {
            return Config.copy$default(this, null, null, 0, chunkOverlap, 7, null);
        }

        @Nullable
        public final String component1() {
            return this.fileGlob;
        }

        @NotNull
        public final Set<String> component2() {
            return this.excludeDirectories;
        }

        public final int component3() {
            return this.chunkSize;
        }

        public final int component4() {
            return this.chunkOverlap;
        }

        @NotNull
        public final Config copy(@Nullable String fileGlob, @NotNull Set<String> excludeDirectories, int chunkSize, int chunkOverlap) {
            Intrinsics.checkNotNullParameter(excludeDirectories, (String)"excludeDirectories");
            return new Config(fileGlob, excludeDirectories, chunkSize, chunkOverlap);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, Set set, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = config.fileGlob;
            }
            if ((n3 & 2) != 0) {
                set = config.excludeDirectories;
            }
            if ((n3 & 4) != 0) {
                n = config.chunkSize;
            }
            if ((n3 & 8) != 0) {
                n2 = config.chunkOverlap;
            }
            return config.copy(string, set, n, n2);
        }

        @NotNull
        public String toString() {
            return "Config(fileGlob=" + this.fileGlob + ", excludeDirectories=" + this.excludeDirectories + ", chunkSize=" + this.chunkSize + ", chunkOverlap=" + this.chunkOverlap + ")";
        }

        public int hashCode() {
            int result = this.fileGlob == null ? 0 : this.fileGlob.hashCode();
            result = result * 31 + ((Object)this.excludeDirectories).hashCode();
            result = result * 31 + Integer.hashCode(this.chunkSize);
            result = result * 31 + Integer.hashCode(this.chunkOverlap);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.fileGlob, (Object)config.fileGlob)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.excludeDirectories, config.excludeDirectories)) {
                return false;
            }
            if (this.chunkSize != config.chunkSize) {
                return false;
            }
            return this.chunkOverlap == config.chunkOverlap;
        }

        @JvmOverloads
        public Config(@Nullable String fileGlob, @NotNull Set<String> excludeDirectories, int chunkSize) {
            Intrinsics.checkNotNullParameter(excludeDirectories, (String)"excludeDirectories");
            this(fileGlob, excludeDirectories, chunkSize, 0, 8, null);
        }

        @JvmOverloads
        public Config(@Nullable String fileGlob, @NotNull Set<String> excludeDirectories) {
            Intrinsics.checkNotNullParameter(excludeDirectories, (String)"excludeDirectories");
            this(fileGlob, excludeDirectories, 0, 0, 12, null);
        }

        @JvmOverloads
        public Config(@Nullable String fileGlob) {
            this(fileGlob, null, 0, 0, 14, null);
        }

        @JvmOverloads
        public Config() {
            this(null, null, 0, 0, 15, null);
        }

        static {
            Object[] objectArray = new String[]{".git", "node_modules", "build", "target"};
            DEFAULT_EXCLUDE_DIRECTORIES = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/embabel/agent/rag/service/support/DirectoryTextSearch$Config$Companion;", "", "<init>", "()V", "DEFAULT_EXCLUDE_DIRECTORIES", "", "", "DEFAULT_CHUNK_SIZE", "", "DEFAULT_CHUNK_OVERLAP", "embabel-agent-rag-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

