/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.service.spring;

import com.embabel.agent.rag.filter.InMemoryPropertyFilter;
import com.embabel.agent.rag.filter.PropertyFilter;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.service.FilteringVectorSearch;
import com.embabel.agent.rag.service.spring.DocumentSimilarityResult;
import com.embabel.agent.rag.service.spring.SpringVectorStoreVectorSearchKt;
import com.embabel.common.core.types.SimilarityResult;
import com.embabel.common.core.types.TextSimilaritySearchRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.filter.Filter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J4\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0012H\u0016JH\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J0\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/rag/service/spring/SpringVectorStoreVectorSearch;", "Lcom/embabel/agent/rag/service/FilteringVectorSearch;", "vectorStore", "Lorg/springframework/ai/vectorstore/VectorStore;", "<init>", "(Lorg/springframework/ai/vectorstore/VectorStore;)V", "supportsType", "", "type", "", "vectorSearch", "", "Lcom/embabel/common/core/types/SimilarityResult;", "T", "Lcom/embabel/agent/rag/model/Retrievable;", "request", "Lcom/embabel/common/core/types/TextSimilaritySearchRequest;", "clazz", "Ljava/lang/Class;", "vectorSearchWithFilter", "metadataFilter", "Lcom/embabel/agent/rag/filter/PropertyFilter;", "propertyFilter", "executeSearch", "filterExpression", "Lorg/springframework/ai/vectorstore/filter/Filter$Expression;", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nSpringVectorStoreVectorSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringVectorStoreVectorSearch.kt\ncom/embabel/agent/rag/service/spring/SpringVectorStoreVectorSearch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n1557#3:177\n1628#3,3:178\n*S KotlinDebug\n*F\n+ 1 SpringVectorStoreVectorSearch.kt\ncom/embabel/agent/rag/service/spring/SpringVectorStoreVectorSearch\n*L\n78#1:177\n78#1:178,3\n*E\n"})
public final class SpringVectorStoreVectorSearch
implements FilteringVectorSearch {
    @NotNull
    private final VectorStore vectorStore;

    public SpringVectorStoreVectorSearch(@NotNull VectorStore vectorStore) {
        Intrinsics.checkNotNullParameter((Object)vectorStore, (String)"vectorStore");
        this.vectorStore = vectorStore;
    }

    @Override
    public boolean supportsType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return StringsKt.equals((String)type, (String)"Chunk", (boolean)true);
    }

    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> vectorSearch(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.executeSearch(request, null);
    }

    @Override
    @NotNull
    public <T extends Retrievable> List<SimilarityResult<T>> vectorSearchWithFilter(@NotNull TextSimilaritySearchRequest request, @NotNull Class<T> clazz, @Nullable PropertyFilter metadataFilter, @Nullable PropertyFilter propertyFilter) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        PropertyFilter propertyFilter2 = metadataFilter;
        List<SimilarityResult<T>> results = this.executeSearch(request, (Filter.Expression)(propertyFilter2 != null ? SpringVectorStoreVectorSearchKt.toSpringAiExpression(propertyFilter2) : null));
        return propertyFilter != null ? InMemoryPropertyFilter.INSTANCE.filterByProperties(results, propertyFilter) : results;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Retrievable> List<SimilarityResult<T>> executeSearch(TextSimilaritySearchRequest request, Filter.Expression filterExpression) {
        void $this$mapTo$iv$iv;
        SearchRequest.Builder builder = SearchRequest.builder().query(request.getQuery()).similarityThreshold(request.getSimilarityThreshold()).topK(request.getTopK());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"topK(...)");
        SearchRequest.Builder searchRequestBuilder = builder;
        Filter.Expression expression = filterExpression;
        if (expression != null) {
            Filter.Expression it = expression;
            boolean bl = false;
            searchRequestBuilder.filterExpression(it);
        }
        List list = this.vectorStore.similaritySearch(searchRequestBuilder.build());
        Intrinsics.checkNotNull((Object)list);
        List results = list;
        Iterable $this$map$iv = results;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getScore();
            Intrinsics.checkNotNull((Object)d);
            collection.add(new DocumentSimilarityResult((Document)it, d));
        }
        return (List)destination$iv$iv;
    }
}

