/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.tools;

import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.service.SimilarityResults;
import com.embabel.agent.rag.service.SimpleRetrievableResultsFormatter;
import com.embabel.agent.rag.service.VectorSearch;
import com.embabel.agent.rag.tools.ResultsEvent;
import com.embabel.agent.rag.tools.ResultsListener;
import com.embabel.agent.rag.tools.SearchTools;
import com.embabel.agent.rag.tools.SimpleSearchRequest;
import com.embabel.common.core.types.SimilarityResult;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0002\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\b\u0001\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/rag/tools/VectorSearchTools;", "Lcom/embabel/agent/rag/tools/SearchTools;", "vectorSearch", "Lcom/embabel/agent/rag/service/VectorSearch;", "resultsListener", "Lcom/embabel/agent/rag/tools/ResultsListener;", "<init>", "(Lcom/embabel/agent/rag/service/VectorSearch;Lcom/embabel/agent/rag/tools/ResultsListener;)V", "logger", "Lorg/slf4j/Logger;", "", "query", "topK", "", "threshold", "", "Lcom/embabel/common/core/types/ZeroToOne;", "embabel-agent-rag-core"})
public final class VectorSearchTools
implements SearchTools {
    @NotNull
    private final VectorSearch vectorSearch;
    @Nullable
    private final ResultsListener resultsListener;
    @NotNull
    private final Logger logger;

    public VectorSearchTools(@NotNull VectorSearch vectorSearch, @Nullable ResultsListener resultsListener) {
        Intrinsics.checkNotNullParameter((Object)vectorSearch, (String)"vectorSearch");
        this.vectorSearch = vectorSearch;
        this.resultsListener = resultsListener;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ VectorSearchTools(VectorSearch vectorSearch, ResultsListener resultsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resultsListener = null;
        }
        this(vectorSearch, resultsListener);
    }

    @Tool(description="Perform vector search. Specify topK and similarity threshold from 0-1")
    @NotNull
    public final String vectorSearch(@NotNull String query, int topK, @ToolParam(description="similarity threshold from 0-1") double threshold) {
        List<SimilarityResult<Chunk>> results;
        block0: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Object[] objectArray = new Object[]{query, topK, threshold};
            this.logger.info("Performing vector search with query='{}', topK={}, threshold={}", objectArray);
            Instant start = Instant.now();
            results = this.vectorSearch.vectorSearch(new SimpleSearchRequest(query, threshold, topK), Chunk.class);
            Duration runningTime = Duration.between(start, Instant.now());
            ResultsListener resultsListener = this.resultsListener;
            if (resultsListener == null) break block0;
            SearchTools searchTools = this;
            Intrinsics.checkNotNull((Object)runningTime);
            resultsListener.onResultsEvent(new ResultsEvent(searchTools, query, results, runningTime, null, 16, null));
        }
        return SimpleRetrievableResultsFormatter.INSTANCE.formatResults(SimilarityResults.Companion.fromList(results));
    }
}

