/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.store;

import com.embabel.agent.rag.ingestion.ContentChunker;
import com.embabel.agent.rag.ingestion.InMemoryContentChunker;
import com.embabel.agent.rag.model.Chunk;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.model.NavigableSection;
import com.embabel.agent.rag.model.Retrievable;
import com.embabel.agent.rag.store.ChunkingContentElementRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH$J\b\u0010\u0011\u001a\u00020\u0010H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/rag/store/AbstractChunkingContentElementRepository;", "Lcom/embabel/agent/rag/store/ChunkingContentElementRepository;", "chunkerConfig", "Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;", "<init>", "(Lcom/embabel/agent/rag/ingestion/ContentChunker$Config;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "writeAndChunkDocument", "", "", "root", "Lcom/embabel/agent/rag/model/NavigableDocument;", "createInternalRelationships", "", "commit", "embabel-agent-rag-core"})
@SourceDebugExtension(value={"SMAP\nAbstractChunkingContentElementRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractChunkingContentElementRepository.kt\ncom/embabel/agent/rag/store/AbstractChunkingContentElementRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1557#2:84\n1628#2,3:85\n1863#2,2:88\n808#2,11:90\n1863#2,2:101\n1557#2:103\n1628#2,3:104\n*S KotlinDebug\n*F\n+ 1 AbstractChunkingContentElementRepository.kt\ncom/embabel/agent/rag/store/AbstractChunkingContentElementRepository\n*L\n48#1:84\n48#1:85,3\n55#1:88,2\n56#1:90,11\n57#1:101,2\n66#1:103\n66#1:104,3\n*E\n"})
public abstract class AbstractChunkingContentElementRepository
implements ChunkingContentElementRepository {
    @NotNull
    private final ContentChunker.Config chunkerConfig;
    @NotNull
    private final Logger logger;

    public AbstractChunkingContentElementRepository(@NotNull ContentChunker.Config chunkerConfig) {
        Intrinsics.checkNotNullParameter((Object)chunkerConfig, (String)"chunkerConfig");
        this.chunkerConfig = chunkerConfig;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final List<String> writeAndChunkDocument(@NotNull NavigableDocument root) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Chunk it;
        Object object;
        Object item$iv$iv;
        Iterator<NavigableSection> $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object[] objectArray = new Object[]{root.getId(), root.getUri(), root.getTitle(), this.chunkerConfig};
        this.logger.info("Writing and chunking document {} with uri {} and title '{}' using config {}", objectArray);
        InMemoryContentChunker chunker = ContentChunker.Companion.invoke(this.chunkerConfig);
        Iterable iterable = chunker.chunk(root);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            Chunk chunk = (Chunk)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((Chunk)this.enhance((Retrievable)it));
        }
        List chunks = (List)destination$iv$iv;
        this.logger.info("Chunked document {} into {} chunks", (Object)root.getId(), (Object)chunks.size());
        this.save(root);
        Iterable $this$forEach$iv = root.descendants();
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            NavigableSection element$iv;
            NavigableSection it2 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            this.save(it2);
        }
        $this$forEach$iv = root.descendants();
        object = this;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof Retrievable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object.onNewRetrievables((List)destination$iv$iv);
        $this$forEach$iv = chunks;
        $i$f$forEach = false;
        for (NavigableSection element$iv : $this$forEach$iv) {
            Chunk it3 = (Chunk)((Object)element$iv);
            boolean bl2 = false;
            this.save(it3);
        }
        this.onNewRetrievables(chunks);
        this.createInternalRelationships(root);
        this.commit();
        this.logger.info("Wrote and chunked document {} with {} chunks", (Object)root.getId(), (Object)chunks.size());
        $this$map$iv = chunks;
        $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Chunk)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            object.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    protected abstract void createInternalRelationships(@NotNull NavigableDocument var1);

    protected abstract void commit();
}

