/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ContentRefreshPolicy;
import com.embabel.agent.rag.model.ContentRoot;
import com.embabel.agent.rag.model.NavigableDocument;
import com.embabel.agent.rag.store.ChunkingContentElementRepository;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/rag/ingestion/TtlContentRefreshPolicy;", "Lcom/embabel/agent/rag/ingestion/ContentRefreshPolicy;", "ttl", "Ljava/time/Duration;", "<init>", "(Ljava/time/Duration;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "shouldReread", "", "repository", "Lcom/embabel/agent/rag/store/ChunkingContentElementRepository;", "rootUri", "", "shouldRefreshDocument", "root", "Lcom/embabel/agent/rag/model/NavigableDocument;", "Companion", "embabel-agent-rag-core"})
public final class TtlContentRefreshPolicy
implements ContentRefreshPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration ttl;
    private final Logger logger;

    public TtlContentRefreshPolicy(@NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        this.ttl = ttl;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldReread(@NotNull ChunkingContentElementRepository repository, @NotNull String rootUri) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)rootUri, (String)"rootUri");
        ContentRoot existing = repository.findContentRootByUri(rootUri);
        if (existing == null) return true;
        TtlContentRefreshPolicy $this$shouldReread_u24lambda_u240 = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{rootUri, existing.getIngestionTimestamp(), $this$shouldReread_u24lambda_u240.ttl};
        $this$shouldReread_u24lambda_u240.logger.info("Checking whether to reread existing content at uri={} with ingestionTimestamp={} and ttl={}", objectArray);
        if (Duration.between(existing.getIngestionTimestamp(), Instant.now()).compareTo($this$shouldReread_u24lambda_u240.ttl) <= 0) return false;
        return true;
    }

    @Override
    public boolean shouldRefreshDocument(@NotNull ChunkingContentElementRepository repository, @NotNull NavigableDocument root) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return true;
    }

    @JvmStatic
    @NotNull
    public static final ContentRefreshPolicy of(@NotNull Duration ttl) {
        return Companion.of(ttl);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/embabel/agent/rag/ingestion/TtlContentRefreshPolicy$Companion;", "", "<init>", "()V", "of", "Lcom/embabel/agent/rag/ingestion/ContentRefreshPolicy;", "ttl", "Ljava/time/Duration;", "embabel-agent-rag-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContentRefreshPolicy of(@NotNull Duration ttl) {
            Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
            return new TtlContentRefreshPolicy(ttl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

