/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.platform;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.annotation.spring.ClientMcpAsyncHandlersRegistry;
import org.springframework.ai.mcp.annotation.spring.ClientMcpSyncHandlersRegistry;
import org.springframework.ai.mcp.client.common.autoconfigure.McpClientAutoConfiguration;
import org.springframework.ai.mcp.client.common.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.common.autoconfigure.configurer.McpAsyncClientConfigurer;
import org.springframework.ai.mcp.client.common.autoconfigure.configurer.McpSyncClientConfigurer;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(afterName={"org.springframework.ai.mcp.client.common.autoconfigure.StdioTransportAutoConfiguration", "org.springframework.ai.mcp.client.httpclient.autoconfigure.SseHttpClientTransportAutoConfiguration", "org.springframework.ai.mcp.client.httpclient.autoconfigure.StreamableHttpHttpClientTransportAutoConfiguration", "org.springframework.ai.mcp.client.webflux.autoconfigure.SseWebFluxTransportAutoConfiguration", "org.springframework.ai.mcp.client.webflux.autoconfigure.StreamableHttpWebFluxTransportAutoConfiguration"})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class QuiteMcpClientAutoConfiguration
extends McpClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(QuiteMcpClientAutoConfiguration.class);

    private String connectedClientName(String clientName, String serverConnectionName) {
        return clientName + " - " + serverConnectionName;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpSyncClient> mcpSyncClients(McpSyncClientConfigurer mcpSyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider, ObjectProvider<ClientMcpSyncHandlersRegistry> clientMcpSyncHandlersRegistry) {
        ArrayList<McpSyncClient> mcpSyncClients = new ArrayList<McpSyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(this.connectedClientName(commonProperties.getName(), namedTransport.name()), namedTransport.name(), commonProperties.getVersion());
                McpClient.SyncSpec spec = McpClient.sync((McpClientTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout());
                clientMcpSyncHandlersRegistry.ifAvailable(registry -> spec.sampling(samplingRequest -> registry.handleSampling(namedTransport.name(), samplingRequest)).elicitation(elicitationRequest -> registry.handleElicitation(namedTransport.name(), elicitationRequest)).loggingConsumer(loggingMessageNotification -> registry.handleLogging(namedTransport.name(), loggingMessageNotification)).progressConsumer(progressNotification -> registry.handleProgress(namedTransport.name(), progressNotification)).toolsChangeConsumer(newTools -> registry.handleToolListChanged(namedTransport.name(), newTools)).promptsChangeConsumer(newPrompts -> registry.handlePromptListChanged(namedTransport.name(), newPrompts)).resourcesChangeConsumer(newResources -> registry.handleResourceListChanged(namedTransport.name(), newResources)).capabilities(registry.getCapabilities(namedTransport.name())));
                McpClient.SyncSpec customizedSpec = mcpSyncClientConfigurer.configure(namedTransport.name(), spec);
                McpSyncClient client = customizedSpec.build();
                if (commonProperties.isInitialized()) {
                    try {
                        client.initialize();
                        mcpSyncClients.add(client);
                    }
                    catch (Throwable t) {
                        logger.error("Failed to initialize MCP Sync Client: {} - Application startup will continue", (Object)clientInfo.name(), (Object)t);
                    }
                    continue;
                }
                mcpSyncClients.add(client);
            }
        }
        return mcpSyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<McpAsyncClient> mcpAsyncClients(McpAsyncClientConfigurer mcpAsyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider, ObjectProvider<ClientMcpAsyncHandlersRegistry> clientMcpAsyncHandlersRegistry) {
        ArrayList<McpAsyncClient> mcpAsyncClients = new ArrayList<McpAsyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(this.connectedClientName(commonProperties.getName(), namedTransport.name()), commonProperties.getVersion());
                McpClient.AsyncSpec spec = McpClient.async((McpClientTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout());
                clientMcpAsyncHandlersRegistry.ifAvailable(registry -> spec.sampling(samplingRequest -> registry.handleSampling(namedTransport.name(), samplingRequest)).elicitation(elicitationRequest -> registry.handleElicitation(namedTransport.name(), elicitationRequest)).loggingConsumer(loggingMessageNotification -> registry.handleLogging(namedTransport.name(), loggingMessageNotification)).progressConsumer(progressNotification -> registry.handleProgress(namedTransport.name(), progressNotification)).toolsChangeConsumer(newTools -> registry.handleToolListChanged(namedTransport.name(), newTools)).promptsChangeConsumer(newPrompts -> registry.handlePromptListChanged(namedTransport.name(), newPrompts)).resourcesChangeConsumer(newResources -> registry.handleResourceListChanged(namedTransport.name(), newResources)).capabilities(registry.getCapabilities(namedTransport.name())));
                McpClient.AsyncSpec customizedSpec = mcpAsyncClientConfigurer.configure(namedTransport.name(), spec);
                McpAsyncClient client = customizedSpec.build();
                if (commonProperties.isInitialized()) {
                    try {
                        client.initialize().block();
                        mcpAsyncClients.add(client);
                    }
                    catch (Throwable t) {
                        logger.error("Failed to initialize MCP Async Client: {} - Application startup will continue", (Object)clientInfo.name(), (Object)t);
                    }
                    continue;
                }
                mcpAsyncClients.add(client);
            }
        }
        return mcpAsyncClients;
    }
}

