/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.annotation.spi;

import com.embabel.agent.config.annotation.EnableAgents;
import com.embabel.common.util.WinUtils;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EnvironmentPostProcessor
implements org.springframework.boot.env.EnvironmentPostProcessor,
Ordered {
    public static final String LOGGING_THEME_PROPERTY = "embabel.agent.logging.personality";
    private final Logger logger = LoggerFactory.getLogger(EnvironmentPostProcessor.class);
    private static final String SPRING_PROFILES_ACTIVE = "spring.profiles.active";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String loggingTheme = this.findLoggingTheme(application);
        if (loggingTheme != null && !loggingTheme.isEmpty()) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("loggingThemeSource", Collections.singletonMap(LOGGING_THEME_PROPERTY, loggingTheme)));
            this.logger.info("Found loggingTheme '{}' - adding property: {}", (Object)LOGGING_THEME_PROPERTY, (Object)loggingTheme);
        }
    }

    private String findLoggingTheme(SpringApplication application) {
        EnableAgents enableAgents = this.findEnableAgentsAnnotation(application);
        return enableAgents != null ? enableAgents.loggingTheme() : "";
    }

    private EnableAgents findEnableAgentsAnnotation(SpringApplication application) {
        for (Object source : application.getAllSources()) {
            Class clazz;
            EnableAgents enableAgents;
            if (!(source instanceof Class) || (enableAgents = (EnableAgents)AnnotationUtils.findAnnotation((Class)(clazz = (Class)source), EnableAgents.class)) == null) continue;
            return enableAgents;
        }
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static {
        if (WinUtils.IS_OS_WINDOWS()) {
            WinUtils.CHCP_TO_UTF8();
            WinUtils.SETUP_OPTIMAL_CONSOLE();
        }
    }
}

