/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.annotation.spi;

import com.embabel.agent.config.annotation.AgentPlatform;
import com.embabel.agent.config.annotation.EnableAgents;
import com.embabel.common.util.WinUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.ConfigurableEnvironment;

public class EnvironmentPostProcessor
implements org.springframework.boot.env.EnvironmentPostProcessor,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(EnvironmentPostProcessor.class);
    private static final String SPRING_PROFILES_ACTIVE = "spring.profiles.active";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Object[] mcpServerProfiles;
        Object[] localModelsProfiles;
        String themeProfile;
        LinkedHashSet<String> allProfiles = new LinkedHashSet<String>();
        Object[] agentProfiles = this.findPlatformProfiles(application);
        if (agentProfiles.length > 0) {
            allProfiles.addAll(Arrays.asList(agentProfiles));
            this.logger.debug("Found platform profiles: {}", (Object)Arrays.toString(agentProfiles));
        }
        if ((themeProfile = this.findLoggingTheme(application)) != null && !themeProfile.isEmpty()) {
            allProfiles.add(themeProfile);
            this.logger.info("Found loggingTheme '{}' - adding profile: {}", (Object)themeProfile, (Object)themeProfile);
        }
        if (ArrayUtils.isNotEmpty((Object[])(localModelsProfiles = this.findLocalModels(application)))) {
            allProfiles.addAll(Arrays.asList(localModelsProfiles));
            this.logger.info("Found localModels - adding profiles: {}", (Object)Arrays.toString(localModelsProfiles));
        }
        if (ArrayUtils.isNotEmpty((Object[])(mcpServerProfiles = this.findMcpServers(application)))) {
            allProfiles.addAll(Arrays.asList(mcpServerProfiles));
            this.logger.info("Found mcpServers - adding profiles: {}", (Object)Arrays.toString(mcpServerProfiles));
        }
        if (!allProfiles.isEmpty()) {
            this.activateProfiles(environment, allProfiles);
        }
    }

    private String[] findPlatformProfiles(SpringApplication application) {
        LinkedHashSet allPlatformProfiles = new LinkedHashSet();
        for (Object source : application.getAllSources()) {
            if (!(source instanceof Class)) continue;
            Class clazz = (Class)source;
            MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)clazz);
            annotations.stream(AgentPlatform.class).forEach(mergedAnnotation -> {
                String[] values = mergedAnnotation.getStringArray("value");
                allPlatformProfiles.addAll(Arrays.asList(values));
            });
        }
        this.logger.debug("Collected all platform profiles: {}", allPlatformProfiles);
        return allPlatformProfiles.toArray(new String[0]);
    }

    private String findLoggingTheme(SpringApplication application) {
        EnableAgents enableAgents = this.findEnableAgentsAnnotation(application);
        return enableAgents != null ? enableAgents.loggingTheme() : "";
    }

    private String[] findLocalModels(SpringApplication application) {
        EnableAgents enableAgents = this.findEnableAgentsAnnotation(application);
        return enableAgents != null ? enableAgents.localModels() : new String[]{};
    }

    private String[] findMcpServers(SpringApplication application) {
        EnableAgents enableAgents = this.findEnableAgentsAnnotation(application);
        return enableAgents != null ? enableAgents.mcpServers() : new String[]{};
    }

    private EnableAgents findEnableAgentsAnnotation(SpringApplication application) {
        for (Object source : application.getAllSources()) {
            Class clazz;
            EnableAgents enableAgents;
            if (!(source instanceof Class) || (enableAgents = (EnableAgents)AnnotationUtils.findAnnotation((Class)(clazz = (Class)source), EnableAgents.class)) == null) continue;
            return enableAgents;
        }
        return null;
    }

    private void activateProfiles(ConfigurableEnvironment environment, Set<String> profiles) {
        String existingProfiles = System.getProperty(SPRING_PROFILES_ACTIVE);
        if (existingProfiles != null && !existingProfiles.isEmpty()) {
            LinkedHashSet<String> mergedProfiles = new LinkedHashSet<String>();
            mergedProfiles.addAll(Arrays.asList(existingProfiles.split(",")));
            mergedProfiles.addAll(profiles);
            mergedProfiles.forEach(arg_0 -> ((ConfigurableEnvironment)environment).addActiveProfile(arg_0));
        } else {
            profiles.forEach(arg_0 -> ((ConfigurableEnvironment)environment).addActiveProfile(arg_0));
        }
        this.logger.info("Activated Spring profiles: {}", (Object[])environment.getActiveProfiles());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static {
        if (WinUtils.IS_OS_WINDOWS()) {
            WinUtils.CHCP_TO_UTF8();
            WinUtils.SETUP_OPTIMAL_CONSOLE();
        }
    }
}

