/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.openai;

import com.embabel.agent.api.models.OpenAiModels;
import com.embabel.agent.openai.OpenAiChatOptionsConverter;
import com.embabel.agent.spi.LlmService;
import com.embabel.agent.spi.support.springai.SpringAiLlmService;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.ai.model.SpringAiEmbeddingService;
import com.embabel.common.util.ObjectProviders;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B_\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0017H\u0002JF\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\"2\f\b\u0002\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "", "baseUrl", "", "apiKey", "completionsPath", "embeddingsPath", "httpHeaders", "", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "requestFactory", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/http/client/ClientHttpRequestFactory;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lio/micrometer/observation/ObservationRegistry;Lorg/springframework/beans/factory/ObjectProvider;)V", "getBaseUrl", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "openAiApi", "Lorg/springframework/ai/openai/api/OpenAiApi;", "getOpenAiApi", "()Lorg/springframework/ai/openai/api/OpenAiApi;", "createOpenAiApi", "openAiCompatibleLlm", "Lcom/embabel/agent/spi/LlmService;", "model", "pricingModel", "Lcom/embabel/common/ai/model/PricingModel;", "provider", "knowledgeCutoffDate", "Ljava/time/LocalDate;", "optionsConverter", "Lcom/embabel/common/ai/model/OptionsConverter;", "retryTemplate", "Lorg/springframework/retry/support/RetryTemplate;", "openAiCompatibleEmbeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "chatModelOf", "Lorg/springframework/ai/chat/model/ChatModel;", "Companion", "embabel-agent-openai"})
@SourceDebugExtension(value={"SMAP\nOpenAiCompatibleModelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiCompatibleModelFactory.kt\ncom/embabel/agent/openai/OpenAiCompatibleModelFactory\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,194:1\n27#2:195\n27#2:196\n27#2:197\n*S KotlinDebug\n*F\n+ 1 OpenAiCompatibleModelFactory.kt\ncom/embabel/agent/openai/OpenAiCompatibleModelFactory\n*L\n84#1:195\n88#1:196\n92#1:197\n*E\n"})
public class OpenAiCompatibleModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String baseUrl;
    @Nullable
    private final String apiKey;
    @Nullable
    private final String completionsPath;
    @Nullable
    private final String embeddingsPath;
    @NotNull
    private final Map<String, String> httpHeaders;
    @NotNull
    private final ObservationRegistry observationRegistry;
    @NotNull
    private final ObjectProvider<ClientHttpRequestFactory> requestFactory;
    @NotNull
    private final Logger logger;
    @NotNull
    private final OpenAiApi openAiApi;
    private static final int CONNECT_TIMEOUT_MS = 5000;
    private static final int READ_TIMEOUT_MS = 600000;

    public OpenAiCompatibleModelFactory(@Nullable String baseUrl, @Nullable String apiKey, @Nullable String completionsPath, @Nullable String embeddingsPath, @NotNull Map<String, String> httpHeaders, @NotNull ObservationRegistry observationRegistry, @NotNull ObjectProvider<ClientHttpRequestFactory> requestFactory) {
        Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
        Intrinsics.checkNotNullParameter((Object)observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.completionsPath = completionsPath;
        this.embeddingsPath = embeddingsPath;
        this.httpHeaders = httpHeaders;
        this.observationRegistry = observationRegistry;
        this.requestFactory = requestFactory;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        String string = this.baseUrl;
        if (string == null) {
            string = "default OpenAI location";
        }
        this.logger.info("Open AI compatible models are available at {}. API key is {}", (Object)string, (Object)(this.apiKey == null ? "not set" : "set"));
        this.openAiApi = this.createOpenAiApi();
    }

    public /* synthetic */ OpenAiCompatibleModelFactory(String string, String string2, String string3, String string4, Map map, ObservationRegistry observationRegistry, ObjectProvider objectProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            observationRegistry = ObservationRegistry.NOOP;
        }
        if ((n & 0x40) != 0) {
            objectProvider = ObjectProviders.INSTANCE.empty();
        }
        this(string, string2, string3, string4, map, observationRegistry, (ObjectProvider<ClientHttpRequestFactory>)objectProvider);
    }

    @Nullable
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    private final OpenAiApi createOpenAiApi() {
        boolean $i$f$loggerFor;
        OpenAiApi.Builder builder = OpenAiApi.builder().apiKey(this.apiKey != null ? (ApiKey)new SimpleApiKey(this.apiKey) : (ApiKey)new NoopApiKey());
        if (this.baseUrl != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI base URL: {}", (Object)this.baseUrl);
            builder.baseUrl(this.baseUrl);
        }
        if (this.completionsPath != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI completions path: {}", (Object)this.completionsPath);
            builder.completionsPath(this.completionsPath);
        }
        if (this.embeddingsPath != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI embeddings path: {}", (Object)this.embeddingsPath);
            builder.embeddingsPath(this.embeddingsPath);
        }
        builder.restClientBuilder(RestClient.builder().requestFactory((ClientHttpRequestFactory)this.requestFactory.getIfAvailable(OpenAiCompatibleModelFactory::createOpenAiApi$lambda$1)).observationRegistry(this.observationRegistry));
        builder.webClientBuilder(WebClient.builder().observationRegistry(this.observationRegistry));
        OpenAiApi openAiApi = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)openAiApi, (String)"build(...)");
        return openAiApi;
    }

    @JvmOverloads
    @NotNull
    public final LlmService<?> openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate, @NotNull OptionsConverter<?> optionsConverter, @NotNull RetryTemplate retryTemplate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(optionsConverter, (String)"optionsConverter");
        Intrinsics.checkNotNullParameter((Object)retryTemplate, (String)"retryTemplate");
        ChatModel chatModel = this.chatModelOf(model, retryTemplate);
        return (LlmService)new SpringAiLlmService(model, provider, chatModel, optionsConverter, knowledgeCutoffDate, null, pricingModel, 32, null);
    }

    public static /* synthetic */ LlmService openAiCompatibleLlm$default(OpenAiCompatibleModelFactory openAiCompatibleModelFactory, String string, PricingModel pricingModel, String string2, LocalDate localDate, OptionsConverter optionsConverter, RetryTemplate retryTemplate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openAiCompatibleLlm");
        }
        if ((n & 0x10) != 0) {
            optionsConverter = OpenAiChatOptionsConverter.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        }
        return openAiCompatibleModelFactory.openAiCompatibleLlm(string, pricingModel, string2, localDate, optionsConverter, retryTemplate);
    }

    @NotNull
    public final EmbeddingService openAiCompatibleEmbeddingService(@NotNull String model, @NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        OpenAiEmbeddingModel embeddingModel = new OpenAiEmbeddingModel(this.openAiApi, MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().model(model).build());
        return (EmbeddingService)new SpringAiEmbeddingService(model, provider, (EmbeddingModel)embeddingModel);
    }

    @NotNull
    protected final ChatModel chatModelOf(@NotNull String model, @NotNull RetryTemplate retryTemplate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)retryTemplate, (String)"retryTemplate");
        OpenAiChatModel openAiChatModel = OpenAiChatModel.builder().defaultOptions(OpenAiChatOptions.builder().model(model).httpHeaders(this.httpHeaders).build()).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry(this.observationRegistry).build()).openAiApi(this.openAiApi).retryTemplate(retryTemplate).observationRegistry(this.observationRegistry).build();
        Intrinsics.checkNotNullExpressionValue((Object)openAiChatModel, (String)"build(...)");
        return (ChatModel)openAiChatModel;
    }

    @JvmOverloads
    @NotNull
    public final LlmService<?> openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate, @NotNull OptionsConverter<?> optionsConverter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(optionsConverter, (String)"optionsConverter");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default(this, model, pricingModel, provider, knowledgeCutoffDate, optionsConverter, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final LlmService<?> openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default(this, model, pricingModel, provider, knowledgeCutoffDate, null, null, 48, null);
    }

    private static final ClientHttpRequestFactory createOpenAiApi$lambda$1() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory;
        SimpleClientHttpRequestFactory $this$createOpenAiApi_u24lambda_u241_u24lambda_u240 = simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        boolean bl = false;
        $this$createOpenAiApi_u24lambda_u241_u24lambda_u240.setConnectTimeout(5000);
        $this$createOpenAiApi_u24lambda_u241_u24lambda_u240.setReadTimeout(600000);
        return (ClientHttpRequestFactory)simpleClientHttpRequestFactory;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory$Companion;", "", "<init>", "()V", "CONNECT_TIMEOUT_MS", "", "READ_TIMEOUT_MS", "embabel-agent-openai"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

