/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.openai;

import com.embabel.agent.api.models.OpenAiModels;
import com.embabel.agent.openai.OpenAiChatOptionsConverter;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PricingModel;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0012H\u0002JB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\b\u0002\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\b\b\u0002\u0010 \u001a\u00020!H\u0007J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "", "baseUrl", "", "apiKey", "completionsPath", "embeddingsPath", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/micrometer/observation/ObservationRegistry;)V", "getBaseUrl", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "openAiApi", "Lorg/springframework/ai/openai/api/OpenAiApi;", "getOpenAiApi", "()Lorg/springframework/ai/openai/api/OpenAiApi;", "createOpenAiApi", "openAiCompatibleLlm", "Lcom/embabel/common/ai/model/Llm;", "model", "pricingModel", "Lcom/embabel/common/ai/model/PricingModel;", "provider", "knowledgeCutoffDate", "Ljava/time/LocalDate;", "optionsConverter", "Lcom/embabel/common/ai/model/OptionsConverter;", "retryTemplate", "Lorg/springframework/retry/support/RetryTemplate;", "openAiCompatibleEmbeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "chatModelOf", "Lorg/springframework/ai/chat/model/ChatModel;", "embabel-agent-openai"})
@SourceDebugExtension(value={"SMAP\nOpenAiCompatibleModelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiCompatibleModelFactory.kt\ncom/embabel/agent/openai/OpenAiCompatibleModelFactory\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,174:1\n27#2:175\n27#2:176\n27#2:177\n*S KotlinDebug\n*F\n+ 1 OpenAiCompatibleModelFactory.kt\ncom/embabel/agent/openai/OpenAiCompatibleModelFactory\n*L\n72#1:175\n76#1:176\n80#1:177\n*E\n"})
public class OpenAiCompatibleModelFactory {
    @Nullable
    private final String baseUrl;
    @Nullable
    private final String apiKey;
    @Nullable
    private final String completionsPath;
    @Nullable
    private final String embeddingsPath;
    @NotNull
    private final ObservationRegistry observationRegistry;
    @NotNull
    private final Logger logger;
    @NotNull
    private final OpenAiApi openAiApi;

    public OpenAiCompatibleModelFactory(@Nullable String baseUrl, @Nullable String apiKey, @Nullable String completionsPath, @Nullable String embeddingsPath, @NotNull ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)observationRegistry, (String)"observationRegistry");
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.completionsPath = completionsPath;
        this.embeddingsPath = embeddingsPath;
        this.observationRegistry = observationRegistry;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        String string = this.baseUrl;
        if (string == null) {
            string = "default OpenAI location";
        }
        this.logger.info("Open AI compatible models are available at {}. API key is {}", (Object)string, (Object)(this.apiKey == null ? "not set" : "set"));
        this.openAiApi = this.createOpenAiApi();
    }

    @Nullable
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    private final OpenAiApi createOpenAiApi() {
        boolean $i$f$loggerFor;
        OpenAiApi.Builder builder = OpenAiApi.builder().apiKey(this.apiKey != null ? (ApiKey)new SimpleApiKey(this.apiKey) : (ApiKey)new NoopApiKey());
        if (this.baseUrl != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI base URL: {}", (Object)this.baseUrl);
            builder.baseUrl(this.baseUrl);
        }
        if (this.completionsPath != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI completions path: {}", (Object)this.completionsPath);
            builder.completionsPath(this.completionsPath);
        }
        if (this.embeddingsPath != null) {
            $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(OpenAiModels.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Using custom OpenAI embeddings path: {}", (Object)this.embeddingsPath);
            builder.embeddingsPath(this.embeddingsPath);
        }
        builder.restClientBuilder(RestClient.builder().observationRegistry(this.observationRegistry));
        builder.webClientBuilder(WebClient.builder().observationRegistry(this.observationRegistry));
        OpenAiApi openAiApi = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)openAiApi, (String)"build(...)");
        return openAiApi;
    }

    @JvmOverloads
    @NotNull
    public final Llm openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate, @NotNull OptionsConverter<?> optionsConverter, @NotNull RetryTemplate retryTemplate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(optionsConverter, (String)"optionsConverter");
        Intrinsics.checkNotNullParameter((Object)retryTemplate, (String)"retryTemplate");
        ChatModel chatModel = this.chatModelOf(model, retryTemplate);
        return new Llm(model, provider, chatModel, optionsConverter, knowledgeCutoffDate, null, pricingModel, 32, null);
    }

    public static /* synthetic */ Llm openAiCompatibleLlm$default(OpenAiCompatibleModelFactory openAiCompatibleModelFactory, String string, PricingModel pricingModel, String string2, LocalDate localDate, OptionsConverter optionsConverter, RetryTemplate retryTemplate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openAiCompatibleLlm");
        }
        if ((n & 0x10) != 0) {
            optionsConverter = OpenAiChatOptionsConverter.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        }
        return openAiCompatibleModelFactory.openAiCompatibleLlm(string, pricingModel, string2, localDate, optionsConverter, retryTemplate);
    }

    @NotNull
    public final EmbeddingService openAiCompatibleEmbeddingService(@NotNull String model, @NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        OpenAiEmbeddingModel embeddingModel = new OpenAiEmbeddingModel(this.openAiApi, MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().model(model).build());
        return new EmbeddingService(model, provider, (EmbeddingModel)embeddingModel);
    }

    @NotNull
    protected final ChatModel chatModelOf(@NotNull String model, @NotNull RetryTemplate retryTemplate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)retryTemplate, (String)"retryTemplate");
        OpenAiChatModel openAiChatModel = OpenAiChatModel.builder().defaultOptions(OpenAiChatOptions.builder().model(model).build()).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry(this.observationRegistry).build()).openAiApi(this.openAiApi).retryTemplate(retryTemplate).observationRegistry(this.observationRegistry).build();
        Intrinsics.checkNotNullExpressionValue((Object)openAiChatModel, (String)"build(...)");
        return (ChatModel)openAiChatModel;
    }

    @JvmOverloads
    @NotNull
    public final Llm openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate, @NotNull OptionsConverter<?> optionsConverter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(optionsConverter, (String)"optionsConverter");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default(this, model, pricingModel, provider, knowledgeCutoffDate, optionsConverter, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final Llm openAiCompatibleLlm(@NotNull String model, @NotNull PricingModel pricingModel, @NotNull String provider, @Nullable LocalDate knowledgeCutoffDate) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pricingModel, (String)"pricingModel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default(this, model, pricingModel, provider, knowledgeCutoffDate, null, null, 48, null);
    }
}

