/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.openai.custom;

import com.embabel.agent.config.models.openai.custom.OpenAiCustomProperties;
import com.embabel.agent.openai.OpenAiCompatibleModelFactory;
import com.embabel.agent.openai.StandardOpenAiOptionsConverter;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenAiCustomProperties.class})
@ExcludeFromJacocoGeneratedReport(reason="OpenAi Custom configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBW\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/config/models/openai/custom/OpenAiCustomModelsConfig;", "Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "envBaseUrl", "", "envApiKey", "envCustomModels", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "properties", "Lcom/embabel/agent/config/models/openai/custom/OpenAiCustomProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "requestFactory", "Lorg/springframework/http/client/ClientHttpRequestFactory;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/beans/factory/ObjectProvider;Lcom/embabel/agent/config/models/openai/custom/OpenAiCustomProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lorg/springframework/beans/factory/ObjectProvider;)V", "customModelList", "", "openAiCustomModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "registerCustomModels", "Lcom/embabel/common/ai/autoconfig/RegisteredModel;", "createCustomLlm", "Lcom/embabel/common/ai/model/Llm;", "modelId", "Companion", "embabel-agent-openai-custom-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nOpenAiCustomModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiCustomModelsConfig.kt\ncom/embabel/agent/config/models/openai/custom/OpenAiCustomModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1557#2:185\n1628#2,3:186\n774#2:189\n865#2,2:190\n1557#2:193\n1628#2,3:194\n1#3:192\n*S KotlinDebug\n*F\n+ 1 OpenAiCustomModelsConfig.kt\ncom/embabel/agent/config/models/openai/custom/OpenAiCustomModelsConfig\n*L\n121#1:185\n121#1:186,3\n122#1:189\n122#1:190,2\n146#1:193\n146#1:194,3\n*E\n"})
public class OpenAiCustomModelsConfig
extends OpenAiCompatibleModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String envBaseUrl;
    @Nullable
    private final String envApiKey;
    @Nullable
    private final String envCustomModels;
    @NotNull
    private final OpenAiCustomProperties properties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final List<String> customModelList;
    @NotNull
    private static final String CUSTOM_PROVIDER = "OpenAI-Custom";

    /*
     * WARNING - void declaration
     */
    public OpenAiCustomModelsConfig(@Value(value="${OPENAI_CUSTOM_BASE_URL:#{null}}") @Nullable String envBaseUrl, @Value(value="${OPENAI_CUSTOM_API_KEY:#{null}}") @Nullable String envApiKey, @Value(value="${OPENAI_CUSTOM_MODELS:#{null}}") @Nullable String envCustomModels, @NotNull ObjectProvider<ObservationRegistry> observationRegistry, @NotNull OpenAiCustomProperties properties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull ObjectProvider<ClientHttpRequestFactory> requestFactory) {
        List list;
        String[] stringArray;
        List list2;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
        String string3 = envBaseUrl;
        if (string3 == null) {
            string3 = properties.getBaseUrl();
        }
        if ((string2 = envApiKey) == null && (string2 = properties.getApiKey()) == null) {
            throw new IllegalStateException("OpenAI Custom API key required: set OPENAI_CUSTOM_API_KEY env var or embabel.agent.platform.models.openai.custom.api-key".toString());
        }
        Object object = observationRegistry.getIfUnique(OpenAiCustomModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(string3, string2, null, null, (ObservationRegistry)object, requestFactory);
        this.envBaseUrl = envBaseUrl;
        this.envApiKey = envApiKey;
        this.envCustomModels = envCustomModels;
        this.properties = properties;
        this.configurableBeanFactory = configurableBeanFactory;
        OpenAiCustomModelsConfig openAiCustomModelsConfig = this;
        String string4 = this.envCustomModels;
        if (string4 == null) {
            string4 = this.properties.getModels();
        }
        if ((string = string4) != null && (list2 = StringsKt.split$default((CharSequence)string, (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            OpenAiCustomModelsConfig openAiCustomModelsConfig2 = openAiCustomModelsConfig;
            boolean $i$f$map22 = false;
            void var13_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
            openAiCustomModelsConfig = openAiCustomModelsConfig2;
        } else {
            list = CollectionsKt.emptyList();
        }
        openAiCustomModelsConfig.customModelList = list;
        this.getLogger().info("OpenAI Custom models are available: {}", (Object)this.properties);
        if (!((Collection)this.customModelList).isEmpty()) {
            this.getLogger().info("Custom OpenAI-Custom models configured: {}", this.customModelList);
        }
    }

    @Bean
    @NotNull
    public ProviderInitialization openAiCustomModelsInitializer() {
        ProviderInitialization providerInitialization;
        List<RegisteredModel> registeredLlms = this.registerCustomModels();
        ProviderInitialization it = providerInitialization = new ProviderInitialization(CUSTOM_PROVIDER, registeredLlms, null, null, 12, null);
        boolean bl = false;
        this.getLogger().info(it.summary());
        return providerInitialization;
    }

    /*
     * WARNING - void declaration
     */
    private List<RegisteredModel> registerCustomModels() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.customModelList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RegisteredModel registeredModel;
            void modelId;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                Llm llm = this.createCustomLlm((String)modelId);
                this.configurableBeanFactory.registerSingleton((String)modelId, (Object)llm);
                this.getLogger().info("Registered custom OpenAI-compatible model bean: {}", (Object)modelId);
                registeredModel = new RegisteredModel((String)modelId, (String)modelId);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to create custom model: {}", (Object)modelId, (Object)e);
                throw e;
            }
            collection.add(registeredModel);
        }
        return (List)destination$iv$iv;
    }

    private Llm createCustomLlm(String modelId) {
        ChatModel chatModel = this.chatModelOf(modelId, this.properties.retryTemplate(modelId));
        StandardOpenAiOptionsConverter standardOpenAiOptionsConverter = StandardOpenAiOptionsConverter.INSTANCE;
        return new Llm(modelId, CUSTOM_PROVIDER, chatModel, (OptionsConverter)standardOpenAiOptionsConverter, null, null, null, 112, null);
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/config/models/openai/custom/OpenAiCustomModelsConfig$Companion;", "", "<init>", "()V", "CUSTOM_PROVIDER", "", "embabel-agent-openai-custom-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

