/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.openai;

import com.embabel.agent.config.models.openai.OpenAiEmbeddingModelDefinition;
import com.embabel.agent.config.models.openai.OpenAiModelDefinition;
import com.embabel.agent.config.models.openai.OpenAiModelDefinitions;
import com.embabel.agent.config.models.openai.OpenAiModelLoader;
import com.embabel.agent.config.models.openai.OpenAiProperties;
import com.embabel.agent.config.models.openai.SpecialHandlingConfiguration;
import com.embabel.agent.openai.Gpt5ChatOptionsConverter;
import com.embabel.agent.openai.OpenAiCompatibleModelFactory;
import com.embabel.agent.openai.StandardOpenAiOptionsConverter;
import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadataLoader;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenAiProperties.class})
@ExcludeFromJacocoGeneratedReport(reason="OpenAi configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001Bu\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/embabel/agent/config/models/openai/OpenAiModelsConfig;", "Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "envBaseUrl", "", "envApiKey", "envCompletionsPath", "envEmbeddingsPath", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "requestFactory", "Lorg/springframework/http/client/ClientHttpRequestFactory;", "properties", "Lcom/embabel/agent/config/models/openai/OpenAiProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "modelLoader", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;", "Lcom/embabel/agent/config/models/openai/OpenAiModelDefinitions;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;Lcom/embabel/agent/config/models/openai/OpenAiProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;)V", "openAiModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "createOpenAiLlm", "Lcom/embabel/common/ai/model/Llm;", "modelDef", "Lcom/embabel/agent/config/models/openai/OpenAiModelDefinition;", "createOpenAiEmbedding", "Lcom/embabel/common/ai/model/EmbeddingService;", "embeddingDef", "Lcom/embabel/agent/config/models/openai/OpenAiEmbeddingModelDefinition;", "embabel-agent-openai-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nOpenAiModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiModelsConfig.kt\ncom/embabel/agent/config/models/openai/OpenAiModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1863#2,2:219\n1863#2,2:221\n1#3:223\n*S KotlinDebug\n*F\n+ 1 OpenAiModelsConfig.kt\ncom/embabel/agent/config/models/openai/OpenAiModelsConfig\n*L\n130#1:219,2\n149#1:221,2\n*E\n"})
public class OpenAiModelsConfig
extends OpenAiCompatibleModelFactory {
    @Nullable
    private final String envBaseUrl;
    @Nullable
    private final String envApiKey;
    @Nullable
    private final String envCompletionsPath;
    @Nullable
    private final String envEmbeddingsPath;
    @NotNull
    private final OpenAiProperties properties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final LlmAutoConfigMetadataLoader<OpenAiModelDefinitions> modelLoader;

    public OpenAiModelsConfig(@Value(value="${OPENAI_BASE_URL:#{null}}") @Nullable String envBaseUrl, @Value(value="${OPENAI_API_KEY:#{null}}") @Nullable String envApiKey, @Value(value="${OPENAI_COMPLETIONS_PATH:#{null}}") @Nullable String envCompletionsPath, @Value(value="${OPENAI_EMBEDDINGS_PATH:#{null}}") @Nullable String envEmbeddingsPath, @NotNull ObjectProvider<ObservationRegistry> observationRegistry, @Qualifier(value="aiModelHttpRequestFactory") @NotNull ObjectProvider<ClientHttpRequestFactory> requestFactory, @NotNull OpenAiProperties properties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull LlmAutoConfigMetadataLoader<OpenAiModelDefinitions> modelLoader) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter(requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(modelLoader, (String)"modelLoader");
        String string3 = envBaseUrl;
        if (string3 == null) {
            string3 = properties.getBaseUrl();
        }
        if ((string2 = envApiKey) == null && (string2 = properties.getApiKey()) == null) {
            throw new IllegalStateException("OpenAI API key required: set OPENAI_API_KEY env var or embabel.agent.platform.models.openai.api-key".toString());
        }
        String string4 = envCompletionsPath;
        if (string4 == null) {
            string4 = properties.getCompletions();
        }
        if ((string = envEmbeddingsPath) == null) {
            string = properties.getEmbeddingsPath();
        }
        Object object = observationRegistry.getIfUnique(OpenAiModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(string3, string2, string4, string, (ObservationRegistry)object, requestFactory);
        this.envBaseUrl = envBaseUrl;
        this.envApiKey = envApiKey;
        this.envCompletionsPath = envCompletionsPath;
        this.envEmbeddingsPath = envEmbeddingsPath;
        this.properties = properties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.modelLoader = modelLoader;
        this.getLogger().info("OpenAI models are available: {}", (Object)this.properties);
    }

    public /* synthetic */ OpenAiModelsConfig(String string, String string2, String string3, String string4, ObjectProvider objectProvider, ObjectProvider objectProvider2, OpenAiProperties openAiProperties, ConfigurableBeanFactory configurableBeanFactory, LlmAutoConfigMetadataLoader llmAutoConfigMetadataLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            llmAutoConfigMetadataLoader = (LlmAutoConfigMetadataLoader)new OpenAiModelLoader(null, null, 3, null);
        }
        this(string, string2, string3, string4, (ObjectProvider<ObservationRegistry>)objectProvider, (ObjectProvider<ClientHttpRequestFactory>)objectProvider2, openAiProperties, configurableBeanFactory, (LlmAutoConfigMetadataLoader<OpenAiModelDefinitions>)llmAutoConfigMetadataLoader);
    }

    @Bean
    @NotNull
    public ProviderInitialization openAiModelsInitializer() {
        List list;
        List list2;
        OpenAiModelDefinitions definitions = (OpenAiModelDefinitions)this.modelLoader.loadAutoConfigMetadata();
        List $this$openAiModelsInitializer_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = definitions.getModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenAiModelDefinition modelDef = (OpenAiModelDefinition)element$iv;
            boolean bl2 = false;
            try {
                Llm llm = this.createOpenAiLlm(modelDef);
                this.configurableBeanFactory.registerSingleton(modelDef.getName(), (Object)llm);
                $this$openAiModelsInitializer_u24lambda_u242.add(new RegisteredModel(modelDef.getName(), modelDef.getModelId()));
                this.getLogger().info("Registered OpenAI model bean: {} -> {}", (Object)modelDef.getName(), (Object)modelDef.getModelId());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{modelDef.getName(), modelDef.getModelId(), e};
                this.getLogger().error("Failed to create model: {} ({})", objectArray);
                throw e;
            }
        }
        List registeredLlms = CollectionsKt.build((List)list2);
        List $this$openAiModelsInitializer_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        Iterable $this$forEach$iv2 = definitions.getEmbeddingModels();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            OpenAiEmbeddingModelDefinition embeddingDef = (OpenAiEmbeddingModelDefinition)element$iv;
            boolean bl4 = false;
            try {
                EmbeddingService embeddingService = this.createOpenAiEmbedding(embeddingDef);
                this.configurableBeanFactory.registerSingleton(embeddingDef.getName(), (Object)embeddingService);
                $this$openAiModelsInitializer_u24lambda_u244.add(new RegisteredModel(embeddingDef.getName(), embeddingDef.getModelId()));
                this.getLogger().info("Registered OpenAI embedding model bean: {} -> {}", (Object)embeddingDef.getName(), (Object)embeddingDef.getModelId());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{embeddingDef.getName(), embeddingDef.getModelId(), e};
                this.getLogger().error("Failed to create embedding model: {} ({})", objectArray);
                throw e;
            }
        }
        List registeredEmbeddings = CollectionsKt.build((List)list);
        List it = list = new ProviderInitialization("OpenAI", registeredLlms, registeredEmbeddings, null, 8, null);
        boolean bl5 = false;
        this.getLogger().info(it.summary());
        return list;
    }

    private Llm createOpenAiLlm(OpenAiModelDefinition modelDef) {
        PerTokenPricingModel perTokenPricingModel;
        SpecialHandlingConfiguration specialHandlingConfiguration = modelDef.getSpecialHandling();
        OptionsConverter optionsConverter = (specialHandlingConfiguration != null ? !specialHandlingConfiguration.getSupportsTemperature() : false) ? (OptionsConverter)Gpt5ChatOptionsConverter.INSTANCE : (OptionsConverter)StandardOpenAiOptionsConverter.INSTANCE;
        ChatModel chatModel = this.chatModelOf(modelDef.getModelId(), this.properties.retryTemplate(modelDef.getModelId()));
        PerTokenPricingModel perTokenPricingModel2 = modelDef.getPricingModel();
        if (perTokenPricingModel2 != null) {
            PerTokenPricingModel it = perTokenPricingModel2;
            boolean bl = false;
            perTokenPricingModel = new PerTokenPricingModel(it.getUsdPer1mInputTokens(), it.getUsdPer1mOutputTokens());
        } else {
            perTokenPricingModel = null;
        }
        PerTokenPricingModel pricingModel = perTokenPricingModel;
        String string = modelDef.getModelId();
        LocalDate localDate = modelDef.getKnowledgeCutoffDate();
        return new Llm(string, "OpenAI", chatModel, optionsConverter, localDate, null, (PricingModel)pricingModel, 32, null);
    }

    private EmbeddingService createOpenAiEmbedding(OpenAiEmbeddingModelDefinition embeddingDef) {
        return this.openAiCompatibleEmbeddingService(embeddingDef.getModelId(), "OpenAI");
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }
}

