/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.openai;

import com.embabel.agent.config.models.openai.EmbeddingPricingModel;
import com.embabel.agent.config.models.openai.OpenAiEmbeddingModelDefinition;
import com.embabel.agent.config.models.openai.OpenAiModelDefinition;
import com.embabel.agent.config.models.openai.OpenAiModelDefinitions;
import com.embabel.common.ai.autoconfig.AbstractYamlModelLoader;
import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0002H\u0014J\b\u0010\f\u001a\u00020\u0006H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/config/models/openai/OpenAiModelLoader;", "Lcom/embabel/common/ai/autoconfig/AbstractYamlModelLoader;", "Lcom/embabel/agent/config/models/openai/OpenAiModelDefinitions;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "configPath", "", "<init>", "(Lorg/springframework/core/io/ResourceLoader;Ljava/lang/String;)V", "getProviderClass", "Lkotlin/reflect/KClass;", "createEmptyProvider", "getProviderName", "validateModels", "", "provider", "Companion", "embabel-agent-openai-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nOpenAiModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiModelLoader.kt\ncom/embabel/agent/config/models/openai/OpenAiModelLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1863#2:159\n1864#2:161\n1863#2,2:162\n1#3:160\n*S KotlinDebug\n*F\n+ 1 OpenAiModelLoader.kt\ncom/embabel/agent/config/models/openai/OpenAiModelLoader\n*L\n125#1:159\n125#1:161\n137#1:162,2\n*E\n"})
public final class OpenAiModelLoader
extends AbstractYamlModelLoader<OpenAiModelDefinitions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_CONFIG_PATH = "classpath:models/openai-models.yml";

    public OpenAiModelLoader(@NotNull ResourceLoader resourceLoader, @NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        super(resourceLoader, configPath);
    }

    public /* synthetic */ OpenAiModelLoader(ResourceLoader resourceLoader, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            resourceLoader = (ResourceLoader)new DefaultResourceLoader();
        }
        if ((n & 2) != 0) {
            string = DEFAULT_CONFIG_PATH;
        }
        this(resourceLoader, string);
    }

    @NotNull
    protected KClass<OpenAiModelDefinitions> getProviderClass() {
        return Reflection.getOrCreateKotlinClass(OpenAiModelDefinitions.class);
    }

    @NotNull
    protected OpenAiModelDefinitions createEmptyProvider() {
        return new OpenAiModelDefinitions(null, null, 3, null);
    }

    @NotNull
    protected String getProviderName() {
        return "OpenAI";
    }

    protected void validateModels(@NotNull OpenAiModelDefinitions provider) {
        Object model;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Iterable $this$forEach$iv = provider.getModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            model = (OpenAiModelDefinition)element$iv;
            boolean bl = false;
            this.validateCommonFields((LlmAutoConfigMetadata)model);
            if (!(((OpenAiModelDefinition)model).getMaxTokens() > 0)) {
                boolean $i$a$-require-OpenAiModelLoader$validateModels$1$32 = false;
                String $i$a$-require-OpenAiModelLoader$validateModels$1$32 = "Max tokens must be positive for model " + ((OpenAiModelDefinition)model).getName();
                throw new IllegalArgumentException($i$a$-require-OpenAiModelLoader$validateModels$1$32.toString());
            }
            double d = ((OpenAiModelDefinition)model).getTemperature();
            if (!(0.0 <= d ? d <= 2.0 : false)) {
                boolean $i$a$-require-OpenAiModelLoader$validateModels$1$42 = false;
                String $i$a$-require-OpenAiModelLoader$validateModels$1$42 = "Temperature must be between 0 and 2 for model " + ((OpenAiModelDefinition)model).getName();
                throw new IllegalArgumentException($i$a$-require-OpenAiModelLoader$validateModels$1$42.toString());
            }
            Double d2 = ((OpenAiModelDefinition)model).getTopP();
            if (d2 == null) continue;
            double it = ((Number)d2).doubleValue();
            boolean bl2 = false;
            if (0.0 <= it ? it <= 1.0 : false) continue;
            boolean bl3 = false;
            String string = "Top P must be between 0 and 1 for model " + ((OpenAiModelDefinition)model).getName();
            throw new IllegalArgumentException(string.toString());
        }
        $this$forEach$iv = provider.getEmbeddingModels();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EmbeddingPricingModel it;
            model = (OpenAiEmbeddingModelDefinition)element$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)((OpenAiEmbeddingModelDefinition)model).getName()))) {
                boolean $i$a$-require-OpenAiModelLoader$validateModels$2$32 = false;
                String $i$a$-require-OpenAiModelLoader$validateModels$2$32 = "Embedding model name cannot be blank";
                throw new IllegalArgumentException($i$a$-require-OpenAiModelLoader$validateModels$2$32.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)((OpenAiEmbeddingModelDefinition)model).getModelId()))) {
                boolean bl4 = false;
                String string = "Embedding model ID cannot be blank";
                throw new IllegalArgumentException(string.toString());
            }
            Integer n = ((OpenAiEmbeddingModelDefinition)model).getDimensions();
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl5 = false;
                if (!(it2 > 0)) {
                    boolean $i$a$-require-OpenAiModelLoader$validateModels$2$3$22 = false;
                    String $i$a$-require-OpenAiModelLoader$validateModels$2$3$22 = "Dimensions must be positive for embedding model " + ((OpenAiEmbeddingModelDefinition)model).getName();
                    throw new IllegalArgumentException($i$a$-require-OpenAiModelLoader$validateModels$2$3$22.toString());
                }
            }
            if (((OpenAiEmbeddingModelDefinition)model).getPricingModel() == null) continue;
            boolean bl6 = false;
            if (it.getUsdPer1mTokens() >= 0.0) continue;
            boolean bl7 = false;
            String string = "Pricing must be non-negative for embedding model " + ((OpenAiEmbeddingModelDefinition)model).getName();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public OpenAiModelLoader() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/config/models/openai/OpenAiModelLoader$Companion;", "", "<init>", "()V", "DEFAULT_CONFIG_PATH", "", "embabel-agent-openai-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

