/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.openai;

import com.embabel.agent.api.models.OpenAiCompatibleModelFactory;
import com.embabel.agent.config.models.openai.Gpt5ChatOptionsConverter;
import com.embabel.agent.config.models.openai.OpenAiProperties;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@ExcludeFromJacocoGeneratedReport(reason="OpenAi configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BK\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u000fH\u0017J\b\u0010\u0011\u001a\u00020\u000fH\u0017J\b\u0010\u0012\u001a\u00020\u000fH\u0017J\b\u0010\u0013\u001a\u00020\u000fH\u0017J\b\u0010\u0014\u001a\u00020\u000fH\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/config/models/openai/OpenAiModelsConfig;", "Lcom/embabel/agent/api/models/OpenAiCompatibleModelFactory;", "baseUrl", "", "apiKey", "completionsPath", "embeddingsPath", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "properties", "Lcom/embabel/agent/config/models/openai/OpenAiProperties;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/beans/factory/ObjectProvider;Lcom/embabel/agent/config/models/openai/OpenAiProperties;)V", "gpt5", "Lcom/embabel/common/ai/model/Llm;", "gpt5mini", "gpt5nano", "gpt41mini", "gpt41", "gpt41nano", "defaultOpenAiEmbeddingService", "Lcom/embabel/common/ai/model/EmbeddingService;", "embabel-agent-openai-autoconfigure"})
public class OpenAiModelsConfig
extends OpenAiCompatibleModelFactory {
    @NotNull
    private final OpenAiProperties properties;

    public OpenAiModelsConfig(@Value(value="${OPENAI_BASE_URL:#{null}}") @Nullable String baseUrl, @Value(value="${OPENAI_API_KEY}") @NotNull String apiKey, @Value(value="${OPENAI_COMPLETIONS_PATH:#{null}}") @Nullable String completionsPath, @Value(value="${OPENAI_EMBEDDINGS_PATH:#{null}}") @Nullable String embeddingsPath, @NotNull ObjectProvider<ObservationRegistry> observationRegistry, @NotNull OpenAiProperties properties) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Object object = observationRegistry.getIfUnique(OpenAiModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(baseUrl, apiKey, completionsPath, embeddingsPath, (ObservationRegistry)object);
        this.properties = properties;
        this.getLogger().info("Open AI models are available: {}", (Object)this.properties);
    }

    @Bean
    @NotNull
    public Llm gpt5() {
        LocalDate localDate = LocalDate.of(2024, 10, 1);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(1.25, 10.0);
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-5");
        Gpt5ChatOptionsConverter gpt5ChatOptionsConverter = Gpt5ChatOptionsConverter.INSTANCE;
        return this.openAiCompatibleLlm("gpt-5", (PricingModel)perTokenPricingModel, "OpenAI", localDate, gpt5ChatOptionsConverter, retryTemplate);
    }

    @Bean
    @NotNull
    public Llm gpt5mini() {
        LocalDate localDate = LocalDate.of(2024, 5, 31);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(0.25, 2.0);
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-5-mini");
        Gpt5ChatOptionsConverter gpt5ChatOptionsConverter = Gpt5ChatOptionsConverter.INSTANCE;
        return this.openAiCompatibleLlm("gpt-5-mini", (PricingModel)perTokenPricingModel, "OpenAI", localDate, gpt5ChatOptionsConverter, retryTemplate);
    }

    @Bean
    @NotNull
    public Llm gpt5nano() {
        LocalDate localDate = LocalDate.of(2024, 5, 31);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(0.05, 0.4);
        Gpt5ChatOptionsConverter gpt5ChatOptionsConverter = Gpt5ChatOptionsConverter.INSTANCE;
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-5-nano");
        return this.openAiCompatibleLlm("gpt-5-nano", (PricingModel)perTokenPricingModel, "OpenAI", localDate, gpt5ChatOptionsConverter, retryTemplate);
    }

    @Bean
    @NotNull
    public Llm gpt41mini() {
        LocalDate localDate = LocalDate.of(2024, 7, 18);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(0.4, 1.6);
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-4.1-mini");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default((OpenAiCompatibleModelFactory)this, (String)"gpt-4.1-mini", (PricingModel)((PricingModel)perTokenPricingModel), (String)"OpenAI", (LocalDate)localDate, null, (RetryTemplate)retryTemplate, (int)16, null);
    }

    @Bean
    @NotNull
    public Llm gpt41() {
        LocalDate localDate = LocalDate.of(2024, 8, 6);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(2.0, 8.0);
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-4.1");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default((OpenAiCompatibleModelFactory)this, (String)"gpt-4.1", (PricingModel)((PricingModel)perTokenPricingModel), (String)"OpenAI", (LocalDate)localDate, null, (RetryTemplate)retryTemplate, (int)16, null);
    }

    @Bean
    @NotNull
    public Llm gpt41nano() {
        LocalDate localDate = LocalDate.of(2024, 8, 6);
        PerTokenPricingModel perTokenPricingModel = new PerTokenPricingModel(0.1, 0.4);
        RetryTemplate retryTemplate = this.properties.retryTemplate("gpt-4.1-nano");
        return OpenAiCompatibleModelFactory.openAiCompatibleLlm$default((OpenAiCompatibleModelFactory)this, (String)"gpt-4.1-nano", (PricingModel)((PricingModel)perTokenPricingModel), (String)"OpenAI", (LocalDate)localDate, null, (RetryTemplate)retryTemplate, (int)16, null);
    }

    @Bean
    @NotNull
    public EmbeddingService defaultOpenAiEmbeddingService() {
        return this.openAiCompatibleEmbeddingService("text-embedding-3-small", "OpenAI");
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }
}

