/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.openai;

import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.OptionsConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.openai.OpenAiChatOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/embabel/agent/config/models/openai/Gpt5ChatOptionsConverter;", "Lcom/embabel/common/ai/model/OptionsConverter;", "Lorg/springframework/ai/openai/OpenAiChatOptions;", "<init>", "()V", "convertOptions", "options", "Lcom/embabel/common/ai/model/LlmOptions;", "embabel-agent-openai-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nOpenAiModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiModelsConfig.kt\ncom/embabel/agent/config/models/openai/Gpt5ChatOptionsConverter\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,206:1\n27#2:207\n*S KotlinDebug\n*F\n+ 1 OpenAiModelsConfig.kt\ncom/embabel/agent/config/models/openai/Gpt5ChatOptionsConverter\n*L\n192#1:207\n*E\n"})
public final class Gpt5ChatOptionsConverter
implements OptionsConverter<OpenAiChatOptions> {
    @NotNull
    public static final Gpt5ChatOptionsConverter INSTANCE = new Gpt5ChatOptionsConverter();

    private Gpt5ChatOptionsConverter() {
    }

    @NotNull
    public OpenAiChatOptions convertOptions(@NotNull LlmOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.getTemperature() != null && !Intrinsics.areEqual((Double)options.getTemperature(), (double)1.0)) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(Gpt5ChatOptionsConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("GPT-5 models do not support temperature settings other than default 1.0. You set {} but it will be ignored.", (Object)options.getTemperature());
        }
        OpenAiChatOptions openAiChatOptions = OpenAiChatOptions.builder().topP(options.getTopP()).maxTokens(options.getMaxTokens()).presencePenalty(options.getPresencePenalty()).frequencyPenalty(options.getFrequencyPenalty()).build();
        Intrinsics.checkNotNullExpressionValue((Object)openAiChatOptions, (String)"build(...)");
        return openAiChatOptions;
    }
}

