/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import com.embabel.agent.api.event.ToolCallResponseEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.DataDictionary;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.IoBinding;
import com.embabel.plan.Plan;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObservationUtils {
    private static final Logger log = LoggerFactory.getLogger(ObservationUtils.class);

    private ObservationUtils() {
    }

    static String truncate(String value, int maxLength) {
        if (value == null) {
            return "";
        }
        return value.length() > maxLength ? value.substring(0, maxLength) + "..." : value;
    }

    static String extractGoalName(AgentProcess process) {
        if (process.getGoal() != null) {
            return process.getGoal().getName();
        }
        if (!process.getAgent().getGoals().isEmpty()) {
            return ((Goal)process.getAgent().getGoals().iterator().next()).getName();
        }
        return "unknown";
    }

    static String getBlackboardSnapshot(AgentProcess process) {
        List objects = process.getBlackboard().getObjects();
        if (objects == null || objects.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) continue;
            if (sb.length() > 0) {
                sb.append("\n---\n");
            }
            sb.append(obj.getClass().getSimpleName()).append(": ");
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    static String getActionInputs(Action action, AgentProcess process) {
        Set inputs = action.getInputs();
        if (inputs == null || inputs.isEmpty()) {
            return "";
        }
        Blackboard blackboard = process.getBlackboard();
        StringBuilder sb = new StringBuilder();
        for (IoBinding input : inputs) {
            Object value;
            String type;
            String name;
            String bindingValue = input.getValue();
            if (bindingValue.contains(":")) {
                String[] parts = bindingValue.split(":", 2);
                name = parts[0];
                type = parts[1];
            } else {
                name = "it";
                type = bindingValue;
            }
            if ((value = blackboard.getValue(name, type, (DataDictionary)process.getAgent())) == null) continue;
            if (sb.length() > 0) {
                sb.append("\n---\n");
            }
            sb.append(name).append(" (").append(type).append("): ");
            sb.append(value.toString());
        }
        return sb.toString();
    }

    static String formatPlanSteps(Plan plan) {
        if (plan == null || plan.getActions() == null || plan.getActions().isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int index = 1;
        for (com.embabel.plan.Action action : plan.getActions()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(index++).append(". ").append(action.getName());
        }
        if (plan.getGoal() != null) {
            sb.append("\n-> Goal: ").append(plan.getGoal().getName());
        }
        return sb.toString();
    }

    static Object extractToolResult(ToolCallResponseEvent event) {
        try {
            Method getResultMethod = null;
            for (Method m : ToolCallResponseEvent.class.getMethods()) {
                if (!m.getName().startsWith("getResult") || m.getParameterCount() != 0) continue;
                getResultMethod = m;
                break;
            }
            if (getResultMethod == null) {
                log.trace("getResult method not found on ToolCallResponseEvent");
                return null;
            }
            Object result = getResultMethod.invoke((Object)event, new Object[0]);
            if (result == null) {
                return null;
            }
            try {
                Method getOrNullMethod = result.getClass().getMethod("getOrNull", new Class[0]);
                return getOrNullMethod.invoke(result, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return result;
            }
        }
        catch (Exception e) {
            log.trace("Could not extract tool result: {}", (Object)e.getMessage());
            return null;
        }
    }

    static Throwable extractToolError(ToolCallResponseEvent event) {
        try {
            Method getResultMethod = null;
            for (Method m : ToolCallResponseEvent.class.getMethods()) {
                if (!m.getName().startsWith("getResult") || m.getParameterCount() != 0) continue;
                getResultMethod = m;
                break;
            }
            if (getResultMethod == null) {
                log.trace("getResult method not found on ToolCallResponseEvent");
                return null;
            }
            Object result = getResultMethod.invoke((Object)event, new Object[0]);
            if (result == null) {
                return null;
            }
            if (result instanceof Throwable) {
                return (Throwable)result;
            }
            try {
                Method exceptionOrNullMethod = result.getClass().getMethod("exceptionOrNull", new Class[0]);
                Object error = exceptionOrNullMethod.invoke(result, new Object[0]);
                if (error instanceof Throwable) {
                    return (Throwable)error;
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        catch (Exception e) {
            log.trace("Could not extract tool error: {}", (Object)e.getMessage());
        }
        return null;
    }
}

