/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.autoconfigure.observability;

import com.embabel.agent.autoconfigure.observability.OpenTelemetrySdkAutoConfiguration;
import com.embabel.agent.observability.ObservabilityProperties;
import com.embabel.agent.observability.observation.EmbabelTracingObservationHandler;
import com.embabel.agent.observability.observation.NonEmbabelTracingObservationHandler;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OpenTelemetrySdkAutoConfiguration.class})
@ConditionalOnClass(value={OtelTracer.class, OpenTelemetry.class, ObservationRegistry.class})
@ConditionalOnProperty(prefix="embabel.observability", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MicrometerTracingAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MicrometerTracingAutoConfiguration.class);
    private static final String OBSERVABILITY_TOOL_CALLBACK_OBSERVATION_NAME = "tool call";

    @Bean
    @ConditionalOnMissingBean(value={OtelCurrentTraceContext.class})
    public OtelCurrentTraceContext otelCurrentTraceContext() {
        log.debug("Creating OtelCurrentTraceContext for trace context propagation");
        return new OtelCurrentTraceContext();
    }

    @Bean
    @ConditionalOnProperty(prefix="embabel.observability", name={"implementation"}, havingValue="SPRING_OBSERVATION", matchIfMissing=true)
    public ObservationRegistryCustomizer<ObservationRegistry> embabelTracingObservationCustomizer(ObjectProvider<io.micrometer.tracing.Tracer> tracerProvider, ObjectProvider<OpenTelemetry> otelProvider, ObservabilityProperties properties) {
        return registry -> {
            io.micrometer.tracing.Tracer tracer = (io.micrometer.tracing.Tracer)tracerProvider.getIfAvailable();
            OpenTelemetry otel = (OpenTelemetry)otelProvider.getIfAvailable();
            if (tracer == null || otel == null) {
                log.warn("Cannot register EmbabelTracingObservationHandler: Tracer or OpenTelemetry not available");
                return;
            }
            Tracer otelTracer = otel.getTracer(properties.getTracerName(), properties.getTracerVersion());
            EmbabelTracingObservationHandler handler = new EmbabelTracingObservationHandler(tracer);
            registry.observationConfig().observationHandler((ObservationHandler)handler);
            log.info("Registered EmbabelTracingObservationHandler for Spring Observation API integration");
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultTracingObservationHandler.class})
    @ConditionalOnProperty(prefix="embabel.observability", name={"implementation"}, havingValue="SPRING_OBSERVATION", matchIfMissing=true)
    public DefaultTracingObservationHandler defaultTracingObservationHandler(io.micrometer.tracing.Tracer tracer) {
        log.info("Replacing Spring Boot's DefaultTracingObservationHandler with NonEmbabelTracingObservationHandler");
        return new NonEmbabelTracingObservationHandler(tracer);
    }

    @Bean
    @ConditionalOnProperty(prefix="embabel.observability", name={"trace-tool-calls"}, havingValue="true", matchIfMissing=true)
    public ObservationRegistryCustomizer<ObservationRegistry> skipObservabilityToolCallbackCustomizer() {
        log.info("Registering ObservationPredicate to skip ObservabilityToolCallback observations (trace-tool-calls=true, Embabel will trace tools via events)");
        return registry -> registry.observationConfig().observationPredicate((name, context) -> !OBSERVABILITY_TOOL_CALLBACK_OBSERVATION_NAME.equals(name));
    }
}

