/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver.async;

import com.embabel.agent.mcpserver.McpServerStrategy;
import com.embabel.agent.mcpserver.ToolRegistry;
import com.embabel.agent.mcpserver.async.AsyncToolRegistry;
import com.embabel.agent.mcpserver.domain.McpExecutionMode;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/embabel/agent/mcpserver/async/AsyncServerStrategy;", "Lcom/embabel/agent/mcpserver/McpServerStrategy;", "server", "Lio/modelcontextprotocol/server/McpAsyncServer;", "<init>", "(Lio/modelcontextprotocol/server/McpAsyncServer;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "executionMode", "Lcom/embabel/agent/mcpserver/domain/McpExecutionMode;", "getExecutionMode", "()Lcom/embabel/agent/mcpserver/domain/McpExecutionMode;", "addTool", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "toolSpec", "", "removeTool", "toolName", "", "addResource", "resourceSpec", "addPrompt", "promptSpec", "getToolRegistry", "Lcom/embabel/agent/mcpserver/ToolRegistry;", "embabel-agent-mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpAsyncServerStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpAsyncServerStrategy.kt\ncom/embabel/agent/mcpserver/async/AsyncServerStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class AsyncServerStrategy
implements McpServerStrategy {
    @NotNull
    private final McpAsyncServer server;
    private final Logger logger;
    @NotNull
    private final McpExecutionMode executionMode;

    public AsyncServerStrategy(@NotNull McpAsyncServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.logger = LoggerFactory.getLogger(AsyncServerStrategy.class);
        this.executionMode = McpExecutionMode.ASYNC;
    }

    @Override
    @NotNull
    public McpExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Override
    @NotNull
    public Mono<Void> addTool(@NotNull Object toolSpec) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)toolSpec, (String)"toolSpec");
        if (toolSpec instanceof McpServerFeatures.AsyncToolSpecification) {
            Mono mono2 = this.server.addTool((McpServerFeatures.AsyncToolSpecification)toolSpec);
            mono = mono2;
            Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"addTool(...)");
        } else {
            Mono mono3 = Mono.error((Throwable)new IllegalArgumentException("Expected AsyncToolSpecification, got " + Reflection.getOrCreateKotlinClass(toolSpec.getClass()).getSimpleName()));
            mono = mono3;
            Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"error(...)");
        }
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> removeTool(@NotNull String toolName) {
        Mono mono;
        McpSchema.Tool targetTool;
        McpSchema.Tool tool;
        List tools;
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        List list = tools = (List)this.server.listTools().collectList().block();
        if (list != null) {
            Object v1;
            block5: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    McpSchema.Tool it = (McpSchema.Tool)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)toolName)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            tool = v1;
        } else {
            tool = null;
        }
        McpSchema.Tool tool2 = targetTool = tool;
        if ((tool2 != null ? tool2.annotations() : null) != null) {
            this.logger.debug("Tool '" + toolName + "' has annotations; not removing it from the sync server.");
            Mono mono2 = Mono.empty();
            Intrinsics.checkNotNull((Object)mono2);
            mono = mono2;
        } else {
            Mono mono3 = this.server.removeTool(toolName);
            Intrinsics.checkNotNull((Object)mono3);
            mono = mono3;
        }
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> addResource(@NotNull Object resourceSpec) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)resourceSpec, (String)"resourceSpec");
        if (resourceSpec instanceof McpServerFeatures.AsyncResourceSpecification) {
            Mono mono2 = this.server.addResource((McpServerFeatures.AsyncResourceSpecification)resourceSpec);
            mono = mono2;
            Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"addResource(...)");
        } else {
            Mono mono3 = Mono.error((Throwable)new IllegalArgumentException("Expected AsyncResourceSpecification"));
            mono = mono3;
            Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"error(...)");
        }
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> addPrompt(@NotNull Object promptSpec) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)promptSpec, (String)"promptSpec");
        if (promptSpec instanceof McpServerFeatures.AsyncPromptSpecification) {
            Mono mono2 = this.server.addPrompt((McpServerFeatures.AsyncPromptSpecification)promptSpec);
            mono = mono2;
            Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"addPrompt(...)");
        } else {
            Mono mono3 = Mono.error((Throwable)new IllegalArgumentException("Expected AsyncPromptSpecification"));
            mono = mono3;
            Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"error(...)");
        }
        return mono;
    }

    @Override
    @NotNull
    public ToolRegistry getToolRegistry() {
        return new AsyncToolRegistry(this.server);
    }
}

