/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver.async.support;

import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.mcpserver.async.support.McpResourceUpdatingListener;
import com.embabel.agent.tools.agent.GoalTool;
import io.modelcontextprotocol.server.McpAsyncServer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/mcpserver/async/support/McpAwareGoalTool;", "I", "", "Lcom/embabel/agent/api/tool/Tool;", "delegate", "Lcom/embabel/agent/tools/agent/GoalTool;", "mcpAsyncServer", "Lio/modelcontextprotocol/server/McpAsyncServer;", "<init>", "(Lcom/embabel/agent/tools/agent/GoalTool;Lio/modelcontextprotocol/server/McpAsyncServer;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "embabel-agent-mcpserver"})
public final class McpAwareGoalTool<I>
implements Tool {
    @NotNull
    private final GoalTool<I> delegate;
    @NotNull
    private final McpAsyncServer mcpAsyncServer;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public McpAwareGoalTool(@NotNull GoalTool<I> delegate, @NotNull McpAsyncServer mcpAsyncServer) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)mcpAsyncServer, (String)"mcpAsyncServer");
        this.delegate = delegate;
        this.mcpAsyncServer = mcpAsyncServer;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition = this.delegate.getDefinition();
        this.metadata = this.delegate.getMetadata();
    }

    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        GoalTool delegateWithListener = this.delegate.withListener((AgenticEventListener)new McpResourceUpdatingListener(this.mcpAsyncServer));
        this.logger.debug("Calling MCP-aware goal tool {} with input: {}", (Object)this.getDefinition().getName(), (Object)input);
        return delegateWithListener.call(input);
    }
}

