/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver;

import com.embabel.agent.mcpserver.McpExportToolCallbackPublisher;
import com.embabel.agent.mcpserver.McpServerStrategy;
import com.embabel.agent.mcpserver.ToolRegistry;
import com.embabel.agent.mcpserver.async.McpAsyncPromptPublisher;
import com.embabel.agent.mcpserver.async.McpAsyncResourcePublisher;
import com.embabel.agent.mcpserver.domain.ToolSpecification;
import com.embabel.agent.mcpserver.sync.McpPromptPublisher;
import com.embabel.agent.mcpserver.sync.McpResourcePublisher;
import com.embabel.agent.spi.support.AgentScanningBeanPostProcessorEvent;
import io.modelcontextprotocol.server.McpServerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H&J\b\u0010\u0018\u001a\u00020\u0019H&J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH&J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH&J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH&J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH&J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H$J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0001H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0001H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0001H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lcom/embabel/agent/mcpserver/AbstractMcpServerConfiguration;", "", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "<init>", "(Lorg/springframework/context/ConfigurableApplicationContext;)V", "getApplicationContext", "()Lorg/springframework/context/ConfigurableApplicationContext;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "exposeMcpFunctionality", "", "initializeServer", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "strategy", "Lcom/embabel/agent/mcpserver/McpServerStrategy;", "cleanupExistingTools", "exposeTools", "exposeResources", "exposePrompts", "createServerStrategy", "createBannerTool", "Lorg/springframework/ai/tool/ToolCallbackProvider;", "getToolPublishers", "", "Lcom/embabel/agent/mcpserver/McpExportToolCallbackPublisher;", "getResourcePublishers", "getPromptPublishers", "convertToToolSpecifications", "toolCallbacks", "shouldPreserveTool", "", "toolName", "", "getExecutionMode", "getToolName", "toolSpec", "getResourceName", "resourceSpec", "getPromptName", "promptSpec", "embabel-agent-mcpserver"})
@SourceDebugExtension(value={"SMAP\nAbstractMcpServerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMcpServerConfiguration.kt\ncom/embabel/agent/mcpserver/AbstractMcpServerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,348:1\n774#2:349\n865#2,2:350\n1368#2:352\n1454#2,5:353\n1368#2:358\n1454#2,5:359\n1368#2:364\n1454#2,5:365\n*S KotlinDebug\n*F\n+ 1 AbstractMcpServerConfiguration.kt\ncom/embabel/agent/mcpserver/AbstractMcpServerConfiguration\n*L\n95#1:349\n95#1:350,2\n122#1:352\n122#1:353,5\n148#1:358\n148#1:359,5\n180#1:364\n180#1:365,5\n*E\n"})
public abstract class AbstractMcpServerConfiguration {
    @NotNull
    private final ConfigurableApplicationContext applicationContext;

    public AbstractMcpServerConfiguration(@NotNull ConfigurableApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @NotNull
    protected final ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    protected abstract Logger getLogger();

    @EventListener(value={AgentScanningBeanPostProcessorEvent.class})
    public final void exposeMcpFunctionality() {
        McpServerStrategy strategy = this.createServerStrategy();
        this.getLogger().info("Initializing {} MCP Server", (Object)strategy.getExecutionMode());
        try {
            Disposable disposable = this.initializeServer(strategy).doOnSuccess(arg_0 -> AbstractMcpServerConfiguration.exposeMcpFunctionality$lambda$1(arg_0 -> AbstractMcpServerConfiguration.exposeMcpFunctionality$lambda$0(this, strategy, arg_0), arg_0)).doOnError(arg_0 -> AbstractMcpServerConfiguration.exposeMcpFunctionality$lambda$3(arg_0 -> AbstractMcpServerConfiguration.exposeMcpFunctionality$lambda$2(this, strategy, arg_0), arg_0)).subscribe();
            Intrinsics.checkNotNull((Object)disposable);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize MCP server", (Throwable)e);
        }
    }

    private final Mono<Void> initializeServer(McpServerStrategy strategy) {
        Mono mono = this.cleanupExistingTools(strategy).then(this.exposeTools(strategy)).then(this.exposeResources(strategy)).then(this.exposePrompts(strategy));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final Mono<Void> cleanupExistingTools(McpServerStrategy strategy) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ToolRegistry toolRegistry = strategy.getToolRegistry();
        Iterable iterable = toolRegistry.getToolNames();
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.shouldPreserveTool(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toolsToRemove = (List)destination$iv$iv;
        if (!((Collection)toolsToRemove).isEmpty()) {
            this.getLogger().debug("Removing {} existing tools: {}", (Object)toolsToRemove.size(), (Object)CollectionsKt.joinToString$default((Iterable)toolsToRemove, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            iterable = Flux.fromIterable((Iterable)toolsToRemove).flatMap(arg_0 -> AbstractMcpServerConfiguration.cleanupExistingTools$lambda$10(arg_0 -> AbstractMcpServerConfiguration.cleanupExistingTools$lambda$9(strategy, this, arg_0), arg_0)).then();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"then(...)");
            return iterable;
        }
        Mono mono = Mono.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final Mono<Void> exposeTools(McpServerStrategy strategy) {
        void $this$flatMapTo$iv$iv;
        List<McpExportToolCallbackPublisher> toolPublishers = this.getToolPublishers();
        Iterable $this$flatMap$iv = toolPublishers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            McpExportToolCallbackPublisher it = (McpExportToolCallbackPublisher)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getToolCallbacks();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allTools = (List)destination$iv$iv;
        this.getLogger().info("Exposing {} tools from {} publishers", (Object)allTools.size(), (Object)toolPublishers.size());
        Mono mono = Flux.fromIterable((Iterable)this.convertToToolSpecifications(allTools)).flatMap(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18(strategy, this, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final Mono<Void> exposeResources(McpServerStrategy strategy) {
        void $this$flatMapTo$iv$iv;
        List<Object> resourcePublishers = this.getResourcePublishers();
        Iterable $this$flatMap$iv = resourcePublishers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object publisher = element$iv$iv = iterator.next();
            boolean bl = false;
            Object t = publisher;
            Iterable list$iv$iv = t instanceof McpResourcePublisher ? ((McpResourcePublisher)publisher).resources() : (t instanceof McpAsyncResourcePublisher ? ((McpAsyncResourcePublisher)publisher).resources() : CollectionsKt.emptyList());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allResources = (List)destination$iv$iv;
        this.getLogger().info("Exposing {} resources from {} publishers", (Object)allResources.size(), (Object)resourcePublishers.size());
        Mono mono = Flux.fromIterable((Iterable)allResources).flatMap(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$27(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26(strategy, this, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final Mono<Void> exposePrompts(McpServerStrategy strategy) {
        void $this$flatMapTo$iv$iv;
        List<Object> promptPublishers = this.getPromptPublishers();
        Iterable $this$flatMap$iv = promptPublishers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object publisher = element$iv$iv = iterator.next();
            boolean bl = false;
            Object t = publisher;
            Iterable list$iv$iv = t instanceof McpPromptPublisher ? ((McpPromptPublisher)publisher).prompts() : (t instanceof McpAsyncPromptPublisher ? ((McpAsyncPromptPublisher)publisher).prompts() : CollectionsKt.emptyList());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allPrompts = (List)destination$iv$iv;
        this.getLogger().info("Exposing {} prompts from {} publishers", (Object)allPrompts.size(), (Object)promptPublishers.size());
        Mono mono = Flux.fromIterable((Iterable)allPrompts).flatMap(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$36(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35(strategy, this, arg_0), arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    public abstract McpServerStrategy createServerStrategy();

    @NotNull
    public abstract ToolCallbackProvider createBannerTool();

    @NotNull
    public abstract List<McpExportToolCallbackPublisher> getToolPublishers();

    @NotNull
    public abstract List<Object> getResourcePublishers();

    @NotNull
    public abstract List<Object> getPromptPublishers();

    @NotNull
    public abstract List<Object> convertToToolSpecifications(@NotNull List<? extends Object> var1);

    protected boolean shouldPreserveTool(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return Intrinsics.areEqual((Object)toolName, (Object)"helloBanner");
    }

    @NotNull
    protected abstract String getExecutionMode();

    private final String getToolName(Object toolSpec) {
        return toolSpec instanceof ToolSpecification ? ((ToolSpecification)toolSpec).toolName() : "Unknown Tool";
    }

    private final String getResourceName(Object resourceSpec) {
        String string;
        Object object = resourceSpec;
        if (object instanceof McpServerFeatures.SyncResourceSpecification) {
            String string2 = ((McpServerFeatures.SyncResourceSpecification)resourceSpec).resource().name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
            string = string2;
        } else if (object instanceof McpServerFeatures.AsyncResourceSpecification) {
            String string3 = ((McpServerFeatures.AsyncResourceSpecification)resourceSpec).resource().name();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
            string = string3;
        } else {
            string = "Unknown Resource";
        }
        return string;
    }

    private final String getPromptName(Object promptSpec) {
        String string;
        Object object = promptSpec;
        if (object instanceof McpServerFeatures.SyncPromptSpecification) {
            String string2 = ((McpServerFeatures.SyncPromptSpecification)promptSpec).prompt().name();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
        } else if (object instanceof McpServerFeatures.AsyncPromptSpecification) {
            String string3 = ((McpServerFeatures.AsyncPromptSpecification)promptSpec).prompt().name();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
        } else {
            string = "Unknown Prompt";
        }
        return string;
    }

    private static final Unit exposeMcpFunctionality$lambda$0(AbstractMcpServerConfiguration this$0, McpServerStrategy $strategy, Void it) {
        this$0.getLogger().info("{} MCP Server initialization completed successfully", (Object)$strategy.getExecutionMode());
        return Unit.INSTANCE;
    }

    private static final void exposeMcpFunctionality$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit exposeMcpFunctionality$lambda$2(AbstractMcpServerConfiguration this$0, McpServerStrategy $strategy, Throwable error) {
        this$0.getLogger().error($strategy.getExecutionMode() + " MCP Server initialization failed", error);
        return Unit.INSTANCE;
    }

    private static final void exposeMcpFunctionality$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit cleanupExistingTools$lambda$9$lambda$5(AbstractMcpServerConfiguration this$0, String $toolName, Throwable error) {
        this$0.getLogger().warn("Failed to remove tool '" + $toolName + "'", error);
        return Unit.INSTANCE;
    }

    private static final void cleanupExistingTools$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono cleanupExistingTools$lambda$9$lambda$7(Throwable it) {
        return Mono.empty();
    }

    private static final Mono cleanupExistingTools$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Publisher cleanupExistingTools$lambda$9(McpServerStrategy $strategy, AbstractMcpServerConfiguration this$0, String toolName) {
        Intrinsics.checkNotNull((Object)toolName);
        return (Publisher)$strategy.removeTool(toolName).doOnError(arg_0 -> AbstractMcpServerConfiguration.cleanupExistingTools$lambda$9$lambda$6(arg_0 -> AbstractMcpServerConfiguration.cleanupExistingTools$lambda$9$lambda$5(this$0, toolName, arg_0), arg_0)).onErrorResume(arg_0 -> AbstractMcpServerConfiguration.cleanupExistingTools$lambda$9$lambda$8(AbstractMcpServerConfiguration::cleanupExistingTools$lambda$9$lambda$7, arg_0));
    }

    private static final Publisher cleanupExistingTools$lambda$10(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Unit exposeTools$lambda$18$lambda$12(AbstractMcpServerConfiguration this$0, Object $toolSpec, Void it) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$toolSpec);
        logger.debug("Added tool: " + this$0.getToolName($toolSpec));
        return Unit.INSTANCE;
    }

    private static final void exposeTools$lambda$18$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit exposeTools$lambda$18$lambda$14(AbstractMcpServerConfiguration this$0, Object $toolSpec, Throwable error) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$toolSpec);
        logger.error("Failed to add tool: " + this$0.getToolName($toolSpec), error);
        return Unit.INSTANCE;
    }

    private static final void exposeTools$lambda$18$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono exposeTools$lambda$18$lambda$16(Throwable it) {
        return Mono.empty();
    }

    private static final Mono exposeTools$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Publisher exposeTools$lambda$18(McpServerStrategy $strategy, AbstractMcpServerConfiguration this$0, Object toolSpec) {
        Intrinsics.checkNotNull((Object)toolSpec);
        return (Publisher)$strategy.addTool(toolSpec).doOnSuccess(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18$lambda$13(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18$lambda$12(this$0, toolSpec, arg_0), arg_0)).doOnError(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18$lambda$15(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18$lambda$14(this$0, toolSpec, arg_0), arg_0)).onErrorResume(arg_0 -> AbstractMcpServerConfiguration.exposeTools$lambda$18$lambda$17(AbstractMcpServerConfiguration::exposeTools$lambda$18$lambda$16, arg_0));
    }

    private static final Unit exposeResources$lambda$26$lambda$20(AbstractMcpServerConfiguration this$0, Record $resourceSpec, Void it) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$resourceSpec);
        logger.debug("Added resource: " + this$0.getResourceName($resourceSpec));
        return Unit.INSTANCE;
    }

    private static final void exposeResources$lambda$26$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit exposeResources$lambda$26$lambda$22(AbstractMcpServerConfiguration this$0, Record $resourceSpec, Throwable error) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$resourceSpec);
        logger.error("Failed to add resource: " + this$0.getResourceName($resourceSpec), error);
        return Unit.INSTANCE;
    }

    private static final void exposeResources$lambda$26$lambda$23(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono exposeResources$lambda$26$lambda$24(Throwable it) {
        return Mono.empty();
    }

    private static final Mono exposeResources$lambda$26$lambda$25(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Publisher exposeResources$lambda$26(McpServerStrategy $strategy, AbstractMcpServerConfiguration this$0, Record resourceSpec) {
        Intrinsics.checkNotNull((Object)resourceSpec);
        return (Publisher)$strategy.addResource(resourceSpec).doOnSuccess(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26$lambda$21(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26$lambda$20(this$0, resourceSpec, arg_0), arg_0)).doOnError(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26$lambda$23(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26$lambda$22(this$0, resourceSpec, arg_0), arg_0)).onErrorResume(arg_0 -> AbstractMcpServerConfiguration.exposeResources$lambda$26$lambda$25(AbstractMcpServerConfiguration::exposeResources$lambda$26$lambda$24, arg_0));
    }

    private static final Publisher exposeResources$lambda$27(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Unit exposePrompts$lambda$35$lambda$29(AbstractMcpServerConfiguration this$0, Record $promptSpec, Void it) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$promptSpec);
        logger.debug("Added prompt: " + this$0.getPromptName($promptSpec));
        return Unit.INSTANCE;
    }

    private static final void exposePrompts$lambda$35$lambda$30(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit exposePrompts$lambda$35$lambda$31(AbstractMcpServerConfiguration this$0, Record $promptSpec, Throwable error) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNull((Object)$promptSpec);
        logger.error("Failed to add prompt: " + this$0.getPromptName($promptSpec), error);
        return Unit.INSTANCE;
    }

    private static final void exposePrompts$lambda$35$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono exposePrompts$lambda$35$lambda$33(Throwable it) {
        return Mono.empty();
    }

    private static final Mono exposePrompts$lambda$35$lambda$34(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Publisher exposePrompts$lambda$35(McpServerStrategy $strategy, AbstractMcpServerConfiguration this$0, Record promptSpec) {
        Intrinsics.checkNotNull((Object)promptSpec);
        return (Publisher)$strategy.addPrompt(promptSpec).doOnSuccess(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35$lambda$30(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35$lambda$29(this$0, promptSpec, arg_0), arg_0)).doOnError(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35$lambda$32(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35$lambda$31(this$0, promptSpec, arg_0), arg_0)).onErrorResume(arg_0 -> AbstractMcpServerConfiguration.exposePrompts$lambda$35$lambda$34(AbstractMcpServerConfiguration::exposePrompts$lambda$35$lambda$33, arg_0));
    }

    private static final Publisher exposePrompts$lambda$36(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }
}

