/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver.sync.config;

import com.embabel.agent.mcpserver.AbstractMcpServerConfiguration;
import com.embabel.agent.mcpserver.McpServerStrategy;
import com.embabel.agent.mcpserver.McpToolExportCallbackPublisher;
import com.embabel.agent.mcpserver.ServerInfoFactory;
import com.embabel.agent.mcpserver.UnifiedBannerTool;
import com.embabel.agent.mcpserver.domain.McpExecutionMode;
import com.embabel.agent.mcpserver.domain.ServerInfo;
import com.embabel.agent.mcpserver.sync.McpPromptPublisher;
import com.embabel.agent.mcpserver.sync.McpResourcePublisher;
import com.embabel.agent.mcpserver.sync.SyncServerStrategy;
import com.embabel.agent.mcpserver.sync.config.McpSyncServerCondition;
import io.modelcontextprotocol.server.McpSyncServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={McpSyncServerCondition.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration;", "Lcom/embabel/agent/mcpserver/AbstractMcpServerConfiguration;", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "<init>", "(Lorg/springframework/context/ConfigurableApplicationContext;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "serverInfo", "Lcom/embabel/agent/mcpserver/domain/ServerInfo;", "syncBannerCallback", "Lorg/springframework/ai/tool/ToolCallbackProvider;", "createServerStrategy", "Lcom/embabel/agent/mcpserver/McpServerStrategy;", "createBannerTool", "getToolPublishers", "", "Lcom/embabel/agent/mcpserver/McpToolExportCallbackPublisher;", "getResourcePublishers", "Lcom/embabel/agent/mcpserver/sync/McpResourcePublisher;", "getPromptPublishers", "Lcom/embabel/agent/mcpserver/sync/McpPromptPublisher;", "convertToToolSpecifications", "", "toolCallbacks", "getExecutionMode", "", "embabel-agent-mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpSyncServerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpSyncServerConfiguration.kt\ncom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n808#2,11:156\n*S KotlinDebug\n*F\n+ 1 McpSyncServerConfiguration.kt\ncom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration\n*L\n144#1:156,11\n*E\n"})
public class McpSyncServerConfiguration
extends AbstractMcpServerConfiguration {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ServerInfo serverInfo;

    public McpSyncServerConfiguration(@NotNull ConfigurableApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(applicationContext);
        Logger logger = LoggerFactory.getLogger(McpSyncServerConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.serverInfo = ServerInfoFactory.INSTANCE.create(McpExecutionMode.SYNC);
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @Bean
    @NotNull
    public ToolCallbackProvider syncBannerCallback() {
        return this.createBannerTool();
    }

    @Override
    @NotNull
    public McpServerStrategy createServerStrategy() {
        Object object = this.getApplicationContext().getBean(McpSyncServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
        McpSyncServer syncServer = (McpSyncServer)object;
        return new SyncServerStrategy(syncServer);
    }

    @Override
    @NotNull
    public ToolCallbackProvider createBannerTool() {
        Object[] objectArray = new Object[]{new UnifiedBannerTool(this.serverInfo)};
        MethodToolCallbackProvider methodToolCallbackProvider = MethodToolCallbackProvider.builder().toolObjects(objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodToolCallbackProvider, (String)"build(...)");
        return (ToolCallbackProvider)methodToolCallbackProvider;
    }

    @Override
    @NotNull
    public List<McpToolExportCallbackPublisher> getToolPublishers() {
        return CollectionsKt.toList((Iterable)this.getApplicationContext().getBeansOfType(McpToolExportCallbackPublisher.class).values());
    }

    @NotNull
    public List<McpResourcePublisher> getResourcePublishers() {
        return CollectionsKt.toList((Iterable)this.getApplicationContext().getBeansOfType(McpResourcePublisher.class).values());
    }

    @NotNull
    public List<McpPromptPublisher> getPromptPublishers() {
        return CollectionsKt.toList((Iterable)this.getApplicationContext().getBeansOfType(McpPromptPublisher.class).values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Object> convertToToolSpecifications(@NotNull List<? extends Object> toolCallbacks) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(toolCallbacks, (String)"toolCallbacks");
        Iterable $this$filterIsInstance$iv = toolCallbacks;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ToolCallback)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List callbacks = (List)destination$iv$iv;
        List list = McpToolUtils.toSyncToolSpecification((List)callbacks);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toSyncToolSpecification(...)");
        return list;
    }

    @Override
    @NotNull
    protected String getExecutionMode() {
        return "SYNC";
    }
}

