/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.gemini;

import com.embabel.agent.config.models.gemini.GeminiModelDefinition;
import com.embabel.agent.config.models.gemini.GeminiModelDefinitions;
import com.embabel.agent.config.models.gemini.GeminiModelLoader;
import com.embabel.agent.config.models.gemini.GeminiProperties;
import com.embabel.agent.openai.OpenAiChatOptionsConverter;
import com.embabel.agent.openai.OpenAiCompatibleModelFactory;
import com.embabel.common.ai.autoconfig.LlmAutoConfigMetadataLoader;
import com.embabel.common.ai.autoconfig.ProviderInitialization;
import com.embabel.common.ai.autoconfig.RegisteredModel;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GeminiProperties.class})
@ExcludeFromJacocoGeneratedReport(reason="Gemini configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BM\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/config/models/gemini/GeminiModelsConfig;", "Lcom/embabel/agent/openai/OpenAiCompatibleModelFactory;", "envBaseUrl", "", "envApiKey", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "properties", "Lcom/embabel/agent/config/models/gemini/GeminiProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "modelLoader", "Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;", "Lcom/embabel/agent/config/models/gemini/GeminiModelDefinitions;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/beans/factory/ObjectProvider;Lcom/embabel/agent/config/models/gemini/GeminiProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lcom/embabel/common/ai/autoconfig/LlmAutoConfigMetadataLoader;)V", "geminiModelsInitializer", "Lcom/embabel/common/ai/autoconfig/ProviderInitialization;", "createGeminiLlm", "Lcom/embabel/common/ai/model/Llm;", "modelDef", "Lcom/embabel/agent/config/models/gemini/GeminiModelDefinition;", "Companion", "embabel-agent-gemini-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nGeminiModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiModelsConfig.kt\ncom/embabel/agent/config/models/gemini/GeminiModelsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1863#2,2:166\n1#3:168\n*S KotlinDebug\n*F\n+ 1 GeminiModelsConfig.kt\ncom/embabel/agent/config/models/gemini/GeminiModelsConfig\n*L\n117#1:166,2\n*E\n"})
public class GeminiModelsConfig
extends OpenAiCompatibleModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String envBaseUrl;
    @Nullable
    private final String envApiKey;
    @NotNull
    private final GeminiProperties properties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final LlmAutoConfigMetadataLoader<GeminiModelDefinitions> modelLoader;
    @NotNull
    private static final String DEFAULT_BASE_URL = "https://generativelanguage.googleapis.com/v1beta/openai";

    public GeminiModelsConfig(@Value(value="${GEMINI_BASE_URL:#{null}}") @Nullable String envBaseUrl, @Value(value="${GEMINI_API_KEY:#{null}}") @Nullable String envApiKey, @NotNull ObjectProvider<ObservationRegistry> observationRegistry, @NotNull GeminiProperties properties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull LlmAutoConfigMetadataLoader<GeminiModelDefinitions> modelLoader) {
        String string;
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter(modelLoader, (String)"modelLoader");
        String string2 = envBaseUrl;
        if (string2 == null && (string2 = properties.getBaseUrl()) == null) {
            string2 = DEFAULT_BASE_URL;
        }
        if ((string = envApiKey) == null && (string = properties.getApiKey()) == null) {
            throw new IllegalStateException("Gemini API key required: set GEMINI_API_KEY env var or embabel.agent.platform.models.gemini.api-key".toString());
        }
        Object object = observationRegistry.getIfUnique(GeminiModelsConfig::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
        super(string2, string, null, null, (ObservationRegistry)object, null, 32, null);
        this.envBaseUrl = envBaseUrl;
        this.envApiKey = envApiKey;
        this.properties = properties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.modelLoader = modelLoader;
        this.getLogger().info("Google Gemini models are available: {}", (Object)this.properties);
    }

    public /* synthetic */ GeminiModelsConfig(String string, String string2, ObjectProvider objectProvider, GeminiProperties geminiProperties, ConfigurableBeanFactory configurableBeanFactory, LlmAutoConfigMetadataLoader llmAutoConfigMetadataLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            llmAutoConfigMetadataLoader = (LlmAutoConfigMetadataLoader)new GeminiModelLoader(null, null, 3, null);
        }
        this(string, string2, (ObjectProvider<ObservationRegistry>)objectProvider, geminiProperties, configurableBeanFactory, (LlmAutoConfigMetadataLoader<GeminiModelDefinitions>)llmAutoConfigMetadataLoader);
    }

    @Bean
    @NotNull
    public ProviderInitialization geminiModelsInitializer() {
        List list;
        List $this$geminiModelsInitializer_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = ((GeminiModelDefinitions)this.modelLoader.loadAutoConfigMetadata()).getModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeminiModelDefinition modelDef = (GeminiModelDefinition)element$iv;
            boolean bl2 = false;
            try {
                Llm llm = this.createGeminiLlm(modelDef);
                this.configurableBeanFactory.registerSingleton(modelDef.getName(), (Object)llm);
                $this$geminiModelsInitializer_u24lambda_u242.add(new RegisteredModel(modelDef.getName(), modelDef.getModelId()));
                this.getLogger().info("Registered Gemini model bean: {} -> {}", (Object)modelDef.getName(), (Object)modelDef.getModelId());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{modelDef.getName(), modelDef.getModelId(), e};
                this.getLogger().error("Failed to create model: {} ({})", objectArray);
                throw e;
            }
        }
        List registeredLlms = CollectionsKt.build((List)list);
        List it = list = new ProviderInitialization("Google", registeredLlms, null, null, 12, null);
        boolean bl3 = false;
        this.getLogger().info(it.summary());
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private Llm createGeminiLlm(GeminiModelDefinition modelDef) {
        PerTokenPricingModel perTokenPricingModel;
        GeminiModelsConfig geminiModelsConfig = this;
        String string = modelDef.getModelId();
        PerTokenPricingModel perTokenPricingModel2 = modelDef.getPricingModel();
        if (perTokenPricingModel2 != null) {
            void it;
            PerTokenPricingModel perTokenPricingModel3 = perTokenPricingModel2;
            String string2 = string;
            GeminiModelsConfig geminiModelsConfig2 = geminiModelsConfig;
            boolean bl = false;
            PerTokenPricingModel perTokenPricingModel4 = new PerTokenPricingModel(it.getUsdPer1mInputTokens(), it.getUsdPer1mOutputTokens());
            geminiModelsConfig = geminiModelsConfig2;
            string = string2;
            perTokenPricingModel = perTokenPricingModel4;
        } else {
            perTokenPricingModel = null;
        }
        Intrinsics.checkNotNull(perTokenPricingModel, (String)"null cannot be cast to non-null type com.embabel.common.ai.model.PricingModel");
        return geminiModelsConfig.openAiCompatibleLlm(string, (PricingModel)perTokenPricingModel, "Google", modelDef.getKnowledgeCutoffDate(), (OptionsConverter)OpenAiChatOptionsConverter.INSTANCE, this.properties.retryTemplate(modelDef.getModelId()));
    }

    private static final ObservationRegistry _init_$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/config/models/gemini/GeminiModelsConfig$Companion;", "", "<init>", "()V", "DEFAULT_BASE_URL", "", "embabel-agent-gemini-autoconfigure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

