/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.domain.library;

import com.embabel.agent.domain.library.ContentAsset;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0003H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003JK\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/embabel/agent/domain/library/Blog;", "Lcom/embabel/agent/domain/library/ContentAsset;", "title", "", "author", "content", "timestamp", "Ljava/time/Instant;", "keywords", "", "format", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/util/Set;Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "getAuthor", "getContent", "getTimestamp", "()Ljava/time/Instant;", "getKeywords", "()Ljava/util/Set;", "getFormat", "contribution", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-domain"})
public final class Blog
implements ContentAsset {
    @NotNull
    private final String title;
    @NotNull
    private final String author;
    @NotNull
    private final String content;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final Set<String> keywords;
    @NotNull
    private final String format;

    public Blog(@NotNull String title, @NotNull String author, @NotNull String content, @NotNull Instant timestamp, @NotNull Set<String> keywords, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.title = title;
        this.author = author;
        this.content = content;
        this.timestamp = timestamp;
        this.keywords = keywords;
        this.format = format;
    }

    public /* synthetic */ Blog(String string, String string2, String string3, Instant instant, Set set, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            instant = Instant.now();
        }
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            string4 = "markdown";
        }
        this(string, string2, string3, instant, set, string4);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getAuthor() {
        return this.author;
    }

    @NotNull
    public String getContent() {
        return this.content;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Set<String> getKeywords() {
        return this.keywords;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @NotNull
    public String contribution() {
        return StringsKt.trimIndent((String)("\n            |Blog Post:\n            |Title: " + this.title + "\n            |Author: " + this.author + "\n            |Content: " + this.getContent() + "\n            |Date: " + this.getTimestamp().atZone(ZoneId.systemDefault()).toLocalDate() + "\n        "));
    }

    @NotNull
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.author;
    }

    @NotNull
    public final String component3() {
        return this.content;
    }

    @NotNull
    public final Instant component4() {
        return this.timestamp;
    }

    @NotNull
    public final Set<String> component5() {
        return this.keywords;
    }

    @NotNull
    public final String component6() {
        return this.format;
    }

    @NotNull
    public final Blog copy(@NotNull String title, @NotNull String author, @NotNull String content, @NotNull Instant timestamp, @NotNull Set<String> keywords, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new Blog(title, author, content, timestamp, keywords, format);
    }

    public static /* synthetic */ Blog copy$default(Blog blog, String string, String string2, String string3, Instant instant, Set set, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = blog.title;
        }
        if ((n & 2) != 0) {
            string2 = blog.author;
        }
        if ((n & 4) != 0) {
            string3 = blog.content;
        }
        if ((n & 8) != 0) {
            instant = blog.timestamp;
        }
        if ((n & 0x10) != 0) {
            set = blog.keywords;
        }
        if ((n & 0x20) != 0) {
            string4 = blog.format;
        }
        return blog.copy(string, string2, string3, instant, set, string4);
    }

    @NotNull
    public String toString() {
        return "Blog(title=" + this.title + ", author=" + this.author + ", content=" + this.content + ", timestamp=" + this.timestamp + ", keywords=" + this.keywords + ", format=" + this.format + ")";
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = result * 31 + this.author.hashCode();
        result = result * 31 + this.content.hashCode();
        result = result * 31 + this.timestamp.hashCode();
        result = result * 31 + ((Object)this.keywords).hashCode();
        result = result * 31 + this.format.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Blog)) {
            return false;
        }
        Blog blog = (Blog)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)blog.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.author, (Object)blog.author)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)blog.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)blog.timestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keywords, blog.keywords)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.format, (Object)blog.format);
    }
}

