/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.docker;

import com.embabel.agent.config.models.docker.DockerConnectionProperties;
import com.embabel.agent.config.models.docker.DockerRetryProperties;
import com.embabel.agent.openai.OpenAiChatOptionsConverter;
import com.embabel.common.ai.model.AiModel;
import com.embabel.common.ai.model.ConfigurableModelProviderProperties;
import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@ExcludeFromJacocoGeneratedReport(reason="Docker model configuration can't be unit tested")
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DockerRetryProperties.class, DockerConnectionProperties.class, ConfigurableModelProviderProperties.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0003\u001f !B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u0014\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0015H\u0012J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig;", "", "dockerRetryProperties", "Lcom/embabel/agent/config/models/docker/DockerRetryProperties;", "dockerConnectionProperties", "Lcom/embabel/agent/config/models/docker/DockerConnectionProperties;", "configurableBeanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "properties", "Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Lcom/embabel/agent/config/models/docker/DockerRetryProperties;Lcom/embabel/agent/config/models/docker/DockerConnectionProperties;Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;Lcom/embabel/common/ai/model/ConfigurableModelProviderProperties;Lorg/springframework/beans/factory/ObjectProvider;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "loadModels", "", "Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig$Model;", "registerModels", "", "dockerModelOf", "Lcom/embabel/common/ai/model/AiModel;", "model", "dockerEmbeddingServiceOf", "Lcom/embabel/common/ai/model/EmbeddingService;", "dockerLlmOf", "Lcom/embabel/common/ai/model/Llm;", "ModelResponse", "ModelDetails", "Model", "embabel-agent-dockermodels-autoconfigure"})
@SourceDebugExtension(value={"SMAP\nDockerLocalModelsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerLocalModelsConfig.kt\ncom/embabel/agent/config/models/docker/DockerLocalModelsConfig\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n43#2:236\n1557#3:237\n1628#3,3:238\n1863#3,2:241\n*S KotlinDebug\n*F\n+ 1 DockerLocalModelsConfig.kt\ncom/embabel/agent/config/models/docker/DockerLocalModelsConfig\n*L\n120#1:236\n122#1:237\n122#1:238,3\n146#1:241,2\n*E\n"})
public class DockerLocalModelsConfig {
    @NotNull
    private final DockerRetryProperties dockerRetryProperties;
    @NotNull
    private final DockerConnectionProperties dockerConnectionProperties;
    @NotNull
    private final ConfigurableBeanFactory configurableBeanFactory;
    @NotNull
    private final ConfigurableModelProviderProperties properties;
    @NotNull
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    private final Logger logger;

    public DockerLocalModelsConfig(@NotNull DockerRetryProperties dockerRetryProperties, @NotNull DockerConnectionProperties dockerConnectionProperties, @NotNull ConfigurableBeanFactory configurableBeanFactory, @NotNull ConfigurableModelProviderProperties properties, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)dockerRetryProperties, (String)"dockerRetryProperties");
        Intrinsics.checkNotNullParameter((Object)dockerConnectionProperties, (String)"dockerConnectionProperties");
        Intrinsics.checkNotNullParameter((Object)configurableBeanFactory, (String)"configurableBeanFactory");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        this.dockerRetryProperties = dockerRetryProperties;
        this.dockerConnectionProperties = dockerConnectionProperties;
        this.configurableBeanFactory = configurableBeanFactory;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
        this.logger = LoggerFactory.getLogger(DockerLocalModelsConfig.class);
    }

    /*
     * WARNING - void declaration
     */
    private List<Model> loadModels() {
        List list;
        try {
            List list2;
            RestClient restClient = RestClient.create();
            Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
            RestClient restClient2 = restClient;
            MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
            RestClient.ResponseSpec responseSpec = restClient2.get().uri(this.dockerConnectionProperties.getBaseUrl() + "/v1/models", new Object[0]).accept(mediaTypeArray).retrieve();
            Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
            RestClient.ResponseSpec $this$body$iv = responseSpec;
            boolean $i$f$body = false;
            ModelResponse response = (ModelResponse)$this$body$iv.body((ParameterizedTypeReference)new ParameterizedTypeReference<ModelResponse>(){});
            Object object = response;
            if (object != null && (object = ((ModelResponse)object).getData()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void modelDetails;
                    ModelDetails modelDetails2 = (ModelDetails)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Model(modelDetails.getId()));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            this.logger.warn("Failed to load models from {}: {}", (Object)this.dockerConnectionProperties.getBaseUrl(), (Object)e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @PostConstruct
    public void registerModels() {
        this.logger.info("Docker local models will be discovered at {}", (Object)this.dockerConnectionProperties.getBaseUrl());
        List<Model> models = this.loadModels();
        this.logger.info("Discovered the following Docker models:\n{}", (Object)CollectionsKt.joinToString$default((Iterable)models, (CharSequence)"\n", null, null, (int)0, null, DockerLocalModelsConfig::registerModels$lambda$1, (int)30, null));
        if (models.isEmpty()) {
            this.logger.warn("No Docker local models discovered. Check Docker server configuration.");
            return;
        }
        Iterable $this$forEach$iv = models;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Model model = (Model)element$iv;
            boolean bl = false;
            try {
                String beanName = "dockerModel-" + model.getId();
                AiModel<?> dockerModel = this.dockerModelOf(model);
                this.configurableBeanFactory.registerSingleton(beanName, dockerModel);
                Object[] objectArray = new Object[]{dockerModel.getModel().getClass().getSimpleName(), model.getId(), beanName};
                this.logger.debug("Successfully registered Docker {} {} as bean {}", objectArray);
            }
            catch (Exception e) {
                this.logger.error("Failed to register Docker model {}", (Object)model.getId(), (Object)e);
            }
        }
    }

    private AiModel<?> dockerModelOf(Model model) {
        if (!this.properties.allWellKnownEmbeddingServiceNames().contains(model.getId())) {
            return (AiModel)this.dockerLlmOf(model);
        }
        return (AiModel)this.dockerEmbeddingServiceOf(model);
    }

    private EmbeddingService dockerEmbeddingServiceOf(Model model) {
        OpenAiEmbeddingModel springEmbeddingModel = new OpenAiEmbeddingModel(new OpenAiApi.Builder().baseUrl(this.dockerConnectionProperties.getBaseUrl()).apiKey((ApiKey)new NoopApiKey()).build(), MetadataMode.EMBED, OpenAiEmbeddingOptions.builder().model(model.getId()).build());
        String string = model.getId();
        return new EmbeddingService(string, "Docker", (EmbeddingModel)springEmbeddingModel);
    }

    private Llm dockerLlmOf(Model model) {
        OpenAiChatModel chatModel = OpenAiChatModel.builder().openAiApi(new OpenAiApi.Builder().baseUrl(this.dockerConnectionProperties.getBaseUrl()).apiKey((ApiKey)new NoopApiKey()).restClientBuilder(RestClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DockerLocalModelsConfig::dockerLlmOf$lambda$3))).webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DockerLocalModelsConfig::dockerLlmOf$lambda$4))).build()).observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DockerLocalModelsConfig::dockerLlmOf$lambda$5)).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DockerLocalModelsConfig::dockerLlmOf$lambda$6)).build()).defaultOptions(OpenAiChatOptions.builder().model(model.getId()).build()).retryTemplate(this.dockerRetryProperties.retryTemplate("docker-" + model.getId())).build();
        String string = model.getId();
        Intrinsics.checkNotNull((Object)chatModel);
        OpenAiChatModel openAiChatModel = chatModel;
        OpenAiChatOptionsConverter openAiChatOptionsConverter = OpenAiChatOptionsConverter.INSTANCE;
        PricingModel pricingModel = PricingModel.Companion.getALL_YOU_CAN_EAT();
        return new Llm(string, "Docker", (ChatModel)openAiChatModel, (OptionsConverter)openAiChatOptionsConverter, null, null, pricingModel, 32, null);
    }

    private static final CharSequence registerModels$lambda$1(Model it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final ObservationRegistry dockerLlmOf$lambda$3() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry dockerLlmOf$lambda$4() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry dockerLlmOf$lambda$5() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry dockerLlmOf$lambda$6() {
        return ObservationRegistry.NOOP;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig$Model;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-dockermodels-autoconfigure"})
    private static final class Model {
        @NotNull
        private final String id;

        public Model(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Model copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new Model(id);
        }

        public static /* synthetic */ Model copy$default(Model model, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = model.id;
            }
            return model.copy(string);
        }

        @NotNull
        public String toString() {
            return "Model(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            return Intrinsics.areEqual((Object)this.id, (Object)model.id);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig$ModelDetails;", "", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-dockermodels-autoconfigure"})
    private static final class ModelDetails {
        @NotNull
        private final String id;

        public ModelDetails(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final ModelDetails copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ModelDetails(id);
        }

        public static /* synthetic */ ModelDetails copy$default(ModelDetails modelDetails, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = modelDetails.id;
            }
            return modelDetails.copy(string);
        }

        @NotNull
        public String toString() {
            return "ModelDetails(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelDetails)) {
                return false;
            }
            ModelDetails modelDetails = (ModelDetails)other;
            return Intrinsics.areEqual((Object)this.id, (Object)modelDetails.id);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig$ModelResponse;", "", "object", "", "data", "", "Lcom/embabel/agent/config/models/docker/DockerLocalModelsConfig$ModelDetails;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getObject", "()Ljava/lang/String;", "getData", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-dockermodels-autoconfigure"})
    private static final class ModelResponse {
        @NotNull
        private final String object;
        @NotNull
        private final List<ModelDetails> data;

        public ModelResponse(@NotNull String object, @NotNull List<ModelDetails> data) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.object = object;
            this.data = data;
        }

        @NotNull
        public final String getObject() {
            return this.object;
        }

        @NotNull
        public final List<ModelDetails> getData() {
            return this.data;
        }

        @NotNull
        public final String component1() {
            return this.object;
        }

        @NotNull
        public final List<ModelDetails> component2() {
            return this.data;
        }

        @NotNull
        public final ModelResponse copy(@NotNull String object, @NotNull List<ModelDetails> data) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new ModelResponse(object, data);
        }

        public static /* synthetic */ ModelResponse copy$default(ModelResponse modelResponse, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = modelResponse.object;
            }
            if ((n & 2) != 0) {
                list = modelResponse.data;
            }
            return modelResponse.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "ModelResponse(object=" + this.object + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result = this.object.hashCode();
            result = result * 31 + ((Object)this.data).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelResponse)) {
                return false;
            }
            ModelResponse modelResponse = (ModelResponse)other;
            if (!Intrinsics.areEqual((Object)this.object, (Object)modelResponse.object)) {
                return false;
            }
            return Intrinsics.areEqual(this.data, modelResponse.data);
        }
    }
}

