/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.deepseek;

import com.embabel.agent.config.models.deepseek.DeepSeekModelsConfigKt;
import com.embabel.agent.config.models.deepseek.DeepSeekProperties;
import com.embabel.agent.spi.support.springai.SpringAiLlmService;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.deepseek.DeepSeekChatModel;
import org.springframework.ai.deepseek.DeepSeekChatOptions;
import org.springframework.ai.deepseek.api.DeepSeekApi;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DeepSeekProperties.class})
@ExcludeFromJacocoGeneratedReport(reason="DeepSeek configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0013H\u0017J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/embabel/agent/config/models/deepseek/DeepSeekModelsConfig;", "", "envBaseUrl", "", "envApiKey", "properties", "Lcom/embabel/agent/config/models/deepseek/DeepSeekProperties;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/config/models/deepseek/DeepSeekProperties;Lorg/springframework/beans/factory/ObjectProvider;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "baseUrl", "apiKey", "deepSeekChat", "Lcom/embabel/agent/spi/support/springai/SpringAiLlmService;", "deepSeekReasoner", "deepSeekLlmOf", "name", "knowledgeCutoffDate", "Ljava/time/LocalDate;", "createDeepSeekApi", "Lorg/springframework/ai/deepseek/api/DeepSeekApi;", "embabel-agent-deepseek-autoconfigure"})
public class DeepSeekModelsConfig {
    @Nullable
    private final String envBaseUrl;
    @Nullable
    private final String envApiKey;
    @NotNull
    private final DeepSeekProperties properties;
    @NotNull
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    private final Logger logger;
    @Nullable
    private final String baseUrl;
    @NotNull
    private final String apiKey;

    public DeepSeekModelsConfig(@Value(value="${DEEPSEEK_BASE_URL:#{null}}") @Nullable String envBaseUrl, @Value(value="${DEEPSEEK_API_KEY:#{null}}") @Nullable String envApiKey, @NotNull DeepSeekProperties properties, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        String string;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        this.envBaseUrl = envBaseUrl;
        this.envApiKey = envApiKey;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
        this.logger = LoggerFactory.getLogger(DeepSeekModelsConfig.class);
        String string2 = this.envBaseUrl;
        if (string2 == null) {
            string2 = this.baseUrl = this.properties.getBaseUrl();
        }
        if ((string = this.envApiKey) == null && (string = this.properties.getApiKey()) == null) {
            throw new IllegalStateException("DeepSeek API key required: set DEEPSEEK_API_KEY env var or embabel.agent.platform.models.deepseek.api-key".toString());
        }
        this.apiKey = string;
        this.logger.info("DeepSeek models are available: {}", (Object)this.properties);
    }

    @Bean
    @NotNull
    public SpringAiLlmService deepSeekChat() {
        return SpringAiLlmService.copy$default((SpringAiLlmService)this.deepSeekLlmOf("deepseek-chat", LocalDate.of(2025, 8, 21)), null, null, null, null, null, null, (PricingModel)((PricingModel)new PerTokenPricingModel(0.56, 1.68)), (int)63, null);
    }

    @Bean
    @NotNull
    public SpringAiLlmService deepSeekReasoner() {
        return SpringAiLlmService.copy$default((SpringAiLlmService)this.deepSeekLlmOf("deepseek-reasoner", LocalDate.of(2025, 5, 28)), null, null, null, null, null, null, (PricingModel)((PricingModel)new PerTokenPricingModel(0.56, 1.68)), (int)63, null);
    }

    private SpringAiLlmService deepSeekLlmOf(String name, LocalDate knowledgeCutoffDate) {
        DeepSeekChatModel deepSeekChatModel = DeepSeekChatModel.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::deepSeekLlmOf$lambda$0)).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::deepSeekLlmOf$lambda$1)).build()).defaultOptions(DeepSeekChatOptions.builder().model(name).build()).deepSeekApi(this.createDeepSeekApi()).retryTemplate(this.properties.retryTemplate(name)).build();
        Intrinsics.checkNotNull((Object)deepSeekChatModel);
        DeepSeekChatModel deepSeekChatModel2 = deepSeekChatModel;
        OptionsConverter<DeepSeekChatOptions> optionsConverter = DeepSeekModelsConfigKt.getDeepSeekOptionsConverter();
        return new SpringAiLlmService(name, "Deepseek", (ChatModel)deepSeekChatModel2, optionsConverter, knowledgeCutoffDate, null, null, 96, null);
    }

    private DeepSeekApi createDeepSeekApi() {
        DeepSeekApi.Builder builder = DeepSeekApi.builder().apiKey(this.apiKey);
        CharSequence charSequence = this.baseUrl;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.logger.info("Using custom DeepSeek base URL: {}", (Object)this.baseUrl);
            builder.baseUrl(this.baseUrl);
        }
        DeepSeekApi deepSeekApi = builder.restClientBuilder(RestClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::createDeepSeekApi$lambda$2))).webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::createDeepSeekApi$lambda$3))).build();
        Intrinsics.checkNotNullExpressionValue((Object)deepSeekApi, (String)"build(...)");
        return deepSeekApi;
    }

    private static final ObservationRegistry deepSeekLlmOf$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry deepSeekLlmOf$lambda$1() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createDeepSeekApi$lambda$2() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createDeepSeekApi$lambda$3() {
        return ObservationRegistry.NOOP;
    }
}

