/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.config.models.deepseek;

import com.embabel.agent.config.models.deepseek.DeepSeekModelsConfigKt;
import com.embabel.agent.config.models.deepseek.DeepSeekProperties;
import com.embabel.common.ai.model.Llm;
import com.embabel.common.ai.model.OptionsConverter;
import com.embabel.common.ai.model.PerTokenPricingModel;
import com.embabel.common.ai.model.PricingModel;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import io.micrometer.observation.ObservationRegistry;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.deepseek.DeepSeekChatModel;
import org.springframework.ai.deepseek.DeepSeekChatOptions;
import org.springframework.ai.deepseek.api.DeepSeekApi;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ExcludeFromJacocoGeneratedReport(reason="DeepSeek configuration can't be unit tested")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B1\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0011H\u0017J\u001a\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/config/models/deepseek/DeepSeekModelsConfig;", "", "baseUrl", "", "apiKey", "properties", "Lcom/embabel/agent/config/models/deepseek/DeepSeekProperties;", "observationRegistry", "Lorg/springframework/beans/factory/ObjectProvider;", "Lio/micrometer/observation/ObservationRegistry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/config/models/deepseek/DeepSeekProperties;Lorg/springframework/beans/factory/ObjectProvider;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "deepSeekChat", "Lcom/embabel/common/ai/model/Llm;", "deepSeekReasoner", "deepSeekLlmOf", "name", "knowledgeCutoffDate", "Ljava/time/LocalDate;", "createDeepSeekApi", "Lorg/springframework/ai/deepseek/api/DeepSeekApi;", "embabel-agent-deepseek-autoconfigure"})
public class DeepSeekModelsConfig {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String apiKey;
    @NotNull
    private final DeepSeekProperties properties;
    @NotNull
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    private final Logger logger;

    public DeepSeekModelsConfig(@Value(value="${DEEPSEEK_BASE_URL:}") @NotNull String baseUrl, @Value(value="${DEEPSEEK_API_KEY}") @NotNull String apiKey, @NotNull DeepSeekProperties properties, @NotNull ObjectProvider<ObservationRegistry> observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter(observationRegistry, (String)"observationRegistry");
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.properties = properties;
        this.observationRegistry = observationRegistry;
        this.logger = LoggerFactory.getLogger(DeepSeekModelsConfig.class);
        this.logger.info("DeepSeek models are available: {}", (Object)this.properties);
    }

    @Bean
    @NotNull
    public Llm deepSeekChat() {
        return Llm.copy$default((Llm)this.deepSeekLlmOf("deepseek-chat", LocalDate.of(2025, 8, 21)), null, null, null, null, null, null, (PricingModel)((PricingModel)new PerTokenPricingModel(0.56, 1.68)), (int)63, null);
    }

    @Bean
    @NotNull
    public Llm deepSeekReasoner() {
        return Llm.copy$default((Llm)this.deepSeekLlmOf("deepseek-reasoner", LocalDate.of(2025, 5, 28)), null, null, null, null, null, null, (PricingModel)((PricingModel)new PerTokenPricingModel(0.56, 1.68)), (int)63, null);
    }

    private Llm deepSeekLlmOf(String name, LocalDate knowledgeCutoffDate) {
        DeepSeekChatModel chatModel = DeepSeekChatModel.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::deepSeekLlmOf$lambda$0)).toolCallingManager((ToolCallingManager)ToolCallingManager.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::deepSeekLlmOf$lambda$1)).build()).defaultOptions(DeepSeekChatOptions.builder().model(name).build()).deepSeekApi(this.createDeepSeekApi()).retryTemplate(this.properties.retryTemplate(name)).build();
        Intrinsics.checkNotNull((Object)chatModel);
        DeepSeekChatModel deepSeekChatModel = chatModel;
        OptionsConverter<DeepSeekChatOptions> optionsConverter = DeepSeekModelsConfigKt.getDeepSeekOptionsConverter();
        return new Llm(name, "deepseek", (ChatModel)deepSeekChatModel, optionsConverter, knowledgeCutoffDate, null, null, 96, null);
    }

    private DeepSeekApi createDeepSeekApi() {
        DeepSeekApi.Builder builder = DeepSeekApi.builder().apiKey(this.apiKey);
        if (!StringsKt.isBlank((CharSequence)this.baseUrl)) {
            this.logger.info("Using custom DeepSeek base URL: {}", (Object)this.baseUrl);
            builder.baseUrl(this.baseUrl);
        }
        DeepSeekApi deepSeekApi = builder.restClientBuilder(RestClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::createDeepSeekApi$lambda$2))).webClientBuilder(WebClient.builder().observationRegistry((ObservationRegistry)this.observationRegistry.getIfUnique(DeepSeekModelsConfig::createDeepSeekApi$lambda$3))).build();
        Intrinsics.checkNotNullExpressionValue((Object)deepSeekApi, (String)"build(...)");
        return deepSeekApi;
    }

    private static final ObservationRegistry deepSeekLlmOf$lambda$0() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry deepSeekLlmOf$lambda$1() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createDeepSeekApi$lambda$2() {
        return ObservationRegistry.NOOP;
    }

    private static final ObservationRegistry createDeepSeekApi$lambda$3() {
        return ObservationRegistry.NOOP;
    }
}

