/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.model;

import com.embabel.common.ai.model.EmbeddingService;
import com.embabel.common.ai.model.EmbeddingServiceMetadata;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ai.embedding.EmbeddingModel;

@JsonSerialize(as=EmbeddingServiceMetadata.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u000fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/embabel/common/ai/model/SpringAiEmbeddingService;", "Lcom/embabel/common/ai/model/EmbeddingService;", "name", "", "provider", "model", "Lorg/springframework/ai/embedding/EmbeddingModel;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/ai/embedding/EmbeddingModel;)V", "getName", "()Ljava/lang/String;", "getProvider", "getModel", "()Lorg/springframework/ai/embedding/EmbeddingModel;", "dimensions", "", "getDimensions", "()I", "embed", "", "text", "", "texts", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "embabel-agent-common"})
public final class SpringAiEmbeddingService
implements EmbeddingService {
    @NotNull
    private final String name;
    @NotNull
    private final String provider;
    @NotNull
    private final EmbeddingModel model;

    public SpringAiEmbeddingService(@NotNull String name, @NotNull String provider, @NotNull EmbeddingModel model) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.name = name;
        this.provider = provider;
        this.model = model;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public EmbeddingModel getModel() {
        return this.model;
    }

    @Override
    public int getDimensions() {
        return this.getModel().dimensions();
    }

    @Override
    @NotNull
    public float[] embed(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float[] fArray = this.getModel().embed(text);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"embed(...)");
        return fArray;
    }

    @Override
    @NotNull
    public List<float[]> embed(@NotNull List<String> texts) {
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        List list = this.getModel().embed(texts);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"embed(...)");
        return list;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.provider;
    }

    @NotNull
    public final EmbeddingModel component3() {
        return this.model;
    }

    @NotNull
    public final SpringAiEmbeddingService copy(@NotNull String name, @NotNull String provider, @NotNull EmbeddingModel model) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return new SpringAiEmbeddingService(name, provider, model);
    }

    public static /* synthetic */ SpringAiEmbeddingService copy$default(SpringAiEmbeddingService springAiEmbeddingService, String string, String string2, EmbeddingModel embeddingModel, int n, Object object) {
        if ((n & 1) != 0) {
            string = springAiEmbeddingService.name;
        }
        if ((n & 2) != 0) {
            string2 = springAiEmbeddingService.provider;
        }
        if ((n & 4) != 0) {
            embeddingModel = springAiEmbeddingService.model;
        }
        return springAiEmbeddingService.copy(string, string2, embeddingModel);
    }

    @NotNull
    public String toString() {
        return "SpringAiEmbeddingService(name=" + this.name + ", provider=" + this.provider + ", model=" + this.model + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.provider.hashCode();
        result = result * 31 + this.model.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpringAiEmbeddingService)) {
            return false;
        }
        SpringAiEmbeddingService springAiEmbeddingService = (SpringAiEmbeddingService)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)springAiEmbeddingService.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.provider, (Object)springAiEmbeddingService.provider)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.model, (Object)springAiEmbeddingService.model);
    }
}

