/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.converters.streaming;

import com.embabel.common.ai.converters.FilteringJacksonOutputConverter;
import com.embabel.common.ai.converters.streaming.support.ThinkingDetector;
import com.embabel.common.core.streaming.StreamingEvent;
import com.embabel.common.core.streaming.ThinkingState;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ParameterizedTypeReference;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bB/\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u00102\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/embabel/common/ai/converters/streaming/StreamingJacksonOutputConverter;", "T", "Lcom/embabel/common/ai/converters/FilteringJacksonOutputConverter;", "clazz", "Ljava/lang/Class;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "propertyFilter", "Ljava/util/function/Predicate;", "", "<init>", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/function/Predicate;)V", "typeReference", "Lorg/springframework/core/ParameterizedTypeReference;", "(Lorg/springframework/core/ParameterizedTypeReference;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/function/Predicate;)V", "convertStream", "Lreactor/core/publisher/Flux;", "jsonlContent", "convertStreamWithThinking", "Lcom/embabel/common/core/streaming/StreamingEvent;", "text", "getFormat", "embabel-agent-common"})
public final class StreamingJacksonOutputConverter<T>
extends FilteringJacksonOutputConverter<T> {
    public StreamingJacksonOutputConverter(@NotNull Class<T> clazz, @NotNull ObjectMapper objectMapper, @NotNull Predicate<String> propertyFilter) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(propertyFilter, (String)"propertyFilter");
        super(clazz, objectMapper, propertyFilter);
    }

    public /* synthetic */ StreamingJacksonOutputConverter(Class clazz, ObjectMapper objectMapper, Predicate predicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            predicate = StreamingJacksonOutputConverter::_init_$lambda$0;
        }
        this(clazz, objectMapper, predicate);
    }

    public StreamingJacksonOutputConverter(@NotNull ParameterizedTypeReference<T> typeReference, @NotNull ObjectMapper objectMapper, @NotNull Predicate<String> propertyFilter) {
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(propertyFilter, (String)"propertyFilter");
        super(typeReference, objectMapper, propertyFilter);
    }

    public /* synthetic */ StreamingJacksonOutputConverter(ParameterizedTypeReference parameterizedTypeReference, ObjectMapper objectMapper, Predicate predicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            predicate = StreamingJacksonOutputConverter::_init_$lambda$1;
        }
        this(parameterizedTypeReference, objectMapper, predicate);
    }

    @NotNull
    public final Flux<T> convertStream(@NotNull String jsonlContent) {
        Intrinsics.checkNotNullParameter((Object)jsonlContent, (String)"jsonlContent");
        Flux flux = this.convertStreamWithThinking(jsonlContent).filter(arg_0 -> StreamingJacksonOutputConverter.convertStream$lambda$3(StreamingJacksonOutputConverter::convertStream$lambda$2, arg_0)).map(arg_0 -> StreamingJacksonOutputConverter.convertStream$lambda$5(StreamingJacksonOutputConverter::convertStream$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public final Flux<StreamingEvent<T>> convertStreamWithThinking(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Flux flux = Flux.fromIterable((Iterable)StringsKt.lines((CharSequence)text)).filter(arg_0 -> StreamingJacksonOutputConverter.convertStreamWithThinking$lambda$7(StreamingJacksonOutputConverter::convertStreamWithThinking$lambda$6, arg_0)).handle((arg_0, arg_1) -> StreamingJacksonOutputConverter.convertStreamWithThinking$lambda$9((arg_0, arg_1) -> StreamingJacksonOutputConverter.convertStreamWithThinking$lambda$8(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"handle(...)");
        return flux;
    }

    @Override
    @NotNull
    public String getFormat() {
        return StringsKt.trimMargin$default((String)("|\n           |Your response should be in JSONL (JSON Lines) format.\n           |Each line must contain exactly one JSON object that strictly adheres to the provided schema.\n           |Do not include any explanations in the JSON objects themselves.\n           |Do not include markdown code blocks or wrap responses in arrays.\n           |Ensure RFC7464 compliant JSON Lines, one valid JSON object per line.\n           |\n           |You may include reasoning content using thinking blocks.\n           |Use EXACTLY the <think> tag format - do not use variations like <thinking>, <thought>, or <analysis>.\n           |<think>your reasoning here\n           |another line of thinking</think>\n           |\n           |Thinking blocks are separate from JSON objects and can appear before, between, or after JSON lines as needed for your analysis.\n           |\n           |Here is the JSON Schema instance each JSON object must adhere to:\n           |```" + this.getJsonSchema() + "```\n           |\n           |Example format:\n           |<think>analyzing the requirements</think>\n           |{\"field\": \"precise_value\"}\n           |<think>considering next item</think>\n           |{\"field\": \"another_precise_value\"}\n           |"), null, (int)1, null);
    }

    private static final boolean _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean _init_$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean convertStream$lambda$2(StreamingEvent event) {
        return event.isObject();
    }

    private static final boolean convertStream$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object convertStream$lambda$4(StreamingEvent event) {
        Object object = event.getObject();
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private static final Object convertStream$lambda$5(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final boolean convertStreamWithThinking$lambda$6(String it) {
        Intrinsics.checkNotNull((Object)it);
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final boolean convertStreamWithThinking$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit convertStreamWithThinking$lambda$8(StreamingJacksonOutputConverter this$0, String line, SynchronousSink sink) {
        try {
            Intrinsics.checkNotNull((Object)line);
            ThinkingState thinkingState = ThinkingDetector.INSTANCE.detectThinkingState(line);
            if (WhenMappings.$EnumSwitchMapping$0[thinkingState.ordinal()] == 1) {
                Object result = super.convert(line);
                if (result != null) {
                    sink.next((Object)new StreamingEvent.Object(result));
                }
            } else {
                String thinkingContent = ThinkingDetector.INSTANCE.extractThinkingContent(line);
                sink.next((Object)new StreamingEvent.Thinking(thinkingContent, thinkingState));
            }
        }
        catch (Exception e) {
            sink.error((Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void convertStreamWithThinking$lambda$9(Function2 $tmp0, Object p0, SynchronousSink p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThinkingState.values().length];
            try {
                nArray[ThinkingState.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

