/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import java.lang.reflect.Type;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.util.LoggingMarkers;
import org.springframework.core.ParameterizedTypeReference;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u001f\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/embabel/common/ai/converters/JacksonOutputConverter;", "T", "Lorg/springframework/ai/converter/StructuredOutputConverter;", "type", "Ljava/lang/reflect/Type;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/reflect/Type;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "typeReference", "Lorg/springframework/core/ParameterizedTypeReference;", "(Lorg/springframework/core/ParameterizedTypeReference;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "jsonSchema", "", "getJsonSchema", "()Ljava/lang/String;", "jsonSchema$delegate", "Lkotlin/Lazy;", "postProcessSchema", "", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "convert", "text", "(Ljava/lang/String;)Ljava/lang/Object;", "unwrapJson", "getFormat", "embabel-agent-common"})
public class JacksonOutputConverter<T>
implements StructuredOutputConverter<T> {
    @NotNull
    private final Type type;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy jsonSchema$delegate;

    protected JacksonOutputConverter(@NotNull Type type, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.type = type;
        this.objectMapper = objectMapper;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.jsonSchema$delegate = LazyKt.lazy(() -> JacksonOutputConverter.jsonSchema_delegate$lambda$0(this));
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JacksonOutputConverter(@NotNull Class<T> clazz, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this((Type)clazz, objectMapper);
    }

    public JacksonOutputConverter(@NotNull ParameterizedTypeReference<T> typeReference, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Type type = typeReference.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        this(type, objectMapper);
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getJsonSchema() {
        Lazy lazy = this.jsonSchema$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    protected void postProcessSchema(@NotNull JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
    }

    @Nullable
    public T convert(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String unwrapped = this.unwrapJson(text);
        try {
            return (T)this.objectMapper.readValue(unwrapped, this.objectMapper.constructType(this.type));
        }
        catch (JsonProcessingException e) {
            this.logger.error(LoggingMarkers.SENSITIVE_DATA_MARKER, "Could not parse the given text to the desired target type: \"{}\" into {}", (Object)unwrapped, (Object)this.type);
            throw new RuntimeException(e);
        }
    }

    private final String unwrapJson(String text) {
        String result = ((Object)StringsKt.trim((CharSequence)text)).toString();
        if (StringsKt.startsWith$default((String)result, (String)"```", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)result, (String)"```", (boolean)false, (int)2, null)) {
            result = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)result, (CharSequence)"```json"), (CharSequence)"```"), (CharSequence)"```"))).toString();
        }
        return result;
    }

    @NotNull
    public String getFormat() {
        return StringsKt.trimMargin$default((String)("|\n           |Your response should be in JSON format.\n           |Do not include any explanations, only provide a RFC8259 compliant JSON response following this format without deviation.\n           |Do not include markdown code blocks in your response.\n           |Remove the ```json markdown from the output.\n           |Here is the JSON Schema instance your output must adhere to:\n           |```" + this.getJsonSchema() + "```\n           |"), null, (int)1, null);
    }

    private static final String jsonSchema_delegate$lambda$0(JacksonOutputConverter this$0) {
        String string;
        JacksonOption[] jacksonOptionArray = new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED, JacksonOption.RESPECT_JSONPROPERTY_ORDER};
        JacksonModule jacksonModule = new JacksonModule(jacksonOptionArray);
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).with(Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, new Option[0]);
        SchemaGeneratorConfig config = configBuilder.build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode objectNode = generator.generateSchema(this$0.type, new Type[0]);
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"generateSchema(...)");
        JsonNode jsonNode = (JsonNode)objectNode;
        this$0.postProcessSchema(jsonNode);
        ObjectWriter objectWriter = this$0.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed(System.lineSeparator())));
        try {
            string = objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            this$0.logger.error("Could not pretty print json schema for jsonNode: {}", (Object)jsonNode);
            throw new RuntimeException("Could not pretty print json schema for " + this$0.type, e);
        }
        return string;
    }
}

