/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.coding.tools.ci;

import com.embabel.agent.tools.DirectoryBased;
import com.embabel.coding.tools.ci.BuildOptions;
import com.embabel.coding.tools.ci.BuildResult;
import com.embabel.coding.tools.ci.BuildStatus;
import com.embabel.coding.tools.ci.BuildSystemIntegration;
import com.embabel.coding.tools.ci.CiTools;
import com.embabel.coding.tools.jvm.MavenBuildSystemIntegration;
import com.embabel.common.util.TimeKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/embabel/coding/tools/ci/Ci;", "Lcom/embabel/agent/tools/DirectoryBased;", "root", "", "buildSystemIntegrations", "", "Lcom/embabel/coding/tools/ci/BuildSystemIntegration;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getRoot", "()Ljava/lang/String;", "getBuildSystemIntegrations", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "detectCIEnvironment", "", "buildAndParse", "Lcom/embabel/coding/tools/ci/BuildResult;", "buildOptions", "Lcom/embabel/coding/tools/ci/BuildOptions;", "parseBuildOutput", "rawOutput", "runningTime", "Ljava/time/Duration;", "parseOutput", "Lcom/embabel/coding/tools/ci/BuildStatus;", "build", "embabel-agent-code"})
@SourceDebugExtension(value={"SMAP\nCi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ci.kt\ncom/embabel/coding/tools/ci/Ci\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,243:1\n1755#2,3:244\n1#3:247\n27#4:248\n*S KotlinDebug\n*F\n+ 1 Ci.kt\ncom/embabel/coding/tools/ci/Ci\n*L\n93#1:244,3\n226#1:248\n*E\n"})
public final class Ci
implements DirectoryBased {
    @NotNull
    private final String root;
    @NotNull
    private final List<BuildSystemIntegration> buildSystemIntegrations;
    private final Logger logger;

    public Ci(@NotNull String root, @NotNull List<? extends BuildSystemIntegration> buildSystemIntegrations) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(buildSystemIntegrations, (String)"buildSystemIntegrations");
        this.root = root;
        this.buildSystemIntegrations = buildSystemIntegrations;
        this.logger = LoggerFactory.getLogger(Ci.class);
    }

    public /* synthetic */ Ci(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf((Object)new MavenBuildSystemIntegration());
        }
        this(string, list);
    }

    @NotNull
    public String getRoot() {
        return this.root;
    }

    @NotNull
    public final List<BuildSystemIntegration> getBuildSystemIntegrations() {
        return this.buildSystemIntegrations;
    }

    private final boolean detectCIEnvironment() {
        boolean bl;
        block3: {
            Object[] objectArray = new String[]{"CI", "CONTINUOUS_INTEGRATION", "BUILD_NUMBER", "RUN_ID", "GITHUB_ACTIONS", "GITLAB_CI", "JENKINS_URL", "TRAVIS", "CIRCLECI", "BAMBOO_BUILD_NUMBER", "TF_BUILD", "BUILDKITE"};
            List ciEnvVars = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = ciEnvVars;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String envVar = (String)element$iv;
                    boolean bl2 = false;
                    String string = System.getenv(envVar);
                    boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl || System.console() == null;
    }

    @NotNull
    public final BuildResult buildAndParse(@NotNull BuildOptions buildOptions) {
        Intrinsics.checkNotNullParameter((Object)buildOptions, (String)"buildOptions");
        Pair pair = TimeKt.time(() -> Ci.buildAndParse$lambda$1(this, buildOptions));
        String rawOutput = (String)pair.component1();
        long ms = ((Number)pair.component2()).longValue();
        Duration duration = Duration.ofMillis(ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        BuildResult buildResult = new BuildResult(null, rawOutput, null, duration, 4, null);
        BuildStatus buildStatus = this.parseOutput(buildResult.getRawOutput());
        return BuildResult.copy$default(buildResult, buildStatus, null, null, null, 14, null);
    }

    @NotNull
    public final BuildResult parseBuildOutput(@NotNull String rawOutput, @NotNull Duration runningTime) {
        Intrinsics.checkNotNullParameter((Object)rawOutput, (String)"rawOutput");
        Intrinsics.checkNotNullParameter((Object)runningTime, (String)"runningTime");
        BuildResult buildResult = new BuildResult(null, rawOutput, null, runningTime, 4, null);
        BuildStatus buildStatus = this.parseOutput(buildResult.getRawOutput());
        return BuildResult.copy$default(buildResult, buildStatus, null, null, null, 14, null);
    }

    private final BuildStatus parseOutput(String rawOutput) {
        for (BuildSystemIntegration b : this.buildSystemIntegrations) {
            BuildStatus status = b.parseBuildOutput(this.getRoot(), rawOutput);
            if (status == null) continue;
            return status;
        }
        return new BuildStatus(false, "No build system understands this output: Are you sure the build command is correct?\n" + rawOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String build(@NotNull BuildOptions buildOptions) {
        Intrinsics.checkNotNullParameter((Object)buildOptions, (String)"buildOptions");
        this.logger.info("Running build command <{}> in root directory {}", (Object)buildOptions.getBuildCommand(), (Object)this.getRoot());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(Paths.get(this.getRoot(), new String[0]).toFile());
        CharSequence charSequence = buildOptions.getBuildCommand();
        Regex regex = new Regex("\\s+");
        int n = 0;
        List commandParts = regex.split(charSequence, n);
        processBuilder.command(commandParts);
        try {
            String string;
            String string2;
            Object exitCode3;
            Process process = null;
            StringBuilder outputBuilder = new StringBuilder();
            if (buildOptions.getInteractive()) {
                boolean isCI = this.detectCIEnvironment();
                if (isCI) {
                    Object it;
                    this.logger.info("CI environment detected, falling back to non-interactive mode");
                    processBuilder.redirectErrorStream(true);
                    process = processBuilder.start();
                    InputStream inputStream = process.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    Closeable closeable = inputStream;
                    Object object = Charsets.UTF_8;
                    Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n2 = 8192;
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
                    object = null;
                    try {
                        it = (BufferedReader)closeable;
                        boolean bl = false;
                        it = TextStreamsKt.readText((Reader)((Reader)it));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    Object output = it;
                    outputBuilder.append((String)output);
                    int exitCode2 = process.waitFor();
                    return exitCode2 == 0 ? "Command executed successfully in CI mode:\n" + (String)output : "Command failed with exit code " + exitCode2 + " in CI mode:\n" + (String)output;
                }
                processBuilder.inheritIO();
                process = processBuilder.start();
                int exitCode3 = process.waitFor();
                return exitCode3 == 0 ? "Interactive command executed successfully" : "Interactive command failed with exit code " + exitCode3;
            }
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            if (buildOptions.getStreamOutput()) {
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable isCI = inputStream;
                exitCode3 = Charsets.UTF_8;
                Reader exitCode2 = new InputStreamReader((InputStream)isCI, (Charset)exitCode3);
                int n3 = 8192;
                isCI = exitCode2 instanceof BufferedReader ? (BufferedReader)exitCode2 : new BufferedReader(exitCode2, n3);
                exitCode3 = null;
                try {
                    BufferedReader reader = (BufferedReader)isCI;
                    boolean bl = false;
                    String line = null;
                    while (true) {
                        String string3;
                        String it = string3 = reader.readLine();
                        boolean bl2 = false;
                        line = it;
                        if (string3 == null) break;
                        System.out.println((Object)line);
                        outputBuilder.append(line).append("\n");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    exitCode3 = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)isCI, (Throwable)exitCode3);
                }
            }
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            exitCode3 = inputStream;
            Object object = Charsets.UTF_8;
            Reader bl = new InputStreamReader((InputStream)exitCode3, (Charset)object);
            int line = 8192;
            exitCode3 = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, line);
            object = null;
            try {
                BufferedReader it = (BufferedReader)exitCode3;
                boolean bl3 = false;
                string2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)exitCode3, (Throwable)object);
            }
            String output = string2;
            outputBuilder.append(output);
            int exitCode4 = process.waitFor();
            String string4 = outputBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String output2 = string4;
            if (exitCode4 == 0) {
                this.logger.info("\u2705 Build command <{}> in root directory {}", (Object)buildOptions.getBuildCommand(), (Object)this.getRoot());
                string = "Command executed successfully:\n" + output2;
            } else {
                this.logger.info("\u274c Build command <{}> in root directory {}", (Object)buildOptions.getBuildCommand(), (Object)this.getRoot());
                string = "Command failed with exit code " + exitCode4 + ":\n" + output2;
            }
            return string;
        }
        catch (Exception e) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(CiTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("Error executing command: " + buildOptions.getBuildCommand(), (Throwable)e);
            return "Error executing command: " + e.getMessage();
        }
    }

    private static final String buildAndParse$lambda$1(Ci this$0, BuildOptions $buildOptions) {
        return this$0.build($buildOptions);
    }
}

