/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.coding.tools.bash;

import com.embabel.agent.api.annotation.LlmTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/embabel/coding/tools/bash/BashTools;", "", "workingDirectory", "", "<init>", "(Ljava/lang/String;)V", "runBashCommand", "command", "embabel-agent-code"})
public final class BashTools {
    @NotNull
    private final String workingDirectory;

    public BashTools(@NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
    }

    @LlmTool(description="Generic bash tool")
    @NotNull
    public final String runBashCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Object object = new String[]{"/bin/bash", "-c", command};
        Process process = new ProcessBuilder((String)object).directory(new File(this.workingDirectory)).redirectErrorStream(true).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        object = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object, charset);
        int n = 8192;
        return TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
    }
}

